/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.sql.impl;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.L2TeleportLocation;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeleportLocationTable {
    private static final Logger LOG = LoggerFactory.getLogger(TeleportLocationTable.class);
    private final Map<Integer, L2TeleportLocation> _teleports = new HashMap<Integer, L2TeleportLocation>();

    protected TeleportLocationTable() {
        this.reloadAll();
    }

    public void reloadAll() {
        this._teleports.clear();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT id, loc_x, loc_y, loc_z, price, fornoble, itemId FROM teleport");){
            while (rs.next()) {
                L2TeleportLocation teleport = new L2TeleportLocation();
                teleport.setTeleId(rs.getInt("id"));
                teleport.setLocX(rs.getInt("loc_x"));
                teleport.setLocY(rs.getInt("loc_y"));
                teleport.setLocZ(rs.getInt("loc_z"));
                teleport.setPrice(rs.getInt("price"));
                teleport.setIsForNoble(rs.getInt("fornoble") == 1);
                teleport.setItemId(rs.getInt("itemId"));
                this._teleports.put(teleport.getTeleId(), teleport);
            }
            LOG.info("Loaded {} teleport location templates.", (Object)this._teleports.size());
        }
        catch (Exception ex) {
            LOG.error("There has been an error loading teleport table.", ex);
        }
        if (Configuration.general().customTeleportTable()) {
            int _cTeleCount = this._teleports.size();
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 Statement s = con.createStatement();
                 ResultSet rs = s.executeQuery("SELECT id, loc_x, loc_y, loc_z, price, fornoble, itemId FROM custom_teleport");){
                while (rs.next()) {
                    L2TeleportLocation teleport = new L2TeleportLocation();
                    teleport.setTeleId(rs.getInt("id"));
                    teleport.setLocX(rs.getInt("loc_x"));
                    teleport.setLocY(rs.getInt("loc_y"));
                    teleport.setLocZ(rs.getInt("loc_z"));
                    teleport.setPrice(rs.getInt("price"));
                    teleport.setIsForNoble(rs.getInt("fornoble") == 1);
                    teleport.setItemId(rs.getInt("itemId"));
                    this._teleports.put(teleport.getTeleId(), teleport);
                }
                _cTeleCount = this._teleports.size() - _cTeleCount;
                if (_cTeleCount > 0) {
                    LOG.info("Loaded {} custom teleport location templates.", (Object)_cTeleCount);
                }
            }
            catch (Exception ex) {
                LOG.warn("There has been an error while creating custom teleport table!", ex);
            }
        }
    }

    public L2TeleportLocation getTemplate(int id) {
        return this._teleports.get(id);
    }

    public static TeleportLocationTable getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final TeleportLocationTable INSTANCE = new TeleportLocationTable();

        private SingletonHolder() {
        }
    }
}

