/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.buylist.L2BuyList;
import com.l2jserver.gameserver.model.buylist.Product;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.util.IXmlReader;
import com.l2jserver.gameserver.util.file.filter.NumericNameFilter;
import java.io.File;
import java.io.FileFilter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class BuyListData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(BuyListData.class);
    private static final FileFilter NUMERIC_FILTER = new NumericNameFilter();
    private final Map<Integer, L2BuyList> _buyLists = new HashMap<Integer, L2BuyList>();

    protected BuyListData() {
        this.load();
    }

    @Override
    public synchronized void load() {
        this._buyLists.clear();
        this.parseDatapackDirectory("data/buylists", false);
        if (Configuration.general().customBuyListLoad()) {
            this.parseDatapackDirectory("data/buylists/custom", false);
        }
        LOG.info("Loaded {} buy lists.", (Object)this._buyLists.size());
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement statement = con.createStatement();
             ResultSet rs = statement.executeQuery("SELECT * FROM `buylists`");){
            while (rs.next()) {
                int buyListId = rs.getInt("buylist_id");
                int itemId = rs.getInt("item_id");
                long count = rs.getLong("count");
                long nextRestockTime = rs.getLong("next_restock_time");
                L2BuyList buyList = this.getBuyList(buyListId);
                if (buyList == null) {
                    LOG.warn("Buy list {} found in database but not loaded from XML!", (Object)buyListId);
                    continue;
                }
                Product product = buyList.getProductByItemId(itemId);
                if (product == null) {
                    LOG.warn("Item Id {} found in database but not loaded from XML {}!", (Object)itemId, (Object)buyListId);
                    continue;
                }
                if (count >= product.getMaxCount()) continue;
                product.setCount(count);
                product.restartRestockTask(nextRestockTime);
            }
        }
        catch (Exception ex) {
            LOG.warn("Failed to load buy list data from database.", ex);
        }
    }

    @Override
    public void parseDocument(Document doc, File f) {
        try {
            int buyListId = Integer.parseInt(f.getName().replaceAll(".xml", ""));
            for (Node node = doc.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"list".equalsIgnoreCase(node.getNodeName())) continue;
                L2BuyList buyList = new L2BuyList(buyListId);
                for (Node list_node = node.getFirstChild(); list_node != null; list_node = list_node.getNextSibling()) {
                    if ("item".equalsIgnoreCase(list_node.getNodeName())) {
                        L2Item item;
                        long price = -1L;
                        long restockDelay = -1L;
                        long count = -1L;
                        NamedNodeMap attrs = list_node.getAttributes();
                        Node attr = attrs.getNamedItem("id");
                        int itemId = Integer.parseInt(attr.getNodeValue());
                        attr = attrs.getNamedItem("price");
                        if (attr != null) {
                            price = Long.parseLong(attr.getNodeValue());
                        }
                        if ((attr = attrs.getNamedItem("restock_delay")) != null) {
                            restockDelay = Long.parseLong(attr.getNodeValue());
                        }
                        if ((attr = attrs.getNamedItem("count")) != null) {
                            count = Long.parseLong(attr.getNodeValue());
                        }
                        if ((item = ItemTable.getInstance().getTemplate(itemId)) != null) {
                            buyList.addProduct(new Product(buyList.getListId(), item, price, restockDelay, count));
                            continue;
                        }
                        LOG.warn("Item not found. BuyList: {} Item ID: {} File: {}", buyList.getListId(), itemId, f.getName());
                        continue;
                    }
                    if (!"npcs".equalsIgnoreCase(list_node.getNodeName())) continue;
                    for (Node npcs_node = list_node.getFirstChild(); npcs_node != null; npcs_node = npcs_node.getNextSibling()) {
                        if (!"npc".equalsIgnoreCase(npcs_node.getNodeName())) continue;
                        int npcId = Integer.parseInt(npcs_node.getTextContent());
                        buyList.addAllowedNpc(npcId);
                    }
                }
                this._buyLists.put(buyList.getListId(), buyList);
            }
        }
        catch (Exception ex) {
            LOG.warn("Failed to load buy list data from XML {}!", (Object)f.getName(), (Object)ex);
        }
    }

    @Override
    public FileFilter getCurrentFileFilter() {
        return NUMERIC_FILTER;
    }

    public L2BuyList getBuyList(int listId) {
        return this._buyLists.get(listId);
    }

    public static BuyListData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final BuyListData INSTANCE = new BuyListData();

        private SingletonHolder() {
        }
    }
}

