/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.base.ClassInfo;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ClassListData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(ClassListData.class);
    private final Map<ClassId, ClassInfo> _classData = new HashMap<ClassId, ClassInfo>();

    protected ClassListData() {
        this.load();
    }

    @Override
    public void load() {
        this._classData.clear();
        this.parseDatapackFile("data/stats/chars/classList.xml");
        LOG.info("Loaded {} class data.", (Object)this._classData.size());
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equals(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                NamedNodeMap attrs = d.getAttributes();
                if (!"class".equals(d.getNodeName())) continue;
                Node attr = attrs.getNamedItem("classId");
                ClassId classId = ClassId.getClassId(this.parseInteger(attr));
                attr = attrs.getNamedItem("name");
                String className = attr.getNodeValue();
                attr = attrs.getNamedItem("parentClassId");
                ClassId parentClassId = attr != null ? ClassId.getClassId(this.parseInteger(attr)) : null;
                this._classData.put(classId, new ClassInfo(classId, className, parentClassId));
            }
        }
    }

    public Map<ClassId, ClassInfo> getClassList() {
        return this._classData;
    }

    public ClassInfo getClass(ClassId classId) {
        return this._classData.get(classId);
    }

    public ClassInfo getClass(int classId) {
        ClassId id = ClassId.getClassId(classId);
        return id != null ? this._classData.get(id) : null;
    }

    public static ClassListData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final ClassListData INSTANCE = new ClassListData();

        private SingletonHolder() {
        }
    }
}

