/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.options.EnchantOptions;
import com.l2jserver.gameserver.util.IXmlReader;
import com.l2jserver.gameserver.util.Util;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EnchantItemOptionsData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(EnchantItemOptionsData.class);
    private final Map<Integer, Map<Integer, EnchantOptions>> _data = new HashMap<Integer, Map<Integer, EnchantOptions>>();

    protected EnchantItemOptionsData() {
        this.load();
    }

    @Override
    public synchronized void load() {
        this._data.clear();
        this.parseDatapackFile("data/enchantItemOptions.xml");
    }

    @Override
    public void parseDocument(Document doc) {
        int counter = 0;
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"item".equalsIgnoreCase(d.getNodeName())) continue;
                int itemId = this.parseInteger(d.getAttributes(), "id");
                if (!this._data.containsKey(itemId)) {
                    this._data.put(itemId, new HashMap());
                }
                for (Node cd = d.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                    if (!"options".equalsIgnoreCase(cd.getNodeName())) continue;
                    EnchantOptions op = new EnchantOptions(this.parseInteger(cd.getAttributes(), "level"));
                    this._data.get(itemId).put(op.getLevel(), op);
                    for (byte i = 0; i < 3; i = (byte)((byte)(i + 1))) {
                        Node att = cd.getAttributes().getNamedItem("option" + (i + 1));
                        if (att == null || !Util.isDigit(att.getNodeValue())) continue;
                        op.setOption(i, this.parseInteger(att));
                    }
                    ++counter;
                }
            }
        }
        LOG.info("Loaded {} items and {} options.", (Object)this._data.size(), (Object)counter);
    }

    public EnchantOptions getOptions(int itemId, int enchantLevel) {
        if (!this._data.containsKey(itemId) || !this._data.get(itemId).containsKey(enchantLevel)) {
            return null;
        }
        return this._data.get(itemId).get(enchantLevel);
    }

    public EnchantOptions getOptions(L2ItemInstance item) {
        return item != null ? this.getOptions(item.getId(), item.getEnchantLevel()) : null;
    }

    public static EnchantItemOptionsData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final EnchantItemOptionsData _instance = new EnchantItemOptionsData();

        private SingletonHolder() {
        }
    }
}

