/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.fishing.L2FishingMonster;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class FishingMonstersData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(FishingMonstersData.class);
    private final Map<Integer, L2FishingMonster> _fishingMonstersData = new HashMap<Integer, L2FishingMonster>();

    protected FishingMonstersData() {
        this.load();
    }

    @Override
    public void load() {
        this._fishingMonstersData.clear();
        this.parseDatapackFile("data/stats/fishing/fishingMonsters.xml");
        LOG.info("Loaded {} fishing monsters.", (Object)this._fishingMonstersData.size());
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"fishingMonster".equalsIgnoreCase(d.getNodeName())) continue;
                NamedNodeMap attrs = d.getAttributes();
                StatsSet set = new StatsSet();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node att = attrs.item(i);
                    set.set(att.getNodeName(), att.getNodeValue());
                }
                L2FishingMonster fishingMonster = new L2FishingMonster(set);
                this._fishingMonstersData.put(fishingMonster.getFishingMonsterId(), fishingMonster);
            }
        }
    }

    public L2FishingMonster getFishingMonster(int lvl) {
        for (L2FishingMonster fishingMonster : this._fishingMonstersData.values()) {
            if (lvl < fishingMonster.getUserMinLevel() || lvl > fishingMonster.getUserMaxLevel()) continue;
            return fishingMonster;
        }
        return null;
    }

    public L2FishingMonster getFishingMonsterById(int id) {
        if (this._fishingMonstersData.containsKey(id)) {
            return this._fishingMonstersData.get(id);
        }
        return null;
    }

    public static FishingMonstersData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final FishingMonstersData INSTANCE = new FishingMonstersData();

        private SingletonHolder() {
        }
    }
}

