/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.multisell.Entry;
import com.l2jserver.gameserver.model.multisell.Ingredient;
import com.l2jserver.gameserver.model.multisell.ListContainer;
import com.l2jserver.gameserver.model.multisell.PreparedListContainer;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.MultiSellList;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.util.IXmlReader;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.gameserver.util.file.filter.NumericNameFilter;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class MultisellData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(MultisellData.class);
    public static final int PAGE_SIZE = 40;
    public static final int PC_BANG_POINTS = -100;
    public static final int CLAN_REPUTATION = -200;
    public static final int FAME = -300;
    private static final FileFilter NUMERIC_FILTER = new NumericNameFilter();
    private final Map<Integer, ListContainer> _entries = new HashMap<Integer, ListContainer>();

    protected MultisellData() {
        this.load();
    }

    @Override
    public void load() {
        this._entries.clear();
        this.parseDatapackDirectory("data/multisell", false);
        if (Configuration.general().customMultisellLoad()) {
            this.parseDatapackDirectory("data/multisell/custom", false);
        }
        this.verify();
        LOG.info("Loaded {} multisell lists.", (Object)this._entries.size());
    }

    @Override
    public void parseDocument(Document doc, File f) {
        try {
            int id = Integer.parseInt(f.getName().replaceAll(".xml", ""));
            int entryId = 1;
            ListContainer list = new ListContainer(id);
            for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
                Node att = n.getAttributes().getNamedItem("applyTaxes");
                list.setApplyTaxes(att != null && Boolean.parseBoolean(att.getNodeValue()));
                att = n.getAttributes().getNamedItem("useRate");
                if (att != null) {
                    try {
                        list.setUseRate(Double.parseDouble(att.getNodeValue()));
                        if (list.getUseRate() <= 1.0E-6) {
                            throw new NumberFormatException("The value cannot be 0");
                        }
                    }
                    catch (NumberFormatException ex) {
                        LOG.warn("Unable to parse {}!", (Object)doc.getLocalName(), (Object)ex);
                        list.setUseRate(1.0);
                    }
                    catch (DOMException ex) {
                        LOG.warn("Unable to parse {}!", (Object)doc.getLocalName(), (Object)ex);
                    }
                }
                list.setMaintainEnchantment((att = n.getAttributes().getNamedItem("maintainEnchantment")) != null && Boolean.parseBoolean(att.getNodeValue()));
                for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    if ("item".equalsIgnoreCase(d.getNodeName())) {
                        Entry e = this.parseEntry(d, entryId++, list);
                        list.getEntries().add(e);
                        continue;
                    }
                    if (!"npcs".equalsIgnoreCase(d.getNodeName())) continue;
                    for (Node b = d.getFirstChild(); b != null; b = b.getNextSibling()) {
                        if (!"npc".equalsIgnoreCase(b.getNodeName()) || !Util.isDigit(b.getTextContent())) continue;
                        list.allowNpc(Integer.parseInt(b.getTextContent()));
                    }
                }
            }
            this._entries.put(id, list);
        }
        catch (Exception ex) {
            LOG.error("There has been an error in file {}!", (Object)f, (Object)ex);
        }
    }

    @Override
    public FileFilter getCurrentFileFilter() {
        return NUMERIC_FILTER;
    }

    private Entry parseEntry(Node n, int entryId, ListContainer list) {
        Node first = n.getFirstChild();
        Entry entry = new Entry(entryId);
        for (n = first; n != null; n = n.getNextSibling()) {
            Node att;
            int i;
            StatsSet set;
            NamedNodeMap attrs;
            if ("ingredient".equalsIgnoreCase(n.getNodeName())) {
                attrs = n.getAttributes();
                set = new StatsSet();
                for (i = 0; i < attrs.getLength(); ++i) {
                    att = attrs.item(i);
                    set.set(att.getNodeName(), att.getNodeValue());
                }
                entry.addIngredient(new Ingredient(set));
                continue;
            }
            if (!"production".equalsIgnoreCase(n.getNodeName())) continue;
            attrs = n.getAttributes();
            set = new StatsSet();
            for (i = 0; i < attrs.getLength(); ++i) {
                att = attrs.item(i);
                set.set(att.getNodeName(), att.getNodeValue());
            }
            entry.addProduct(new Ingredient(set));
        }
        return entry;
    }

    public void separateAndSend(int listId, L2PcInstance player, L2Npc npc, boolean inventoryOnly, double productMultiplier, double ingredientMultiplier) {
        ListContainer template = this._entries.get(listId);
        if (template == null) {
            LOG.warn("Cannot find list ID: {} requested by player: {}, NPC ID: {}!", listId, player, npc != null ? npc.getId() : 0);
            return;
        }
        if (npc != null && !template.isNpcAllowed(npc.getId()) || npc == null && template.isNpcOnly()) {
            LOG.warn("Player {} attempted to open multisell {} from npc {} which is not allowed!", player, listId, npc);
            return;
        }
        PreparedListContainer list = new PreparedListContainer(template, inventoryOnly, player, npc);
        if (productMultiplier != 1.0 || ingredientMultiplier != 1.0) {
            list.getEntries().forEach(entry -> {
                entry.getProducts().forEach(product -> product.setItemCount((long)Math.max((double)product.getItemCount() * productMultiplier, 1.0)));
                entry.getIngredients().forEach(ingredient -> ingredient.setItemCount((long)Math.max((double)ingredient.getItemCount() * ingredientMultiplier, 1.0)));
            });
        }
        int index = 0;
        do {
            player.sendPacket(new MultiSellList(list, index));
        } while ((index += 40) < list.getEntries().size());
        player.setMultiSell(list);
    }

    public void separateAndSend(int listId, L2PcInstance player, L2Npc npc, boolean inventoryOnly) {
        this.separateAndSend(listId, player, npc, inventoryOnly, 1.0, 1.0);
    }

    public static boolean hasSpecialIngredient(int id, long amount, L2PcInstance player) {
        switch (id) {
            case -200: {
                if (player.getClan() == null) {
                    player.sendPacket(SystemMessageId.YOU_ARE_NOT_A_CLAN_MEMBER);
                    break;
                }
                if (!player.isClanLeader()) {
                    player.sendPacket(SystemMessageId.ONLY_THE_CLAN_LEADER_IS_ENABLED);
                    break;
                }
                if ((long)player.getClan().getReputationScore() < amount) {
                    player.sendPacket(SystemMessageId.THE_CLAN_REPUTATION_SCORE_IS_TOO_LOW);
                    break;
                }
                return true;
            }
            case -300: {
                if ((long)player.getFame() < amount) {
                    player.sendPacket(SystemMessageId.NOT_ENOUGH_FAME_POINTS);
                    break;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean takeSpecialIngredient(int id, long amount, L2PcInstance player) {
        switch (id) {
            case -200: {
                player.getClan().takeReputationScore((int)amount, true);
                SystemMessage smsg = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                smsg.addLong(amount);
                player.sendPacket(smsg);
                return true;
            }
            case -300: {
                player.setFame(player.getFame() - (int)amount);
                player.sendPacket(new UserInfo(player));
                player.sendPacket(new ExBrExtraUserInfo(player));
                return true;
            }
        }
        return false;
    }

    public static void giveSpecialProduct(int id, long amount, L2PcInstance player) {
        switch (id) {
            case -200: {
                player.getClan().addReputationScore((int)amount, true);
                break;
            }
            case -300: {
                player.setFame((int)((long)player.getFame() + amount));
                player.sendPacket(new UserInfo(player));
                player.sendPacket(new ExBrExtraUserInfo(player));
            }
        }
    }

    private void verify() {
        for (ListContainer listContainer : this._entries.values()) {
            for (Entry ent : listContainer.getEntries()) {
                for (Ingredient ing : ent.getIngredients()) {
                    if (this.verifyIngredient(ing)) continue;
                    LOG.warn("Cannot find ingredient with item ID: {} in list: {}!", (Object)ing.getItemId(), (Object)listContainer.getListId());
                }
                for (Ingredient ing : ent.getProducts()) {
                    if (this.verifyIngredient(ing)) continue;
                    LOG.warn("Cannot find product with item ID: {} in list: {}!", (Object)ing.getItemId(), (Object)listContainer.getListId());
                }
            }
        }
    }

    private boolean verifyIngredient(Ingredient ing) {
        return switch (ing.getItemId()) {
            case -300, -200 -> true;
            default -> ing.getTemplate() != null;
        };
    }

    public static MultisellData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final MultisellData _instance = new MultisellData();

        private SingletonHolder() {
        }
    }
}

