/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.enums.MountType;
import com.l2jserver.gameserver.model.L2PetData;
import com.l2jserver.gameserver.model.L2PetLevelData;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class PetDataTable
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(PetDataTable.class);
    private final Map<Integer, L2PetData> _pets = new HashMap<Integer, L2PetData>();

    protected PetDataTable() {
        this.load();
    }

    @Override
    public void load() {
        this._pets.clear();
        this.parseDatapackDirectory("data/stats/pets", false);
        LOG.info("Loaded {} Pets.", (Object)this._pets.size());
    }

    @Override
    public void parseDocument(Document doc) {
        Node n = doc.getFirstChild();
        for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
            if (!d.getNodeName().equals("pet")) continue;
            int npcId = this.parseInteger(d.getAttributes(), "id");
            int itemId = this.parseInteger(d.getAttributes(), "itemId");
            L2PetData data = new L2PetData(npcId, itemId);
            for (Node p = d.getFirstChild(); p != null; p = p.getNextSibling()) {
                Node s;
                NamedNodeMap attrs;
                if (p.getNodeName().equals("set")) {
                    attrs = p.getAttributes();
                    String type = attrs.getNamedItem("name").getNodeValue();
                    if ("food".equals(type)) {
                        for (String foodId : attrs.getNamedItem("val").getNodeValue().split(";")) {
                            data.addFood(Integer.valueOf(foodId));
                        }
                        continue;
                    }
                    if ("hungry_limit".equals(type)) {
                        data.setHungryLimit(this.parseInteger(attrs, "val"));
                        continue;
                    }
                    if (!"sync_level".equals(type)) continue;
                    data.setSyncLevel(this.parseInteger(attrs, "val") == 1);
                    continue;
                }
                if (p.getNodeName().equals("skills")) {
                    for (s = p.getFirstChild(); s != null; s = s.getNextSibling()) {
                        if (!s.getNodeName().equals("skill")) continue;
                        attrs = s.getAttributes();
                        data.addNewSkill(this.parseInteger(attrs, "skillId"), this.parseInteger(attrs, "skillLvl"), this.parseInteger(attrs, "minLvl"));
                    }
                    continue;
                }
                if (!p.getNodeName().equals("stats")) continue;
                for (s = p.getFirstChild(); s != null; s = s.getNextSibling()) {
                    if (!s.getNodeName().equals("stat")) continue;
                    int level = Integer.parseInt(s.getAttributes().getNamedItem("level").getNodeValue());
                    StatsSet set = new StatsSet();
                    for (Node bean = s.getFirstChild(); bean != null; bean = bean.getNextSibling()) {
                        if (!bean.getNodeName().equals("set")) continue;
                        attrs = bean.getAttributes();
                        if (attrs.getNamedItem("name").getNodeValue().equals("speed_on_ride")) {
                            set.set("walkSpeedOnRide", attrs.getNamedItem("walk").getNodeValue());
                            set.set("runSpeedOnRide", attrs.getNamedItem("run").getNodeValue());
                            set.set("slowSwimSpeedOnRide", attrs.getNamedItem("slowSwim").getNodeValue());
                            set.set("fastSwimSpeedOnRide", attrs.getNamedItem("fastSwim").getNodeValue());
                            if (attrs.getNamedItem("slowFly") != null) {
                                set.set("slowFlySpeedOnRide", attrs.getNamedItem("slowFly").getNodeValue());
                            }
                            if (attrs.getNamedItem("fastFly") == null) continue;
                            set.set("fastFlySpeedOnRide", attrs.getNamedItem("fastFly").getNodeValue());
                            continue;
                        }
                        set.set(attrs.getNamedItem("name").getNodeValue(), attrs.getNamedItem("val").getNodeValue());
                    }
                    data.addNewStat(level, new L2PetLevelData(set));
                }
            }
            this._pets.put(npcId, data);
        }
    }

    public L2PetData getPetDataByItemId(int itemId) {
        for (L2PetData data : this._pets.values()) {
            if (data.getItemId() != itemId) continue;
            return data;
        }
        return null;
    }

    public L2PetLevelData getPetLevelData(int petId, int petLevel) {
        L2PetData pd = this.getPetData(petId);
        if (pd != null) {
            return pd.getPetLevelData(petLevel);
        }
        return null;
    }

    public L2PetData getPetData(int petId) {
        if (!this._pets.containsKey(petId)) {
            LOG.warn("Missing pet data for NPC Id {}!", (Object)petId);
        }
        return this._pets.get(petId);
    }

    public int getPetMinLevel(int petId) {
        return this._pets.get(petId).getMinLevel();
    }

    public int getPetItemsByNpc(int npcId) {
        return this._pets.get(npcId).getItemId();
    }

    public static boolean isMountable(int npcId) {
        return MountType.findByNpcId(npcId) != MountType.NONE;
    }

    public static PetDataTable getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final PetDataTable INSTANCE = new PetDataTable();

        private SingletonHolder() {
        }
    }
}

