/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2StaticObjectInstance;
import com.l2jserver.gameserver.model.actor.templates.L2CharTemplate;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class StaticObjectData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(StaticObjectData.class);
    private final Map<Integer, L2StaticObjectInstance> _staticObjects = new HashMap<Integer, L2StaticObjectInstance>();

    protected StaticObjectData() {
        this.load();
    }

    @Override
    public void load() {
        this._staticObjects.clear();
        this.parseDatapackFile("data/staticObjects.xml");
        LOG.info("Loaded {} static object templates.", (Object)this._staticObjects.size());
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"object".equalsIgnoreCase(d.getNodeName())) continue;
                NamedNodeMap attrs = d.getAttributes();
                StatsSet set = new StatsSet();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node att = attrs.item(i);
                    set.set(att.getNodeName(), att.getNodeValue());
                }
                this.addObject(set);
            }
        }
    }

    private void addObject(StatsSet set) {
        int objectId = IdFactory.getInstance().getNextId();
        L2CharTemplate template = new L2CharTemplate(new StatsSet());
        L2StaticObjectInstance obj = new L2StaticObjectInstance(objectId, template, set.getInt("id"));
        obj.setType(set.getInt("type", 0));
        obj.setName(set.getString("name"));
        obj.setMap(set.getString("texture", "none"), set.getInt("map_x", 0), set.getInt("map_y", 0));
        obj.spawnMe(set.getInt("x"), set.getInt("y"), set.getInt("z"));
        this._staticObjects.put(obj.getObjectId(), obj);
    }

    public Collection<L2StaticObjectInstance> getStaticObjects() {
        return this._staticObjects.values();
    }

    public static StaticObjectData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final StaticObjectData INSTANCE = new StaticObjectData();

        private SingletonHolder() {
        }
    }
}

