/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.script.DateRange;
import com.l2jserver.gameserver.script.EventDrop;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class EventDroplist {
    private static final List<DateDrop> ALL_NPC_DATE_DROPS = new ArrayList<DateDrop>();

    public void addGlobalDrop(int[] itemIdList, int[] count, int chance, DateRange dateRange) {
        ALL_NPC_DATE_DROPS.add(new DateDrop(dateRange, new EventDrop(itemIdList, (long)count[0], (long)count[1], chance)));
    }

    public void addGlobalDrop(int itemId, long min, long max, int chance, DateRange dateRange) {
        ALL_NPC_DATE_DROPS.add(new DateDrop(dateRange, new EventDrop(itemId, min, max, chance)));
    }

    public void addGlobalDrop(DateRange dateRange, EventDrop eventDrop) {
        ALL_NPC_DATE_DROPS.add(new DateDrop(dateRange, eventDrop));
    }

    public List<DateDrop> getAllDrops() {
        ArrayList<DateDrop> list = new ArrayList<DateDrop>();
        Date currentDate = new Date();
        for (DateDrop drop : ALL_NPC_DATE_DROPS) {
            if (!drop._dateRange.isWithinRange(currentDate)) continue;
            list.add(drop);
        }
        return list;
    }

    public static EventDroplist getInstance() {
        return SingletonHolder._instance;
    }

    public static class DateDrop {
        protected final DateRange _dateRange;
        private final EventDrop _eventDrop;

        public DateDrop(DateRange dateRange, EventDrop eventDrop) {
            this._dateRange = dateRange;
            this._eventDrop = eventDrop;
        }

        public EventDrop getEventDrop() {
            return this._eventDrop;
        }

        public DateRange getDateRange() {
            return this._dateRange;
        }
    }

    private static class SingletonHolder {
        protected static final EventDroplist _instance = new EventDroplist();

        private SingletonHolder() {
        }
    }
}

