/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.SkillTreesData;
import com.l2jserver.gameserver.engines.DocumentEngine;
import com.l2jserver.gameserver.model.skills.Skill;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SkillData {
    private static final Logger LOG = LoggerFactory.getLogger(SkillData.class);
    private final Map<Integer, Skill> _skills = new HashMap<Integer, Skill>();
    private final Map<Integer, Integer> _skillMaxLevel = new HashMap<Integer, Integer>();
    private final Set<Integer> _enchantable = new HashSet<Integer>();

    protected SkillData() {
        this.load();
    }

    public void reload() {
        this.load();
        SkillTreesData.getInstance().load();
    }

    private void load() {
        long start = System.currentTimeMillis();
        Map<Integer, Skill> temp = DocumentEngine.getInstance().loadAllSkills();
        this._skills.clear();
        this._skills.putAll(temp);
        this._skillMaxLevel.clear();
        this._enchantable.clear();
        for (Skill skill : this._skills.values()) {
            int skillId = skill.getId();
            int skillLvl = skill.getLevel();
            if (skillLvl > 99) {
                this._enchantable.add(skillId);
                continue;
            }
            int maxLvl = this.getMaxLevel(skillId);
            if (skillLvl <= maxLvl) continue;
            this._skillMaxLevel.put(skillId, skillLvl);
        }
        LOG.info("Loaded {} skill templates from XML files in {}ms.", (Object)this._skills.size(), (Object)(System.currentTimeMillis() - start));
    }

    public static int getSkillHashCode(Skill skill) {
        return SkillData.getSkillHashCode(skill.getId(), skill.getLevel());
    }

    public static int getSkillHashCode(int skillId, int skillLevel) {
        return skillId * 1021 + skillLevel;
    }

    public Skill getSkill(int skillId, int level) {
        Skill result = this._skills.get(SkillData.getSkillHashCode(skillId, level));
        if (result != null) {
            return result;
        }
        int maxLvl = this.getMaxLevel(skillId);
        if (maxLvl > 0 && level > maxLvl) {
            if (Configuration.general().debug()) {
                LOG.warn("Call to unexisting skill level Id {} requested level {} max level {}!", skillId, level, maxLvl);
            }
            return this._skills.get(SkillData.getSkillHashCode(skillId, maxLvl));
        }
        LOG.warn("No skill info found for skill Id {} and skill level {}!", (Object)skillId, (Object)level);
        return null;
    }

    public int getMaxLevel(int skillId) {
        Integer maxLevel = this._skillMaxLevel.get(skillId);
        return maxLevel != null ? maxLevel : 0;
    }

    public boolean isEnchantable(int skillId) {
        return this._enchantable.contains(skillId);
    }

    public Skill[] getSiegeSkills(boolean addNoble, boolean hasCastle) {
        Skill[] temp = new Skill[2 + (addNoble ? 1 : 0) + (hasCastle ? 2 : 0)];
        int i = 0;
        temp[i++] = this._skills.get(SkillData.getSkillHashCode(246, 1));
        temp[i++] = this._skills.get(SkillData.getSkillHashCode(247, 1));
        if (addNoble) {
            temp[i++] = this._skills.get(SkillData.getSkillHashCode(326, 1));
        }
        if (hasCastle) {
            temp[i++] = this._skills.get(SkillData.getSkillHashCode(844, 1));
            temp[i] = this._skills.get(SkillData.getSkillHashCode(845, 1));
        }
        return temp;
    }

    public static SkillData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final SkillData _instance = new SkillData();

        private SingletonHolder() {
        }
    }
}

