/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.NpcData;
import com.l2jserver.gameserver.datatables.NpcPersonalAIData;
import com.l2jserver.gameserver.instancemanager.DayNightSpawnManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.util.IXmlReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class SpawnTable
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(SpawnTable.class);
    private static final String SELECT_SPAWNS = "SELECT count, npc_templateid, locx, locy, locz, heading, respawn_delay, respawn_random, loc_id, periodOfDay FROM spawnlist";
    private static final String SELECT_CUSTOM_SPAWNS = "SELECT count, npc_templateid, locx, locy, locz, heading, respawn_delay, respawn_random, loc_id, periodOfDay FROM custom_spawnlist";
    private static final Map<Integer, Set<L2Spawn>> _spawnTable = new ConcurrentHashMap<Integer, Set<L2Spawn>>();
    private int _xmlSpawnCount = 0;

    @Override
    public void load() {
        if (!Configuration.general().noSpawns()) {
            this.fillSpawnTable(false);
            int spawnCount = _spawnTable.size();
            LOG.info("Loaded {} NPC spawns.", (Object)spawnCount);
            if (Configuration.general().customSpawnlistTable()) {
                this.fillSpawnTable(true);
                LOG.info("Loaded {} custom NPC spawns.", (Object)(_spawnTable.size() - spawnCount));
            }
            this.parseDatapackDirectory("data/spawnlist", false);
            LOG.info("Loaded {} NPC spawns from XML.", (Object)this._xmlSpawnCount);
        }
    }

    private boolean checkTemplate(int npcId) {
        L2NpcTemplate npcTemplate = NpcData.getInstance().getTemplate(npcId);
        if (npcTemplate == null) {
            LOG.warn("Data missing in NPC table for ID {}!", (Object)npcId);
            return false;
        }
        return !npcTemplate.isType("L2SiegeGuard") && !npcTemplate.isType("L2RaidBoss");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void parseDocument(Document doc) {
        Node list = doc.getFirstChild();
        while (list != null) {
            NamedNodeMap attrs;
            if (list.getNodeName().equalsIgnoreCase("list") && Boolean.parseBoolean((attrs = list.getAttributes()).getNamedItem("enabled").getNodeValue())) {
                for (Node param = list.getFirstChild(); param != null; param = param.getNextSibling()) {
                    attrs = param.getAttributes();
                    if (!param.getNodeName().equalsIgnoreCase("spawn")) continue;
                    String territoryName = null;
                    String spawnName = null;
                    HashMap<String, Integer> map = null;
                    if (attrs.getNamedItem("name") != null) {
                        spawnName = this.parseString(attrs, "name");
                    }
                    if (attrs.getNamedItem("zone") != null && ZoneManager.getInstance().getSpawnTerritory(attrs.getNamedItem("zone").getNodeValue()) != null) {
                        territoryName = this.parseString(attrs, "zone");
                    }
                    for (Node npctag = param.getFirstChild(); npctag != null; npctag = npctag.getNextSibling()) {
                        attrs = npctag.getAttributes();
                        if (npctag.getNodeName().equalsIgnoreCase("AIData")) {
                            attrs = npctag.getAttributes();
                            if (map == null) {
                                map = new HashMap<String, Integer>();
                            }
                        } else {
                            String period;
                            if (!npctag.getNodeName().equalsIgnoreCase("npc")) continue;
                            int templateId = this.parseInteger(attrs, "id");
                            int x = 0;
                            int y = 0;
                            int z = 0;
                            try {
                                x = this.parseInteger(attrs, "x");
                                y = this.parseInteger(attrs, "y");
                                z = this.parseInteger(attrs, "z");
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                            if (x == 0 && y == 0 && territoryName == null) {
                                LOG.warn("Spawn could not be initialized, both coordinates and zone are unspecified for ID {}!", (Object)templateId);
                                continue;
                            }
                            StatsSet spawnInfo = new StatsSet();
                            spawnInfo.set("npcTemplateid", templateId);
                            spawnInfo.set("x", x);
                            spawnInfo.set("y", y);
                            spawnInfo.set("z", z);
                            spawnInfo.set("territoryName", territoryName);
                            spawnInfo.set("spawnName", spawnName);
                            if (attrs.getNamedItem("heading") != null) {
                                spawnInfo.set("heading", this.parseInteger(attrs, "heading"));
                            }
                            if (attrs.getNamedItem("count") != null) {
                                spawnInfo.set("count", this.parseInteger(attrs, "count"));
                            }
                            if (attrs.getNamedItem("respawnDelay") != null) {
                                spawnInfo.set("respawnDelay", this.parseInteger(attrs, "respawnDelay"));
                            }
                            if (attrs.getNamedItem("respawnRandom") != null) {
                                spawnInfo.set("respawnRandom", this.parseInteger(attrs, "respawnRandom"));
                            }
                            if (attrs.getNamedItem("periodOfDay") != null && ((period = attrs.getNamedItem("periodOfDay").getNodeValue()).equalsIgnoreCase("day") || period.equalsIgnoreCase("night"))) {
                                spawnInfo.set("periodOfDay", period.equalsIgnoreCase("day") ? 1 : 2);
                            }
                            this._xmlSpawnCount += this.addSpawn(spawnInfo, map);
                            continue;
                        }
                        for (Node c = npctag.getFirstChild(); c != null; c = c.getNextSibling()) {
                            if (c.getNodeName().equals("#text")) continue;
                            int val = switch (c.getNodeName()) {
                                case "disableRandomAnimation", "disableRandomWalk" -> {
                                    if (Boolean.parseBoolean(c.getTextContent())) {
                                        yield 1;
                                    }
                                    yield 0;
                                }
                                default -> Integer.parseInt(c.getTextContent());
                            };
                            map.put(c.getNodeName(), val);
                        }
                    }
                }
            }
            list = list.getNextSibling();
        }
        return;
    }

    private int fillSpawnTable(boolean isCustom) {
        int npcSpawnCount = 0;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery(isCustom ? SELECT_CUSTOM_SPAWNS : SELECT_SPAWNS);){
            while (rs.next()) {
                StatsSet spawnInfo = new StatsSet();
                int npcId = rs.getInt("npc_templateid");
                if (!this.checkTemplate(npcId)) continue;
                spawnInfo.set("npcTemplateid", npcId);
                spawnInfo.set("count", rs.getInt("count"));
                spawnInfo.set("x", rs.getInt("locx"));
                spawnInfo.set("y", rs.getInt("locy"));
                spawnInfo.set("z", rs.getInt("locz"));
                spawnInfo.set("heading", rs.getInt("heading"));
                spawnInfo.set("respawnDelay", rs.getInt("respawn_delay"));
                spawnInfo.set("respawnRandom", rs.getInt("respawn_random"));
                spawnInfo.set("locId", rs.getInt("loc_id"));
                spawnInfo.set("periodOfDay", rs.getInt("periodOfDay"));
                spawnInfo.set("isCustomSpawn", isCustom);
                npcSpawnCount += this.addSpawn(spawnInfo);
            }
        }
        catch (Exception ex) {
            LOG.warn("Spawn could not be initialized!", ex);
        }
        return npcSpawnCount;
    }

    private int addSpawn(StatsSet spawnInfo, Map<String, Integer> AIData) {
        int ret = 0;
        try {
            L2Spawn spawnDat = new L2Spawn(spawnInfo.getInt("npcTemplateid"));
            spawnDat.setAmount(spawnInfo.getInt("count", 1));
            spawnDat.setX(spawnInfo.getInt("x", 0));
            spawnDat.setY(spawnInfo.getInt("y", 0));
            spawnDat.setZ(spawnInfo.getInt("z", 0));
            spawnDat.setHeading(spawnInfo.getInt("heading", -1));
            spawnDat.setRespawnDelay(spawnInfo.getInt("respawnDelay", 0), spawnInfo.getInt("respawnRandom", 0));
            spawnDat.setLocationId(spawnInfo.getInt("locId", 0));
            String territoryName = spawnInfo.getString("territoryName", "");
            String spawnName = spawnInfo.getString("spawnName", "");
            spawnDat.setCustom(spawnInfo.getBoolean("isCustomSpawn", false));
            if (!spawnName.isEmpty()) {
                spawnDat.setName(spawnName);
            }
            if (!territoryName.isEmpty()) {
                spawnDat.setSpawnTerritory(ZoneManager.getInstance().getSpawnTerritory(territoryName));
            }
            NpcPersonalAIData.getInstance().storeData(spawnDat, AIData);
            switch (spawnInfo.getInt("periodOfDay", 0)) {
                case 0: {
                    ret += spawnDat.init();
                    break;
                }
                case 1: {
                    DayNightSpawnManager.getInstance().addDayCreature(spawnDat);
                    ret = 1;
                    break;
                }
                case 2: {
                    DayNightSpawnManager.getInstance().addNightCreature(spawnDat);
                    ret = 1;
                }
            }
            this.addSpawn(spawnDat);
        }
        catch (Exception ex) {
            LOG.warn("Spawn could not be initialized!", ex);
        }
        return ret;
    }

    private int addSpawn(StatsSet spawnInfo) {
        return this.addSpawn(spawnInfo, null);
    }

    public Map<Integer, Set<L2Spawn>> getSpawnTable() {
        return _spawnTable;
    }

    public Set<L2Spawn> getSpawns(int npcId) {
        return _spawnTable.getOrDefault(npcId, Collections.emptySet());
    }

    public int getSpawnCount(int npcId) {
        return this.getSpawns(npcId).size();
    }

    public L2Spawn findAny(int npcId) {
        return this.getSpawns(npcId).stream().findFirst().orElse(null);
    }

    public void addNewSpawn(L2Spawn spawn, boolean storeInDb) {
        this.addSpawn(spawn);
        if (storeInDb) {
            String spawnTable = spawn.isCustom() && Configuration.general().customSpawnlistTable() ? "custom_spawnlist" : "spawnlist";
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement insert = con.prepareStatement("INSERT INTO " + spawnTable + "(count,npc_templateid,locx,locy,locz,heading,respawn_delay,respawn_random,loc_id) values(?,?,?,?,?,?,?,?,?)");){
                insert.setInt(1, spawn.getAmount());
                insert.setInt(2, spawn.getId());
                insert.setInt(3, spawn.getX());
                insert.setInt(4, spawn.getY());
                insert.setInt(5, spawn.getZ());
                insert.setInt(6, spawn.getHeading());
                insert.setInt(7, (int)TimeUnit.MILLISECONDS.toSeconds(spawn.getRespawnDelay()));
                insert.setInt(8, spawn.getRespawnMaxDelay() - spawn.getRespawnMinDelay());
                insert.setInt(9, spawn.getLocationId());
                insert.execute();
            }
            catch (Exception ex) {
                LOG.warn("Could not store spawn in the DB!", ex);
            }
        }
    }

    public void deleteSpawn(L2Spawn spawn, boolean updateDb) {
        if (!this.removeSpawn(spawn)) {
            return;
        }
        if (updateDb) {
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement delete = con.prepareStatement("DELETE FROM " + (spawn.isCustom() ? "custom_spawnlist" : "spawnlist") + " WHERE locx=? AND locy=? AND locz=? AND npc_templateid=? AND heading=?");){
                delete.setInt(1, spawn.getX());
                delete.setInt(2, spawn.getY());
                delete.setInt(3, spawn.getZ());
                delete.setInt(4, spawn.getId());
                delete.setInt(5, spawn.getHeading());
                delete.execute();
            }
            catch (Exception ex) {
                LOG.warn("Spawn {} could not be removed from DB!", (Object)spawn, (Object)ex);
            }
        }
    }

    private void addSpawn(L2Spawn spawn) {
        _spawnTable.computeIfAbsent(spawn.getId(), k -> ConcurrentHashMap.newKeySet(1)).add(spawn);
    }

    private boolean removeSpawn(L2Spawn spawn) {
        Set<L2Spawn> set = _spawnTable.get(spawn.getId());
        if (set != null) {
            boolean removed = set.remove(spawn);
            if (set.isEmpty()) {
                _spawnTable.remove(spawn.getId());
            }
            return removed;
        }
        return false;
    }

    public boolean forEachSpawn(Function<L2Spawn, Boolean> function) {
        for (Set<L2Spawn> set : _spawnTable.values()) {
            for (L2Spawn spawn : set) {
                if (function.apply(spawn).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public static SpawnTable getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final SpawnTable INSTANCE = new SpawnTable();

        private SingletonHolder() {
        }
    }
}

