/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.engines;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.engines.items.DocumentItem;
import com.l2jserver.gameserver.engines.skills.DocumentSkill;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.util.file.filter.XMLFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentEngine {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentEngine.class);
    private final List<File> _itemFiles = new ArrayList<File>();
    private final List<File> _skillFiles = new ArrayList<File>();

    public static DocumentEngine getInstance() {
        return SingletonHolder._instance;
    }

    protected DocumentEngine() {
        this.hashFiles("data/stats/items", this._itemFiles);
        if (Configuration.general().customItemsLoad()) {
            this.hashFiles("data/stats/items/custom", this._itemFiles);
        }
        this.hashFiles("data/stats/skills", this._skillFiles);
        if (Configuration.general().customSkillsLoad()) {
            this.hashFiles("data/stats/skills/custom", this._skillFiles);
        }
    }

    private void hashFiles(String dirname, List<File> hash) {
        File dir = new File(Configuration.server().getDatapackRoot(), dirname);
        if (!dir.exists()) {
            LOG.warn("Directory {} does not exists!", (Object)dir.getAbsolutePath());
            return;
        }
        File[] files = dir.listFiles(new XMLFilter());
        if (files != null) {
            Collections.addAll(hash, files);
        }
    }

    private List<Skill> loadSkills(File file) {
        if (file == null) {
            LOG.warn("Skill file not found!");
            return null;
        }
        DocumentSkill doc = new DocumentSkill(file);
        doc.parse();
        return doc.getSkills();
    }

    public Map<Integer, Skill> loadAllSkills() {
        return this._skillFiles.parallelStream().map(this::loadSkills).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toConcurrentMap(SkillData::getSkillHashCode, Function.identity()));
    }

    public List<L2Item> loadItems() {
        return this._itemFiles.parallelStream().filter(Objects::nonNull).map(DocumentItem::new).map(doc -> {
            doc.parse();
            return doc.getItemList();
        }).flatMap(Collection::stream).toList();
    }

    private static class SingletonHolder {
        protected static final DocumentEngine _instance = new DocumentEngine();

        private SingletonHolder() {
        }
    }
}

