/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.enums;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.util.ArrayList;
import java.util.List;

public enum TriggerTargetType {
    ENEMY{

        @Override
        public List<L2Character> getTargets(L2Character target, L2Character attacker) {
            return List.of(attacker);
        }
    }
    ,
    SELF{

        @Override
        public List<L2Character> getTargets(L2Character target, L2Character attacker) {
            return List.of(target);
        }
    }
    ,
    MY_PARTY{

        @Override
        public List<L2Character> getTargets(L2Character target, L2Character attacker) {
            if (target.isPlayer() || target.isSummon()) {
                L2PcInstance player = target.getActingPlayer();
                if (player.isInParty()) {
                    return new ArrayList<L2Character>(player.getParty().getMembers());
                }
                return List.of(player);
            }
            return List.of();
        }
    }
    ,
    TARGET{

        @Override
        public List<L2Character> getTargets(L2Character target, L2Character attacker) {
            return List.of(target);
        }
    }
    ,
    SUMMON{

        @Override
        public List<L2Character> getTargets(L2Character target, L2Character attacker) {
            if (target.hasSummon()) {
                return List.of(target.getSummon());
            }
            return List.of();
        }
    };


    public abstract List<L2Character> getTargets(L2Character var1, L2Character var2);
}

