/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.handler;

import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.handler.IActionHandler;
import com.l2jserver.gameserver.handler.IHandler;
import java.util.HashMap;
import java.util.Map;

public class ActionHandler
implements IHandler<IActionHandler, InstanceType> {
    private final Map<InstanceType, IActionHandler> _actions = new HashMap<InstanceType, IActionHandler>();

    public static ActionHandler getInstance() {
        return SingletonHolder._instance;
    }

    protected ActionHandler() {
    }

    @Override
    public void registerHandler(IActionHandler handler) {
        this._actions.put(handler.getInstanceType(), handler);
    }

    @Override
    public synchronized void removeHandler(IActionHandler handler) {
        this._actions.remove((Object)handler.getInstanceType());
    }

    @Override
    public IActionHandler getHandler(InstanceType iType) {
        IActionHandler result = null;
        for (InstanceType t = iType; t != null && (result = this._actions.get((Object)t)) == null; t = t.getParent()) {
        }
        return result;
    }

    @Override
    public int size() {
        return this._actions.size();
    }

    private static class SingletonHolder {
        protected static final ActionHandler _instance = new ActionHandler();

        private SingletonHolder() {
        }
    }
}

