/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.handler;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.handler.IHandler;
import com.l2jserver.gameserver.handler.IParseBoardHandler;
import com.l2jserver.gameserver.handler.IWriteBoardHandler;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.util.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommunityBoardHandler
implements IHandler<IParseBoardHandler, String> {
    private static final Logger LOG = LoggerFactory.getLogger(CommunityBoardHandler.class);
    private final Map<String, IParseBoardHandler> _datatable = new HashMap<String, IParseBoardHandler>();
    private final Map<Integer, String> _bypasses = new ConcurrentHashMap<Integer, String>();

    protected CommunityBoardHandler() {
    }

    @Override
    public void registerHandler(IParseBoardHandler handler) {
        for (String cmd : handler.getCommunityBoardCommands()) {
            this._datatable.put(cmd.toLowerCase(), handler);
        }
    }

    @Override
    public synchronized void removeHandler(IParseBoardHandler handler) {
        for (String cmd : handler.getCommunityBoardCommands()) {
            this._datatable.remove(cmd.toLowerCase());
        }
    }

    @Override
    public IParseBoardHandler getHandler(String cmd) {
        for (IParseBoardHandler cb : this._datatable.values()) {
            for (String command : cb.getCommunityBoardCommands()) {
                if (!cmd.toLowerCase().startsWith(command.toLowerCase())) continue;
                return cb;
            }
        }
        return null;
    }

    @Override
    public int size() {
        return this._datatable.size();
    }

    public boolean isCommunityBoardCommand(String cmd) {
        return this.getHandler(cmd) != null;
    }

    public void handleParseCommand(String command, L2PcInstance player) {
        if (player == null) {
            return;
        }
        if (!Configuration.general().enableCommunityBoard()) {
            player.sendPacket(SystemMessageId.CB_OFFLINE);
            return;
        }
        IParseBoardHandler cb = this.getHandler(command);
        if (cb == null) {
            LOG.warn("Couldn't find parse handler for command {}!", (Object)command);
            return;
        }
        cb.parseCommunityBoardCommand(command, player);
    }

    public void handleWriteCommand(L2PcInstance player, String url, String arg1, String arg2, String arg3, String arg4, String arg5) {
        String cmd;
        if (player == null) {
            return;
        }
        if (!Configuration.general().enableCommunityBoard()) {
            player.sendPacket(SystemMessageId.CB_OFFLINE);
            return;
        }
        switch (url) {
            case "Topic": {
                cmd = "_bbstop";
                break;
            }
            case "Post": {
                cmd = "_bbspos";
                break;
            }
            case "Region": {
                cmd = "_bbsloc";
                break;
            }
            case "Notice": {
                cmd = "_bbsclan";
                break;
            }
            default: {
                CommunityBoardHandler.separateAndSend("<html><body><br><br><center>The command: " + url + " is not implemented yet.</center><br><br></body></html>", player);
                return;
            }
        }
        IParseBoardHandler cb = this.getHandler(cmd);
        if (cb == null) {
            LOG.warn("Couldn't find write handler for command {}!", (Object)cmd);
            return;
        }
        if (!(cb instanceof IWriteBoardHandler)) {
            LOG.warn("{} doesn't implement write!", (Object)cb.getClass().getSimpleName());
            return;
        }
        ((IWriteBoardHandler)cb).writeCommunityBoardCommand(player, arg1, arg2, arg3, arg4, arg5);
    }

    public void addBypass(L2PcInstance player, String title, String bypass) {
        this._bypasses.put(player.getObjectId(), title + "&" + bypass);
    }

    public String removeBypass(L2PcInstance player) {
        return this._bypasses.remove(player.getObjectId());
    }

    public static void separateAndSend(String html, L2PcInstance player) {
        Util.sendCBHtml(player, html);
    }

    public static CommunityBoardHandler getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final CommunityBoardHandler _instance = new CommunityBoardHandler();

        private SingletonHolder() {
        }
    }
}

