/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.handler;

import com.l2jserver.gameserver.handler.IHandler;
import com.l2jserver.gameserver.handler.IItemHandler;
import com.l2jserver.gameserver.model.items.L2EtcItem;
import java.util.HashMap;
import java.util.Map;

public class ItemHandler
implements IHandler<IItemHandler, L2EtcItem> {
    private final Map<String, IItemHandler> _datatable = new HashMap<String, IItemHandler>();

    protected ItemHandler() {
    }

    @Override
    public void registerHandler(IItemHandler handler) {
        this._datatable.put(handler.getClass().getSimpleName(), handler);
    }

    @Override
    public synchronized void removeHandler(IItemHandler handler) {
        this._datatable.remove(handler.getClass().getSimpleName());
    }

    @Override
    public IItemHandler getHandler(L2EtcItem item) {
        if (item == null || item.getHandlerName() == null) {
            return null;
        }
        return this._datatable.get(item.getHandlerName());
    }

    @Override
    public int size() {
        return this._datatable.size();
    }

    public static ItemHandler getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final ItemHandler INSTANCE = new ItemHandler();

        private SingletonHolder() {
        }
    }
}

