/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.idfactory;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.idfactory.IdFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CompactionIDFactory
extends IdFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionIDFactory.class);
    private int _curOID = 0x10000000;
    private final int _freeSize;

    protected CompactionIDFactory() {
        this._freeSize = 0;
        try (Connection con = ConnectionFactory.getInstance().getConnection();){
            Integer[] tmp_obj_ids = this.extractUsedObjectIDTable();
            int N = tmp_obj_ids.length;
            for (int idx = 0; idx < N; ++idx) {
                N = this.insertUntil(tmp_obj_ids, idx, N, con);
            }
            ++this._curOID;
            LOG.info("Next usable Object Id is {}.", (Object)this._curOID);
            this._initialized = true;
        }
        catch (Exception ex) {
            LOG.error("Could not initialize properly!", ex);
        }
    }

    private int insertUntil(Integer[] tmp_obj_ids, int idx, int N, Connection con) throws SQLException {
        int hole;
        int id = tmp_obj_ids[idx];
        if (id == this._curOID) {
            ++this._curOID;
            return N;
        }
        if (Configuration.server().badIdChecking()) {
            for (String check : ID_CHECKS) {
                try (PreparedStatement ps = con.prepareStatement(check);){
                    ps.setInt(1, this._curOID);
                    ps.setInt(2, id);
                    try (ResultSet rs = ps.executeQuery();){
                        if (!rs.next()) continue;
                        int badId = rs.getInt(1);
                        LOG.error("Bad Id {} in DB found by {}!", (Object)badId, (Object)check);
                        throw new RuntimeException();
                    }
                }
            }
        }
        if ((hole = id - this._curOID) > N - idx) {
            hole = N - idx;
        }
        for (int i = 1; i <= hole; ++i) {
            id = tmp_obj_ids[N - i];
            LOG.info("Compacting DB object Id={} into {}.", (Object)id, (Object)this._curOID);
            for (String update : ID_UPDATES) {
                try (PreparedStatement ps = con.prepareStatement(update);){
                    ps.setInt(1, this._curOID);
                    ps.setInt(2, id);
                    ps.execute();
                }
            }
            ++this._curOID;
        }
        if (hole < N - idx) {
            ++this._curOID;
        }
        return N - hole;
    }

    @Override
    public synchronized int getNextId() {
        return this._curOID++;
    }

    @Override
    public synchronized void releaseId(int id) {
    }

    @Override
    public int size() {
        return this._freeSize + Integer.MAX_VALUE - 0x10000000;
    }
}

