/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.ManorMode;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.CropProcure;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.L2Seed;
import com.l2jserver.gameserver.model.SeedProduction;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.interfaces.IStorable;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.util.IXmlReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class CastleManorManager
implements IXmlReader,
IStorable {
    private static final Logger LOG = LoggerFactory.getLogger(CastleManorManager.class);
    private static final String INSERT_PRODUCT = "INSERT INTO castle_manor_production VALUES (?, ?, ?, ?, ?, ?)";
    private static final String INSERT_CROP = "INSERT INTO castle_manor_procure VALUES (?, ?, ?, ?, ?, ?, ?)";
    private ManorMode _mode = ManorMode.APPROVED;
    private Calendar _nextModeChange = null;
    private static final Map<Integer, L2Seed> _seeds = new HashMap<Integer, L2Seed>();
    private final Map<Integer, List<CropProcure>> _procure = new HashMap<Integer, List<CropProcure>>();
    private final Map<Integer, List<CropProcure>> _procureNext = new HashMap<Integer, List<CropProcure>>();
    private final Map<Integer, List<SeedProduction>> _production = new HashMap<Integer, List<SeedProduction>>();
    private final Map<Integer, List<SeedProduction>> _productionNext = new HashMap<Integer, List<SeedProduction>>();

    public CastleManorManager() {
        if (Configuration.general().allowManor()) {
            this.load();
            this.loadDb();
            Calendar currentTime = Calendar.getInstance();
            int hour = currentTime.get(11);
            int min = currentTime.get(12);
            int maintenanceMin = Configuration.general().getManorRefreshMin() + Configuration.general().getManorMaintenanceMin();
            if (hour >= Configuration.general().getManorRefreshTime() && min >= maintenanceMin || hour < Configuration.general().getManorApproveTime() || hour == Configuration.general().getManorApproveTime() && min <= Configuration.general().getManorApproveMin()) {
                this._mode = ManorMode.MODIFIABLE;
            } else if (hour == Configuration.general().getManorRefreshTime() && min >= Configuration.general().getManorRefreshMin() && min < maintenanceMin) {
                this._mode = ManorMode.MAINTENANCE;
            }
            this.scheduleModeChange();
            if (!Configuration.general().manorSaveAllActions()) {
                ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(this::storeMe, Configuration.general().getManorSavePeriodRate(), Configuration.general().getManorSavePeriodRate(), TimeUnit.HOURS);
            }
            if (Configuration.general().debug()) {
                LOG.info("Current mode {}.", (Object)this._mode);
            }
        } else {
            this._mode = ManorMode.DISABLED;
            LOG.info("Manor system is deactivated.");
        }
    }

    @Override
    public void load() {
        this.parseDatapackFile("data/seeds.xml");
        LOG.info("Loaded {} seeds.", (Object)_seeds.size());
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"castle".equalsIgnoreCase(d.getNodeName())) continue;
                int castleId = this.parseInteger(d.getAttributes(), "id");
                for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
                    if (!"crop".equalsIgnoreCase(c.getNodeName())) continue;
                    StatsSet set = new StatsSet();
                    set.set("castleId", castleId);
                    NamedNodeMap attrs = c.getAttributes();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        Node att = attrs.item(i);
                        set.set(att.getNodeName(), att.getNodeValue());
                    }
                    _seeds.put(set.getInt("seedId"), new L2Seed(set));
                }
            }
        }
    }

    private void loadDb() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement stProduction = con.prepareStatement("SELECT * FROM castle_manor_production WHERE castle_id=?");
             PreparedStatement stProcure = con.prepareStatement("SELECT * FROM castle_manor_procure WHERE castle_id=?");){
            for (Castle castle : CastleManager.getInstance().getCastles()) {
                int castleId = castle.getResidenceId();
                stProduction.clearParameters();
                stProcure.clearParameters();
                ArrayList<SeedProduction> pCurrent = new ArrayList<SeedProduction>();
                ArrayList<SeedProduction> pNext = new ArrayList<SeedProduction>();
                stProduction.setInt(1, castleId);
                try (ResultSet rs = stProduction.executeQuery();){
                    while (rs.next()) {
                        int seedId = rs.getInt("seed_id");
                        if (_seeds.containsKey(seedId)) {
                            SeedProduction sp = new SeedProduction(seedId, rs.getLong("amount"), rs.getLong("price"), rs.getInt("start_amount"));
                            if (rs.getBoolean("next_period")) {
                                pNext.add(sp);
                                continue;
                            }
                            pCurrent.add(sp);
                            continue;
                        }
                        LOG.warn("Unknown seed Id {}!", (Object)seedId);
                    }
                }
                this._production.put(castleId, pCurrent);
                this._productionNext.put(castleId, pNext);
                ArrayList<CropProcure> current = new ArrayList<CropProcure>();
                ArrayList<CropProcure> next = new ArrayList<CropProcure>();
                stProcure.setInt(1, castleId);
                try (ResultSet rs = stProcure.executeQuery();){
                    Set<Integer> cropIds = this.getCropIds();
                    while (rs.next()) {
                        int cropId = rs.getInt("crop_id");
                        if (cropIds.contains(cropId)) {
                            CropProcure cp = new CropProcure(cropId, rs.getLong("amount"), rs.getInt("reward_type"), rs.getLong("start_amount"), rs.getLong("price"));
                            if (rs.getBoolean("next_period")) {
                                next.add(cp);
                                continue;
                            }
                            current.add(cp);
                            continue;
                        }
                        LOG.warn("Unknown crop Id {}!", (Object)cropId);
                    }
                }
                this._procure.put(castleId, current);
                this._procureNext.put(castleId, next);
            }
            LOG.info("Manor data loaded.");
        }
        catch (Exception ex) {
            LOG.warn("Unable to load manor data!", ex);
        }
    }

    private void scheduleModeChange() {
        this._nextModeChange = Calendar.getInstance();
        this._nextModeChange.set(13, 0);
        switch (this._mode) {
            case MODIFIABLE: {
                this._nextModeChange.set(11, Configuration.general().getManorApproveTime());
                this._nextModeChange.set(12, Configuration.general().getManorApproveMin());
                if (!this._nextModeChange.before(Calendar.getInstance())) break;
                this._nextModeChange.add(5, 1);
                break;
            }
            case MAINTENANCE: {
                this._nextModeChange.set(11, Configuration.general().getManorRefreshTime());
                this._nextModeChange.set(12, Configuration.general().getManorRefreshMin() + Configuration.general().getManorMaintenanceMin());
                break;
            }
            case APPROVED: {
                this._nextModeChange.set(11, Configuration.general().getManorRefreshTime());
                this._nextModeChange.set(12, Configuration.general().getManorRefreshMin());
            }
        }
        ThreadPoolManager.getInstance().scheduleGeneral(this::changeMode, this._nextModeChange.getTimeInMillis() - System.currentTimeMillis());
    }

    public void changeMode() {
        switch (this._mode) {
            case APPROVED: {
                this._mode = ManorMode.MAINTENANCE;
                for (Castle castle : CastleManager.getInstance().getCastles()) {
                    L2Clan owner = castle.getOwner();
                    if (owner == null) continue;
                    int castleId = castle.getResidenceId();
                    ItemContainer cwh = owner.getWarehouse();
                    for (CropProcure crop : this._procure.get(castleId)) {
                        if (crop.getStartAmount() <= 0L) continue;
                        if (crop.getStartAmount() != crop.getAmount()) {
                            long count = (long)((double)(crop.getStartAmount() - crop.getAmount()) * 0.9);
                            if (count < 1L && Rnd.nextInt((int)99) < 90) {
                                count = 1L;
                            }
                            if (count > 0L) {
                                cwh.addItem("Manor", this.getSeedByCrop(crop.getId()).getMatureId(), count, null, null);
                            }
                        }
                        if (crop.getAmount() <= 0L) continue;
                        castle.addToTreasuryNoTax(crop.getAmount() * crop.getPrice());
                    }
                    List<SeedProduction> _nextProduction = this._productionNext.get(castleId);
                    List<CropProcure> _nextProcure = this._procureNext.get(castleId);
                    this._production.put(castleId, _nextProduction);
                    this._procure.put(castleId, _nextProcure);
                    if (castle.getTreasury() < this.getManorCost(castleId, false)) {
                        this._productionNext.put(castleId, Collections.emptyList());
                        this._procureNext.put(castleId, Collections.emptyList());
                        continue;
                    }
                    ArrayList<SeedProduction> production = new ArrayList<SeedProduction>(_nextProduction);
                    for (SeedProduction s : production) {
                        s.setAmount(s.getStartAmount());
                    }
                    this._productionNext.put(castleId, production);
                    ArrayList<CropProcure> procure = new ArrayList<CropProcure>(_nextProcure);
                    for (CropProcure cr : procure) {
                        cr.setAmount(cr.getStartAmount());
                    }
                    this._procureNext.put(castleId, procure);
                }
                this.storeMe();
                break;
            }
            case MAINTENANCE: {
                for (Castle castle : CastleManager.getInstance().getCastles()) {
                    L2ClanMember clanLeader;
                    L2Clan owner = castle.getOwner();
                    if (owner == null || (clanLeader = owner.getLeader()) == null || !clanLeader.isOnline()) continue;
                    clanLeader.getPlayerInstance().sendPacket(SystemMessageId.THE_MANOR_INFORMATION_HAS_BEEN_UPDATED);
                }
                this._mode = ManorMode.MODIFIABLE;
                break;
            }
            case MODIFIABLE: {
                this._mode = ManorMode.APPROVED;
                for (Castle castle : CastleManager.getInstance().getCastles()) {
                    L2Clan owner = castle.getOwner();
                    if (owner == null) continue;
                    int slots = 0;
                    int castleId = castle.getResidenceId();
                    ItemContainer cwh = owner.getWarehouse();
                    for (CropProcure crop : this._procureNext.get(castleId)) {
                        if (crop.getStartAmount() <= 0L || cwh.getItemsByItemId(this.getSeedByCrop(crop.getId()).getMatureId()) != null) continue;
                        ++slots;
                    }
                    long manorCost = this.getManorCost(castleId, true);
                    if (!cwh.validateCapacity(slots) && castle.getTreasury() < manorCost) {
                        this._productionNext.get(castleId).clear();
                        this._procureNext.get(castleId).clear();
                        L2ClanMember clanLeader = owner.getLeader();
                        if (clanLeader == null || !clanLeader.isOnline()) continue;
                        clanLeader.getPlayerInstance().sendPacket(SystemMessageId.THE_AMOUNT_IS_NOT_SUFFICIENT_AND_SO_THE_MANOR_IS_NOT_IN_OPERATION);
                        continue;
                    }
                    castle.addToTreasuryNoTax(-manorCost);
                }
                if (!Configuration.general().manorSaveAllActions()) break;
                this.storeMe();
            }
        }
        this.scheduleModeChange();
        if (Configuration.general().debug()) {
            LOG.info("Manor mode changed to {}!", (Object)this._mode);
        }
    }

    public void setNextSeedProduction(List<SeedProduction> list, int castleId) {
        this._productionNext.put(castleId, list);
        if (Configuration.general().manorSaveAllActions()) {
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement dps = con.prepareStatement("DELETE FROM castle_manor_production WHERE castle_id = ? AND next_period = 1");
                 PreparedStatement ips = con.prepareStatement(INSERT_PRODUCT);){
                dps.setInt(1, castleId);
                dps.executeUpdate();
                if (!list.isEmpty()) {
                    for (SeedProduction sp : list) {
                        ips.setInt(1, castleId);
                        ips.setInt(2, sp.getId());
                        ips.setLong(3, sp.getAmount());
                        ips.setLong(4, sp.getStartAmount());
                        ips.setLong(5, sp.getPrice());
                        ips.setBoolean(6, true);
                        ips.addBatch();
                    }
                    ips.executeBatch();
                }
            }
            catch (Exception ex) {
                LOG.error("Unable to store manor data!", ex);
            }
        }
    }

    public void setNextCropProcure(List<CropProcure> list, int castleId) {
        this._procureNext.put(castleId, list);
        if (Configuration.general().manorSaveAllActions()) {
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement dps = con.prepareStatement("DELETE FROM castle_manor_procure WHERE castle_id = ? AND next_period = 1");
                 PreparedStatement ips = con.prepareStatement(INSERT_CROP);){
                dps.setInt(1, castleId);
                dps.executeUpdate();
                if (!list.isEmpty()) {
                    for (CropProcure cp : list) {
                        ips.setInt(1, castleId);
                        ips.setInt(2, cp.getId());
                        ips.setLong(3, cp.getAmount());
                        ips.setLong(4, cp.getStartAmount());
                        ips.setLong(5, cp.getPrice());
                        ips.setInt(6, cp.getReward());
                        ips.setBoolean(7, true);
                        ips.addBatch();
                    }
                    ips.executeBatch();
                }
            }
            catch (Exception ex) {
                LOG.warn("Unable to store manor data!", ex);
            }
        }
    }

    public void updateCurrentProduction(int castleId, Collection<SeedProduction> items) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE castle_manor_production SET amount = ? WHERE castle_id = ? AND seed_id = ? AND next_period = 0");){
            for (SeedProduction sp : items) {
                ps.setLong(1, sp.getAmount());
                ps.setInt(2, castleId);
                ps.setInt(3, sp.getId());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (Exception ex) {
            LOG.warn("Unable to store manor data!", ex);
        }
    }

    public void updateCurrentProcure(int castleId, Collection<CropProcure> items) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE castle_manor_procure SET amount = ? WHERE castle_id = ? AND crop_id = ? AND next_period = 0");){
            for (CropProcure sp : items) {
                ps.setLong(1, sp.getAmount());
                ps.setInt(2, castleId);
                ps.setInt(3, sp.getId());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (Exception ex) {
            LOG.warn("Unable to store manor data!", ex);
        }
    }

    public List<SeedProduction> getSeedProduction(int castleId, boolean nextPeriod) {
        return nextPeriod ? this._productionNext.get(castleId) : this._production.get(castleId);
    }

    public SeedProduction getSeedProduct(int castleId, int seedId, boolean nextPeriod) {
        for (SeedProduction sp : this.getSeedProduction(castleId, nextPeriod)) {
            if (sp.getId() != seedId) continue;
            return sp;
        }
        return null;
    }

    public List<CropProcure> getCropProcure(int castleId, boolean nextPeriod) {
        return nextPeriod ? this._procureNext.get(castleId) : this._procure.get(castleId);
    }

    public CropProcure getCropProcure(int castleId, int cropId, boolean nextPeriod) {
        for (CropProcure cp : this.getCropProcure(castleId, nextPeriod)) {
            if (cp.getId() != cropId) continue;
            return cp;
        }
        return null;
    }

    public long getManorCost(int castleId, boolean nextPeriod) {
        List<CropProcure> procure = this.getCropProcure(castleId, nextPeriod);
        List<SeedProduction> production = this.getSeedProduction(castleId, nextPeriod);
        long total = 0L;
        for (SeedProduction seed : production) {
            L2Seed s = this.getSeed(seed.getId());
            total += s == null ? 1L : (long)s.getSeedReferencePrice() * seed.getStartAmount();
        }
        for (CropProcure crop : procure) {
            total += crop.getPrice() * crop.getStartAmount();
        }
        return total;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean storeMe() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 37[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void resetManorData(int castleId) {
        if (!Configuration.general().allowManor()) {
            return;
        }
        this._procure.get(castleId).clear();
        this._procureNext.get(castleId).clear();
        this._production.get(castleId).clear();
        this._productionNext.get(castleId).clear();
        if (Configuration.general().allowManor()) {
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement ds = con.prepareStatement("DELETE FROM castle_manor_production WHERE castle_id = ?");
                 PreparedStatement dc = con.prepareStatement("DELETE FROM castle_manor_procure WHERE castle_id = ?");){
                ds.setInt(1, castleId);
                ds.executeUpdate();
                dc.setInt(1, castleId);
                dc.executeUpdate();
            }
            catch (Exception ex) {
                LOG.warn("Unable to store manor data!", ex);
            }
        }
    }

    public boolean isUnderMaintenance() {
        return this._mode.equals((Object)ManorMode.MAINTENANCE);
    }

    public boolean isManorApproved() {
        return this._mode.equals((Object)ManorMode.APPROVED);
    }

    public boolean isModifiablePeriod() {
        return this._mode.equals((Object)ManorMode.MODIFIABLE);
    }

    public String getCurrentModeName() {
        return this._mode.toString();
    }

    public String getNextModeChange() {
        return new SimpleDateFormat("dd/MM HH:mm:ss").format(this._nextModeChange.getTime());
    }

    public List<L2Seed> getCrops() {
        ArrayList<L2Seed> seeds = new ArrayList<L2Seed>();
        ArrayList<Integer> cropIds = new ArrayList<Integer>();
        for (L2Seed seed : _seeds.values()) {
            if (cropIds.contains(seed.getCropId())) continue;
            seeds.add(seed);
            cropIds.add(seed.getCropId());
        }
        cropIds.clear();
        return seeds;
    }

    public Set<L2Seed> getSeedsForCastle(int castleId) {
        return _seeds.values().stream().filter(s -> s.getCastleId() == castleId).collect(Collectors.toSet());
    }

    public Set<Integer> getSeedIds() {
        return _seeds.keySet();
    }

    public Set<Integer> getCropIds() {
        return _seeds.values().stream().map(L2Seed::getCropId).collect(Collectors.toSet());
    }

    public L2Seed getSeed(int seedId) {
        return _seeds.get(seedId);
    }

    public L2Seed getSeedByCrop(int cropId, int castleId) {
        for (L2Seed s : this.getSeedsForCastle(castleId)) {
            if (s.getCropId() != cropId) continue;
            return s;
        }
        return null;
    }

    public L2Seed getSeedByCrop(int cropId) {
        for (L2Seed s : _seeds.values()) {
            if (s.getCropId() != cropId) continue;
            return s;
        }
        return null;
    }

    public static CastleManorManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final CastleManorManager INSTANCE = new CastleManorManager();

        private SingletonHolder() {
        }
    }
}

