/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.instancemanager.AuctionManager;
import com.l2jserver.gameserver.instancemanager.ClanHallSiegeManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.entity.Auction;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.clanhall.AuctionableHall;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.zone.type.L2ClanHallZone;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClanHallManager {
    private static final Logger LOG = LoggerFactory.getLogger(ClanHallManager.class);
    private final Map<Integer, AuctionableHall> _clanHall = new ConcurrentHashMap<Integer, AuctionableHall>();
    private final Map<Integer, AuctionableHall> _freeClanHall = new ConcurrentHashMap<Integer, AuctionableHall>();
    private final Map<Integer, AuctionableHall> _allAuctionableClanHalls = new HashMap<Integer, AuctionableHall>();
    private static final Map<Integer, ClanHall> _allClanHalls = new HashMap<Integer, ClanHall>();
    private boolean _loaded = false;

    public boolean loaded() {
        return this._loaded;
    }

    protected ClanHallManager() {
        this.load();
    }

    private void load() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT * FROM clanhall ORDER BY id");){
            while (rs.next()) {
                StatsSet set = new StatsSet();
                int id = rs.getInt("id");
                int ownerId = rs.getInt("ownerId");
                int lease = rs.getInt("lease");
                set.set("id", id);
                set.set("name", rs.getString("name"));
                set.set("ownerId", ownerId);
                set.set("lease", lease);
                set.set("desc", rs.getString("desc"));
                set.set("location", rs.getString("location"));
                set.set("paidUntil", rs.getLong("paidUntil"));
                set.set("grade", rs.getInt("Grade"));
                set.set("paid", rs.getBoolean("paid"));
                AuctionableHall ch = new AuctionableHall(set);
                this._allAuctionableClanHalls.put(id, ch);
                this.addClanHall(ch);
                if (ch.getOwnerId() > 0) {
                    this._clanHall.put(id, ch);
                    continue;
                }
                this._freeClanHall.put(id, ch);
                Auction auc = AuctionManager.getInstance().getAuction(id);
                if (auc != null || lease <= 0) continue;
                AuctionManager.getInstance().initNPC(id);
            }
            LOG.info("Loaded {} clan halls.", (Object)this.getClanHalls().size());
            LOG.info("Loaded {} free clan halls.", (Object)this.getFreeClanHalls().size());
            this._loaded = true;
        }
        catch (Exception ex) {
            LOG.warn("There has been an error loading clan halls from database!", ex);
        }
    }

    public Map<Integer, ClanHall> getAllClanHalls() {
        return _allClanHalls;
    }

    public Map<Integer, AuctionableHall> getFreeClanHalls() {
        return this._freeClanHall;
    }

    public Map<Integer, AuctionableHall> getClanHalls() {
        return this._clanHall;
    }

    public Map<Integer, AuctionableHall> getAllAuctionableClanHalls() {
        return this._allAuctionableClanHalls;
    }

    public void addClanHall(ClanHall hall) {
        _allClanHalls.put(hall.getId(), hall);
    }

    public boolean isFree(int chId) {
        return this._freeClanHall.containsKey(chId);
    }

    public synchronized void setFree(int chId) {
        this._freeClanHall.put(chId, this._clanHall.get(chId));
        ClanTable.getInstance().getClan(this._freeClanHall.get(chId).getOwnerId()).setHideoutId(0);
        this._freeClanHall.get(chId).free();
        this._clanHall.remove(chId);
    }

    public synchronized void setOwner(int chId, L2Clan clan) {
        if (!this._clanHall.containsKey(chId)) {
            this._clanHall.put(chId, this._freeClanHall.get(chId));
            this._freeClanHall.remove(chId);
        } else {
            this._clanHall.get(chId).free();
        }
        ClanTable.getInstance().getClan(clan.getId()).setHideoutId(chId);
        this._clanHall.get(chId).setOwner(clan);
    }

    public ClanHall getClanHallById(int clanHallId) {
        return _allClanHalls.get(clanHallId);
    }

    public AuctionableHall getAuctionableHallById(int clanHallId) {
        return this._allAuctionableClanHalls.get(clanHallId);
    }

    public ClanHall getClanHall(int x, int y, int z) {
        for (ClanHall temp : _allClanHalls.values()) {
            if (!temp.checkIfInZone(x, y, z)) continue;
            return temp;
        }
        return null;
    }

    public ClanHall getClanHall(L2Object activeObject) {
        return this.getClanHall(activeObject.getX(), activeObject.getY(), activeObject.getZ());
    }

    public AuctionableHall getNearbyClanHall(int x, int y, int maxDist) {
        L2ClanHallZone zone;
        for (Map.Entry<Integer, AuctionableHall> ch : this._clanHall.entrySet()) {
            zone = ch.getValue().getZone();
            if (zone == null || !(zone.getDistanceToZone(x, y) < (double)maxDist)) continue;
            return ch.getValue();
        }
        for (Map.Entry<Integer, AuctionableHall> ch : this._freeClanHall.entrySet()) {
            zone = ch.getValue().getZone();
            if (zone == null || !(zone.getDistanceToZone(x, y) < (double)maxDist)) continue;
            return ch.getValue();
        }
        return null;
    }

    public ClanHall getNearbyAbstractHall(int x, int y, int maxDist) {
        for (Map.Entry<Integer, ClanHall> ch : _allClanHalls.entrySet()) {
            L2ClanHallZone zone = ch.getValue().getZone();
            if (zone == null || !(zone.getDistanceToZone(x, y) < (double)maxDist)) continue;
            return ch.getValue();
        }
        return null;
    }

    public AuctionableHall getClanHallByOwner(L2Clan clan) {
        for (Map.Entry<Integer, AuctionableHall> ch : this._clanHall.entrySet()) {
            if (clan.getId() != ch.getValue().getOwnerId()) continue;
            return ch.getValue();
        }
        return null;
    }

    public ClanHall getAbstractHallByOwner(L2Clan clan) {
        for (Map.Entry<Integer, AuctionableHall> entry : this._clanHall.entrySet()) {
            if (clan.getId() != entry.getValue().getOwnerId()) continue;
            return entry.getValue();
        }
        for (Map.Entry<Integer, ClanHall> entry : ClanHallSiegeManager.getInstance().getConquerableHalls().entrySet()) {
            if (clan.getId() != ((SiegableHall)entry.getValue()).getOwnerId()) continue;
            return entry.getValue();
        }
        return null;
    }

    public static ClanHallManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final ClanHallManager INSTANCE = new ClanHallManager();

        private SingletonHolder() {
        }
    }
}

