/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.clanhall.ClanHallSiegeEngine;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.zone.type.L2SiegableHallZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClanHallSiegeManager {
    private static final Logger LOG = LoggerFactory.getLogger(ClanHallSiegeManager.class);
    private static final String SQL_LOAD_HALLS = "SELECT * FROM siegable_clanhall";
    private final Map<Integer, SiegableHall> _siegableHalls = new HashMap<Integer, SiegableHall>();

    protected ClanHallSiegeManager() {
        this.loadClanHalls();
    }

    private void loadClanHalls() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery(SQL_LOAD_HALLS);){
            this._siegableHalls.clear();
            while (rs.next()) {
                int id = rs.getInt("clanHallId");
                StatsSet set = new StatsSet();
                set.set("id", id);
                set.set("name", rs.getString("name"));
                set.set("ownerId", rs.getInt("ownerId"));
                set.set("desc", rs.getString("desc"));
                set.set("location", rs.getString("location"));
                set.set("nextSiege", rs.getLong("nextSiege"));
                set.set("siegeLength", rs.getLong("siege_length"));
                set.set("scheduleConfig", rs.getString("schedule_config"));
                SiegableHall hall = new SiegableHall(set);
                this._siegableHalls.put(id, hall);
                ClanHallManager.getInstance().addClanHall(hall);
            }
            LOG.info("Loaded {} conquerable clan halls.", (Object)this._siegableHalls.size());
        }
        catch (Exception ex) {
            LOG.warn("Could not load siegable clan halls!", ex);
        }
    }

    public Map<Integer, SiegableHall> getConquerableHalls() {
        return this._siegableHalls;
    }

    public SiegableHall getSiegableHall(int clanHall) {
        return this.getConquerableHalls().get(clanHall);
    }

    public SiegableHall getNearbyClanHall(L2Character activeChar) {
        return this.getNearbyClanHall(activeChar.getX(), activeChar.getY(), 10000);
    }

    public SiegableHall getNearbyClanHall(int x, int y, int maxDist) {
        for (Map.Entry<Integer, SiegableHall> ch : this._siegableHalls.entrySet()) {
            L2SiegableHallZone zone = ch.getValue().getZone();
            if (zone == null || !(zone.getDistanceToZone(x, y) < (double)maxDist)) continue;
            return ch.getValue();
        }
        return null;
    }

    public ClanHallSiegeEngine getSiege(L2Character character) {
        SiegableHall hall = this.getNearbyClanHall(character);
        if (hall == null) {
            return null;
        }
        return hall.getSiege();
    }

    public void registerClan(L2Clan clan, SiegableHall hall, L2PcInstance player) {
        if (clan.getLevel() < Configuration.clanhall().getMinClanLevel()) {
            player.sendMessage("Only clans of level " + Configuration.clanhall().getMinClanLevel() + " or higher may register for a castle siege");
        } else if (hall.isWaitingBattle()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DEADLINE_FOR_SIEGE_S1_PASSED);
            sm.addString(hall.getName());
            player.sendPacket(sm);
        } else if (hall.isInSiege()) {
            player.sendPacket(SystemMessageId.NOT_SIEGE_REGISTRATION_TIME2);
        } else if (hall.getOwnerId() == clan.getId()) {
            player.sendPacket(SystemMessageId.CLAN_THAT_OWNS_CASTLE_IS_AUTOMATICALLY_REGISTERED_DEFENDING);
        } else if (clan.getCastleId() != 0 || clan.getHideoutId() != 0) {
            player.sendPacket(SystemMessageId.CLAN_THAT_OWNS_CASTLE_CANNOT_PARTICIPATE_OTHER_SIEGE);
        } else if (hall.getSiege().checkIsAttacker(clan)) {
            player.sendPacket(SystemMessageId.ALREADY_REQUESTED_SIEGE_BATTLE);
        } else if (this.isClanParticipating(clan)) {
            player.sendPacket(SystemMessageId.APPLICATION_DENIED_BECAUSE_ALREADY_SUBMITTED_A_REQUEST_FOR_ANOTHER_SIEGE_BATTLE);
        } else if (hall.getSiege().getAttackers().size() >= Configuration.clanhall().getMaxAttackers()) {
            player.sendPacket(SystemMessageId.ATTACKER_SIDE_FULL);
        } else {
            hall.addAttacker(clan);
        }
    }

    public void unRegisterClan(L2Clan clan, SiegableHall hall) {
        if (!hall.isRegistering()) {
            return;
        }
        hall.removeAttacker(clan);
    }

    public boolean isClanParticipating(L2Clan clan) {
        for (SiegableHall hall : this.getConquerableHalls().values()) {
            if (hall.getSiege() == null || !hall.getSiege().checkIsAttacker(clan)) continue;
            return true;
        }
        return false;
    }

    public void onServerShutDown() {
        for (SiegableHall hall : this.getConquerableHalls().values()) {
            if (hall.getId() == 62 || hall.getSiege() == null) continue;
            hall.getSiege().saveAttackers();
        }
    }

    public static ClanHallSiegeManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static final class SingletonHolder {
        protected static final ClanHallSiegeManager INSTANCE = new ClanHallSiegeManager();

        private SingletonHolder() {
        }
    }
}

