/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.model.DimensionalRiftRoom;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.DimensionalRift;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class DimensionalRiftManager {
    private static final Logger LOG = LoggerFactory.getLogger(DimensionalRiftManager.class);
    private final Map<Byte, Map<Byte, DimensionalRiftRoom>> _rooms = new HashMap<Byte, Map<Byte, DimensionalRiftRoom>>(7);

    protected DimensionalRiftManager() {
        this.loadRooms();
        this.loadSpawns();
    }

    public DimensionalRiftRoom getRoom(byte type, byte room) {
        return this._rooms.get(type) == null ? null : this._rooms.get(type).get(room);
    }

    private void loadRooms() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            File file = new File(Configuration.server().getDatapackRoot(), "data/dimensionalRiftRooms.xml");
            if (!file.exists()) {
                LOG.warn("Could not find file {}!", (Object)file.getAbsoluteFile());
                return;
            }
            Document doc = factory.newDocumentBuilder().parse(file);
            for (Node list = doc.getFirstChild(); list != null; list = list.getNextSibling()) {
                if (!"list".equalsIgnoreCase(list.getNodeName())) continue;
                for (Node room = list.getFirstChild(); room != null; room = room.getNextSibling()) {
                    if (!"room".equalsIgnoreCase(room.getNodeName())) continue;
                    NamedNodeMap attrs = room.getAttributes();
                    byte type = Byte.parseByte(attrs.getNamedItem("type").getNodeValue());
                    byte id = Byte.parseByte(attrs.getNamedItem("id").getNodeValue());
                    int xMin = Integer.parseInt(attrs.getNamedItem("xMin").getNodeValue());
                    int xMax = Integer.parseInt(attrs.getNamedItem("xMax").getNodeValue());
                    int yMin = Integer.parseInt(attrs.getNamedItem("yMin").getNodeValue());
                    int yMax = Integer.parseInt(attrs.getNamedItem("yMax").getNodeValue());
                    int zMin = Integer.parseInt(attrs.getNamedItem("zMin").getNodeValue());
                    int zMax = Integer.parseInt(attrs.getNamedItem("zMax").getNodeValue());
                    int xT = Integer.parseInt(attrs.getNamedItem("xT").getNodeValue());
                    int yT = Integer.parseInt(attrs.getNamedItem("yT").getNodeValue());
                    int zT = Integer.parseInt(attrs.getNamedItem("zT").getNodeValue());
                    boolean boss = Boolean.parseBoolean(attrs.getNamedItem("boss").getNodeValue());
                    if (!this._rooms.containsKey(type)) {
                        this._rooms.put(type, new HashMap(9));
                    }
                    this._rooms.get(type).put(id, new DimensionalRiftRoom(type, id, xMin, xMax, yMin, yMax, zMin, zMax, xT, yT, zT, boss));
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("There was an error on loading Dimensional Rift rooms!", ex);
        }
        int typeSize = this._rooms.size();
        int roomSize = 0;
        for (byte b : this._rooms.keySet()) {
            roomSize += this._rooms.get(b).size();
        }
        LOG.info("Loaded {} room types with {} rooms.", (Object)typeSize, (Object)roomSize);
    }

    public void loadSpawns() {
        int countGood = 0;
        int countBad = 0;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            File file = new File(Configuration.server().getDatapackRoot(), "data/dimensionalRiftSpawns.xml");
            if (!file.exists()) {
                LOG.warn("Could not find file {}!", (Object)file.getAbsoluteFile());
                return;
            }
            Document doc = factory.newDocumentBuilder().parse(file);
            for (Node rift = doc.getFirstChild(); rift != null; rift = rift.getNextSibling()) {
                if (!"rift".equalsIgnoreCase(rift.getNodeName())) continue;
                for (Node area = rift.getFirstChild(); area != null; area = area.getNextSibling()) {
                    if (!"area".equalsIgnoreCase(area.getNodeName())) continue;
                    NamedNodeMap attrs = area.getAttributes();
                    byte type = Byte.parseByte(attrs.getNamedItem("type").getNodeValue());
                    for (Node room = area.getFirstChild(); room != null; room = room.getNextSibling()) {
                        if (!"room".equalsIgnoreCase(room.getNodeName())) continue;
                        attrs = room.getAttributes();
                        byte roomId = Byte.parseByte(attrs.getNamedItem("id").getNodeValue());
                        for (Node spawn = room.getFirstChild(); spawn != null; spawn = spawn.getNextSibling()) {
                            if (!"spawn".equalsIgnoreCase(spawn.getNodeName())) continue;
                            attrs = spawn.getAttributes();
                            int mobId = Integer.parseInt(attrs.getNamedItem("mobId").getNodeValue());
                            int delay = Integer.parseInt(attrs.getNamedItem("delay").getNodeValue());
                            int count = Integer.parseInt(attrs.getNamedItem("count").getNodeValue());
                            if (!this._rooms.containsKey(type)) {
                                LOG.warn("Type {} not found!", (Object)type);
                            } else if (!this._rooms.get(type).containsKey(roomId)) {
                                LOG.warn("Room {} in type {} not found!", (Object)roomId, (Object)type);
                            }
                            for (int i = 0; i < count; ++i) {
                                DimensionalRiftRoom riftRoom = this._rooms.get(type).get(roomId);
                                int x = riftRoom.getRandomX();
                                int y = riftRoom.getRandomY();
                                int z = riftRoom.getTeleportCoordinates().getZ();
                                if (this._rooms.containsKey(type) && this._rooms.get(type).containsKey(roomId)) {
                                    L2Spawn spawnDat = new L2Spawn(mobId);
                                    spawnDat.setAmount(1);
                                    spawnDat.setX(x);
                                    spawnDat.setY(y);
                                    spawnDat.setZ(z);
                                    spawnDat.setHeading(-1);
                                    spawnDat.setRespawnDelay(delay);
                                    SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                                    this._rooms.get(type).get(roomId).getSpawns().add(spawnDat);
                                    ++countGood;
                                    continue;
                                }
                                ++countBad;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("There was an error on loading Dimensional Rift spawns!", ex);
        }
        LOG.info("Loaded {} Dimensional Rift spawns.", (Object)countGood);
        if (countBad > 0) {
            LOG.warn("There has been {} errors in DImensinal Rift spawns!", (Object)countBad);
        }
    }

    public void reload() {
        for (byte b : this._rooms.keySet()) {
            for (byte i : this._rooms.get(b).keySet()) {
                this._rooms.get(b).get(i).getSpawns().clear();
            }
            this._rooms.get(b).clear();
        }
        this._rooms.clear();
        this.loadRooms();
        this.loadSpawns();
    }

    public boolean checkIfInRiftZone(int x, int y, int z, boolean ignorePeaceZone) {
        if (ignorePeaceZone) {
            return this._rooms.get((byte)0).get((byte)1).checkIfInZone(x, y, z);
        }
        return this._rooms.get((byte)0).get((byte)1).checkIfInZone(x, y, z) && !this._rooms.get((byte)0).get((byte)0).checkIfInZone(x, y, z);
    }

    public boolean checkIfInPeaceZone(int x, int y, int z) {
        return this._rooms.get((byte)0).get((byte)0).checkIfInZone(x, y, z);
    }

    public void teleportToWaitingRoom(L2PcInstance player) {
        player.teleToLocation(this.getRoom((byte)0, (byte)0).getTeleportCoordinates());
    }

    public synchronized void start(L2PcInstance player, byte type, L2Npc npc) {
        byte room;
        do {
            List<Byte> emptyRooms = this.getFreeRooms(type);
            room = emptyRooms.get(Rnd.get((int)1, (int)emptyRooms.size()) - 1);
        } while (this._rooms.get(type).get(room).getParty() != null);
        new DimensionalRift(npc, player.getParty(), type, room);
    }

    public void killRift(DimensionalRift d) {
        if (d.getTeleportTimerTask() != null) {
            d.getTeleportTimerTask().cancel();
        }
        d.setTeleportTimerTask(null);
        if (d.getTeleportTimer() != null) {
            d.getTeleportTimer().cancel();
        }
        d.setTeleportTimer(null);
        if (d.getSpawnTimerTask() != null) {
            d.getSpawnTimerTask().cancel();
        }
        d.setSpawnTimerTask(null);
        if (d.getSpawnTimer() != null) {
            d.getSpawnTimer().cancel();
        }
        d.setSpawnTimer(null);
    }

    public boolean isAllowedEnter(byte type) {
        int count = 0;
        for (DimensionalRiftRoom room : this._rooms.get(type).values()) {
            if (room.getParty() == null) continue;
            ++count;
        }
        return count < this._rooms.get(type).size() - 1;
    }

    public List<Byte> getFreeRooms(byte type) {
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (DimensionalRiftRoom room : this._rooms.get(type).values()) {
            if (room.getParty() != null) continue;
            list.add(room.getRoom());
        }
        return list;
    }

    public static DimensionalRiftManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final DimensionalRiftManager _instance = new DimensionalRiftManager();

        private SingletonHolder() {
        }
    }
}

