/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.DoorData;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.instancemanager.tasks.FourSepulchersChangeAttackTimeTask;
import com.l2jserver.gameserver.instancemanager.tasks.FourSepulchersChangeCoolDownTimeTask;
import com.l2jserver.gameserver.instancemanager.tasks.FourSepulchersChangeEntryTimeTask;
import com.l2jserver.gameserver.instancemanager.tasks.FourSepulchersChangeWarmUpTimeTask;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SepulcherMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SepulcherNpcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FourSepulchersManager {
    private static final Logger LOG = LoggerFactory.getLogger(FourSepulchersManager.class);
    private static final int QUEST_ID = 620;
    private static final int ENTRANCE_PASS = 7075;
    private static final int USED_PASS = 7261;
    private static final int CHAPEL_KEY = 7260;
    private static final int ANTIQUE_BROOCH = 7262;
    private boolean _firstTimeRun;
    private boolean _inEntryTime = false;
    private boolean _inWarmUpTime = false;
    private boolean _inAttackTime = false;
    private boolean _inCoolDownTime = false;
    private ScheduledFuture<?> _changeCoolDownTimeTask = null;
    private ScheduledFuture<?> _changeEntryTimeTask = null;
    private ScheduledFuture<?> _changeWarmUpTimeTask = null;
    private ScheduledFuture<?> _changeAttackTimeTask = null;
    private final int[][] _startHallSpawn = new int[][]{{181632, -85587, -7218}, {179963, -88978, -7218}, {173217, -86132, -7218}, {175608, -82296, -7218}};
    private final int[][][] _shadowSpawnLoc = new int[][][]{new int[][]{{25339, 191231, -85574, -7216, 33380}, {25349, 189534, -88969, -7216, 32768}, {25346, 173195, -76560, -7215, 49277}, {25342, 175591, -72744, -7215, 49317}}, new int[][]{{25342, 191231, -85574, -7216, 33380}, {25339, 189534, -88969, -7216, 32768}, {25349, 173195, -76560, -7215, 49277}, {25346, 175591, -72744, -7215, 49317}}, new int[][]{{25346, 191231, -85574, -7216, 33380}, {25342, 189534, -88969, -7216, 32768}, {25339, 173195, -76560, -7215, 49277}, {25349, 175591, -72744, -7215, 49317}}, new int[][]{{25349, 191231, -85574, -7216, 33380}, {25346, 189534, -88969, -7216, 32768}, {25342, 173195, -76560, -7215, 49277}, {25339, 175591, -72744, -7215, 49317}}};
    protected Map<Integer, Boolean> _archonSpawned = new ConcurrentHashMap<Integer, Boolean>();
    protected Map<Integer, Boolean> _hallInUse = new ConcurrentHashMap<Integer, Boolean>();
    protected Map<Integer, L2PcInstance> _challengers = new ConcurrentHashMap<Integer, L2PcInstance>();
    protected Map<Integer, int[]> _startHallSpawns = new HashMap<Integer, int[]>();
    protected Map<Integer, Integer> _hallGateKeepers = new HashMap<Integer, Integer>();
    protected Map<Integer, Integer> _keyBoxNpc = new HashMap<Integer, Integer>();
    protected Map<Integer, Integer> _victim = new HashMap<Integer, Integer>();
    protected Map<Integer, L2Spawn> _executionerSpawns = new HashMap<Integer, L2Spawn>();
    protected Map<Integer, L2Spawn> _keyBoxSpawns = new HashMap<Integer, L2Spawn>();
    protected Map<Integer, L2Spawn> _mysteriousBoxSpawns = new HashMap<Integer, L2Spawn>();
    protected Map<Integer, L2Spawn> _shadowSpawns = new HashMap<Integer, L2Spawn>();
    protected Map<Integer, List<L2Spawn>> _dukeFinalMobs = new HashMap<Integer, List<L2Spawn>>();
    protected Map<Integer, List<L2SepulcherMonsterInstance>> _dukeMobs = new HashMap<Integer, List<L2SepulcherMonsterInstance>>();
    protected Map<Integer, List<L2Spawn>> _emperorsGraveNpcs = new HashMap<Integer, List<L2Spawn>>();
    protected Map<Integer, List<L2Spawn>> _magicalMonsters = new HashMap<Integer, List<L2Spawn>>();
    protected Map<Integer, List<L2Spawn>> _physicalMonsters = new HashMap<Integer, List<L2Spawn>>();
    protected Map<Integer, List<L2SepulcherMonsterInstance>> _viscountMobs = new HashMap<Integer, List<L2SepulcherMonsterInstance>>();
    protected List<L2Spawn> _physicalSpawns;
    protected List<L2Spawn> _magicalSpawns;
    protected List<L2Spawn> _managers;
    protected List<L2Spawn> _dukeFinalSpawns;
    protected List<L2Spawn> _emperorsGraveSpawns;
    protected List<L2Npc> _allMobs = new CopyOnWriteArrayList<L2Npc>();
    private long _attackTimeEnd = 0L;
    private long _coolDownTimeEnd = 0L;
    private long _entryTimeEnd = 0L;
    private long _warmUpTimeEnd = 0L;
    private final byte _newCycleMin = (byte)55;

    public void init() {
        if (this._changeCoolDownTimeTask != null) {
            this._changeCoolDownTimeTask.cancel(true);
        }
        if (this._changeEntryTimeTask != null) {
            this._changeEntryTimeTask.cancel(true);
        }
        if (this._changeWarmUpTimeTask != null) {
            this._changeWarmUpTimeTask.cancel(true);
        }
        if (this._changeAttackTimeTask != null) {
            this._changeAttackTimeTask.cancel(true);
        }
        this._changeCoolDownTimeTask = null;
        this._changeEntryTimeTask = null;
        this._changeWarmUpTimeTask = null;
        this._changeAttackTimeTask = null;
        this._inEntryTime = false;
        this._inWarmUpTime = false;
        this._inAttackTime = false;
        this._inCoolDownTime = false;
        this._firstTimeRun = true;
        this.initFixedInfo();
        this.loadMysteriousBox();
        this.initKeyBoxSpawns();
        this.loadPhysicalMonsters();
        this.loadMagicalMonsters();
        this.initLocationShadowSpawns();
        this.initExecutionerSpawns();
        this.loadDukeMonsters();
        this.loadEmperorsGraveMonsters();
        this.spawnManagers();
        this.timeSelector();
    }

    protected void timeSelector() {
        this.timeCalculator();
        long currentTime = Calendar.getInstance().getTimeInMillis();
        if (currentTime >= this._coolDownTimeEnd && currentTime < this._entryTimeEnd) {
            this.clean();
            this._changeEntryTimeTask = ThreadPoolManager.getInstance().scheduleGeneral(new FourSepulchersChangeEntryTimeTask(), 0L);
            LOG.info("Beginning in entry time");
        } else if (currentTime >= this._entryTimeEnd && currentTime < this._warmUpTimeEnd) {
            this.clean();
            this._changeWarmUpTimeTask = ThreadPoolManager.getInstance().scheduleGeneral(new FourSepulchersChangeWarmUpTimeTask(), 0L);
            LOG.info("Beginning in warm-up time.");
        } else if (currentTime >= this._warmUpTimeEnd && currentTime < this._attackTimeEnd) {
            this.clean();
            this._changeAttackTimeTask = ThreadPoolManager.getInstance().scheduleGeneral(new FourSepulchersChangeAttackTimeTask(), 0L);
            LOG.info("Beginning in attack time.");
        } else {
            this._changeCoolDownTimeTask = ThreadPoolManager.getInstance().scheduleGeneral(new FourSepulchersChangeCoolDownTimeTask(), 0L);
            LOG.info("Beginning in cooldown time.");
        }
    }

    protected void timeCalculator() {
        Calendar tmp = Calendar.getInstance();
        if (tmp.get(12) < 55) {
            tmp.set(10, Calendar.getInstance().get(10) - 1);
        }
        tmp.set(12, 55);
        this._coolDownTimeEnd = tmp.getTimeInMillis();
        this._entryTimeEnd = this._coolDownTimeEnd + Configuration.general().getTimeOfEntry();
        this._warmUpTimeEnd = this._entryTimeEnd + Configuration.general().getTimeOfWarmUp();
        this._attackTimeEnd = this._warmUpTimeEnd + Configuration.general().getTimeOfAttack();
    }

    public void clean() {
        for (int i2 = 31921; i2 < 31925; ++i2) {
            if (!this._startHallSpawns.containsKey(i2)) {
                LOG.warn("NPC Id {} is not inside {}!", (Object)i2, (Object)this._startHallSpawns);
                continue;
            }
            int[] location = this._startHallSpawns.get(i2);
            GrandBossManager.getInstance().getZone(location[0], location[1], location[2]).oustAllPlayers();
        }
        this.deleteAllMobs();
        this.closeAllDoors();
        this._hallInUse.clear();
        this._hallInUse.put(31921, false);
        this._hallInUse.put(31922, false);
        this._hallInUse.put(31923, false);
        this._hallInUse.put(31924, false);
        this._archonSpawned.replaceAll((i, v) -> false);
    }

    protected void spawnManagers() {
        this._managers = new CopyOnWriteArrayList<L2Spawn>();
        for (int npcId = 31921; npcId <= 31924; ++npcId) {
            try {
                L2Spawn spawnDat = new L2Spawn(npcId);
                spawnDat.setAmount(1);
                spawnDat.setRespawnDelay(60);
                switch (npcId) {
                    case 31921: {
                        spawnDat.setX(181061);
                        spawnDat.setY(-85595);
                        spawnDat.setZ(-7200);
                        spawnDat.setHeading(-32584);
                        break;
                    }
                    case 31922: {
                        spawnDat.setX(179292);
                        spawnDat.setY(-88981);
                        spawnDat.setZ(-7200);
                        spawnDat.setHeading(-33272);
                        break;
                    }
                    case 31923: {
                        spawnDat.setX(173202);
                        spawnDat.setY(-87004);
                        spawnDat.setZ(-7200);
                        spawnDat.setHeading(-16248);
                        break;
                    }
                    case 31924: {
                        spawnDat.setX(175606);
                        spawnDat.setY(-82853);
                        spawnDat.setZ(-7200);
                        spawnDat.setHeading(-16248);
                    }
                }
                this._managers.add(spawnDat);
                SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                spawnDat.doSpawn();
                spawnDat.startRespawn();
                LOG.info("Spawned {}.", (Object)spawnDat.getTemplate().getName());
                continue;
            }
            catch (Exception ex) {
                LOG.warn("There has been an error while spawning managers!", ex);
            }
        }
    }

    protected void initFixedInfo() {
        this._startHallSpawns.put(31921, this._startHallSpawn[0]);
        this._startHallSpawns.put(31922, this._startHallSpawn[1]);
        this._startHallSpawns.put(31923, this._startHallSpawn[2]);
        this._startHallSpawns.put(31924, this._startHallSpawn[3]);
        this._hallInUse.put(31921, false);
        this._hallInUse.put(31922, false);
        this._hallInUse.put(31923, false);
        this._hallInUse.put(31924, false);
        this._hallGateKeepers.put(31925, 25150012);
        this._hallGateKeepers.put(31926, 25150013);
        this._hallGateKeepers.put(31927, 25150014);
        this._hallGateKeepers.put(31928, 25150015);
        this._hallGateKeepers.put(31929, 25150016);
        this._hallGateKeepers.put(31930, 25150002);
        this._hallGateKeepers.put(31931, 25150003);
        this._hallGateKeepers.put(31932, 25150004);
        this._hallGateKeepers.put(31933, 25150005);
        this._hallGateKeepers.put(31934, 25150006);
        this._hallGateKeepers.put(31935, 25150032);
        this._hallGateKeepers.put(31936, 25150033);
        this._hallGateKeepers.put(31937, 25150034);
        this._hallGateKeepers.put(31938, 25150035);
        this._hallGateKeepers.put(31939, 25150036);
        this._hallGateKeepers.put(31940, 25150022);
        this._hallGateKeepers.put(31941, 25150023);
        this._hallGateKeepers.put(31942, 25150024);
        this._hallGateKeepers.put(31943, 25150025);
        this._hallGateKeepers.put(31944, 25150026);
        this._keyBoxNpc.put(18120, 31455);
        this._keyBoxNpc.put(18121, 31455);
        this._keyBoxNpc.put(18122, 31455);
        this._keyBoxNpc.put(18123, 31455);
        this._keyBoxNpc.put(18124, 31456);
        this._keyBoxNpc.put(18125, 31456);
        this._keyBoxNpc.put(18126, 31456);
        this._keyBoxNpc.put(18127, 31456);
        this._keyBoxNpc.put(18128, 31457);
        this._keyBoxNpc.put(18129, 31457);
        this._keyBoxNpc.put(18130, 31457);
        this._keyBoxNpc.put(18131, 31457);
        this._keyBoxNpc.put(18149, 31458);
        this._keyBoxNpc.put(18150, 31459);
        this._keyBoxNpc.put(18151, 31459);
        this._keyBoxNpc.put(18152, 31459);
        this._keyBoxNpc.put(18153, 31459);
        this._keyBoxNpc.put(18154, 31460);
        this._keyBoxNpc.put(18155, 31460);
        this._keyBoxNpc.put(18156, 31460);
        this._keyBoxNpc.put(18157, 31460);
        this._keyBoxNpc.put(18158, 31461);
        this._keyBoxNpc.put(18159, 31461);
        this._keyBoxNpc.put(18160, 31461);
        this._keyBoxNpc.put(18161, 31461);
        this._keyBoxNpc.put(18162, 31462);
        this._keyBoxNpc.put(18163, 31462);
        this._keyBoxNpc.put(18164, 31462);
        this._keyBoxNpc.put(18165, 31462);
        this._keyBoxNpc.put(18183, 31463);
        this._keyBoxNpc.put(18184, 31464);
        this._keyBoxNpc.put(18212, 31465);
        this._keyBoxNpc.put(18213, 31465);
        this._keyBoxNpc.put(18214, 31465);
        this._keyBoxNpc.put(18215, 31465);
        this._keyBoxNpc.put(18216, 31466);
        this._keyBoxNpc.put(18217, 31466);
        this._keyBoxNpc.put(18218, 31466);
        this._keyBoxNpc.put(18219, 31466);
        this._victim.put(18150, 18158);
        this._victim.put(18151, 18159);
        this._victim.put(18152, 18160);
        this._victim.put(18153, 18161);
        this._victim.put(18154, 18162);
        this._victim.put(18155, 18163);
        this._victim.put(18156, 18164);
        this._victim.put(18157, 18165);
    }

    private void loadMysteriousBox() {
        this._mysteriousBoxSpawns.clear();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, key_npc_id FROM four_sepulchers_spawnlist Where spawntype = ? ORDER BY id");){
            ps.setInt(1, 0);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    L2Spawn spawnDat = new L2Spawn(rs.getInt("npc_templateid"));
                    spawnDat.setAmount(rs.getInt("count"));
                    spawnDat.setX(rs.getInt("locx"));
                    spawnDat.setY(rs.getInt("locy"));
                    spawnDat.setZ(rs.getInt("locz"));
                    spawnDat.setHeading(rs.getInt("heading"));
                    spawnDat.setRespawnDelay(rs.getInt("respawn_delay"));
                    SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                    int keyNpcId = rs.getInt("key_npc_id");
                    this._mysteriousBoxSpawns.put(keyNpcId, spawnDat);
                }
            }
            LOG.info("Loaded {} Mysterious-Box spawns.", (Object)this._mysteriousBoxSpawns.size());
        }
        catch (Exception ex) {
            LOG.warn("Misterious-Boc spawn could not be initialized!", ex);
        }
    }

    private void initKeyBoxSpawns() {
        for (Map.Entry<Integer, Integer> keyNpc : this._keyBoxNpc.entrySet()) {
            try {
                L2Spawn spawnDat = new L2Spawn(keyNpc.getValue());
                spawnDat.setAmount(1);
                spawnDat.setX(0);
                spawnDat.setY(0);
                spawnDat.setZ(0);
                spawnDat.setHeading(0);
                spawnDat.setRespawnDelay(3600);
                SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                this._keyBoxSpawns.put(keyNpc.getKey(), spawnDat);
            }
            catch (Exception ex) {
                LOG.warn("Key Box spawn could not be initialized!", ex);
            }
        }
    }

    private void loadPhysicalMonsters() {
        this._physicalMonsters.clear();
        int loaded = 0;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps1 = con.prepareStatement("SELECT Distinct key_npc_id FROM four_sepulchers_spawnlist Where spawntype = ? ORDER BY key_npc_id");){
            ps1.setInt(1, 1);
            try (ResultSet rs1 = ps1.executeQuery();
                 PreparedStatement ps2 = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, key_npc_id FROM four_sepulchers_spawnlist Where key_npc_id = ? and spawntype = ? ORDER BY id");){
                while (rs1.next()) {
                    int keyNpcId = rs1.getInt("key_npc_id");
                    ps2.setInt(1, keyNpcId);
                    ps2.setInt(2, 1);
                    try (ResultSet rs2 = ps2.executeQuery();){
                        this._physicalSpawns = new ArrayList<L2Spawn>();
                        while (rs2.next()) {
                            L2Spawn spawnDat = new L2Spawn(rs2.getInt("npc_templateid"));
                            spawnDat.setAmount(rs2.getInt("count"));
                            spawnDat.setX(rs2.getInt("locx"));
                            spawnDat.setY(rs2.getInt("locy"));
                            spawnDat.setZ(rs2.getInt("locz"));
                            spawnDat.setHeading(rs2.getInt("heading"));
                            spawnDat.setRespawnDelay(rs2.getInt("respawn_delay"));
                            SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                            this._physicalSpawns.add(spawnDat);
                            ++loaded;
                        }
                    }
                    ps2.clearParameters();
                    this._physicalMonsters.put(keyNpcId, this._physicalSpawns);
                }
            }
            LOG.info("Loaded {} Physical type monsters spawns.", (Object)loaded);
        }
        catch (Exception ex) {
            LOG.warn("Physical monsters spawn could not be initialized!", ex);
        }
    }

    private void loadMagicalMonsters() {
        this._magicalMonsters.clear();
        int loaded = 0;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps1 = con.prepareStatement("SELECT Distinct key_npc_id FROM four_sepulchers_spawnlist Where spawntype = ? ORDER BY key_npc_id");){
            ps1.setInt(1, 2);
            try (ResultSet rs1 = ps1.executeQuery();
                 PreparedStatement ps2 = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, key_npc_id FROM four_sepulchers_spawnlist WHERE key_npc_id = ? AND spawntype = ? ORDER BY id");){
                while (rs1.next()) {
                    int keyNpcId = rs1.getInt("key_npc_id");
                    ps2.setInt(1, keyNpcId);
                    ps2.setInt(2, 2);
                    try (ResultSet rset2 = ps2.executeQuery();){
                        this._magicalSpawns = new ArrayList<L2Spawn>();
                        while (rset2.next()) {
                            L2Spawn spawnDat = new L2Spawn(rset2.getInt("npc_templateid"));
                            spawnDat.setAmount(rset2.getInt("count"));
                            spawnDat.setX(rset2.getInt("locx"));
                            spawnDat.setY(rset2.getInt("locy"));
                            spawnDat.setZ(rset2.getInt("locz"));
                            spawnDat.setHeading(rset2.getInt("heading"));
                            spawnDat.setRespawnDelay(rset2.getInt("respawn_delay"));
                            SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                            this._magicalSpawns.add(spawnDat);
                            ++loaded;
                        }
                    }
                    ps2.clearParameters();
                    this._magicalMonsters.put(keyNpcId, this._magicalSpawns);
                }
            }
            LOG.info("Loaded {} Magical monsters spawns.", (Object)loaded);
        }
        catch (Exception ex) {
            LOG.warn("Magical monsters spawn could not be initialized!", ex);
        }
    }

    private void loadDukeMonsters() {
        this._dukeFinalMobs.clear();
        this._archonSpawned.clear();
        int loaded = 0;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps1 = con.prepareStatement("SELECT Distinct key_npc_id FROM four_sepulchers_spawnlist Where spawntype = ? ORDER BY key_npc_id");){
            ps1.setInt(1, 5);
            try (ResultSet rs1 = ps1.executeQuery();
                 PreparedStatement ps2 = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, key_npc_id FROM four_sepulchers_spawnlist WHERE key_npc_id = ? AND spawntype = ? ORDER BY id");){
                while (rs1.next()) {
                    int keyNpcId = rs1.getInt("key_npc_id");
                    ps2.setInt(1, keyNpcId);
                    ps2.setInt(2, 5);
                    try (ResultSet rset2 = ps2.executeQuery();){
                        ps2.clearParameters();
                        this._dukeFinalSpawns = new ArrayList<L2Spawn>();
                        while (rset2.next()) {
                            L2Spawn spawnDat = new L2Spawn(rset2.getInt("npc_templateid"));
                            spawnDat.setAmount(rset2.getInt("count"));
                            spawnDat.setX(rset2.getInt("locx"));
                            spawnDat.setY(rset2.getInt("locy"));
                            spawnDat.setZ(rset2.getInt("locz"));
                            spawnDat.setHeading(rset2.getInt("heading"));
                            spawnDat.setRespawnDelay(rset2.getInt("respawn_delay"));
                            SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                            this._dukeFinalSpawns.add(spawnDat);
                            ++loaded;
                        }
                    }
                    ps2.clearParameters();
                    this._dukeFinalMobs.put(keyNpcId, this._dukeFinalSpawns);
                    this._archonSpawned.put(keyNpcId, false);
                }
            }
            LOG.info("Loaded {} Church of duke monsters spawns.", (Object)loaded);
        }
        catch (Exception ex) {
            LOG.warn("Duke monsters spawn could not be initialized", ex);
        }
    }

    private void loadEmperorsGraveMonsters() {
        this._emperorsGraveNpcs.clear();
        int loaded = 0;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps1 = con.prepareStatement("SELECT Distinct key_npc_id FROM four_sepulchers_spawnlist Where spawntype = ? ORDER BY key_npc_id");){
            ps1.setInt(1, 6);
            try (ResultSet rs1 = ps1.executeQuery();
                 PreparedStatement ps2 = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, key_npc_id FROM four_sepulchers_spawnlist WHERE key_npc_id = ? and spawntype = ? ORDER BY id");){
                while (rs1.next()) {
                    int keyNpcId = rs1.getInt("key_npc_id");
                    ps2.setInt(1, keyNpcId);
                    ps2.setInt(2, 6);
                    try (ResultSet rs2 = ps2.executeQuery();){
                        this._emperorsGraveSpawns = new ArrayList<L2Spawn>();
                        while (rs2.next()) {
                            L2Spawn spawnDat = new L2Spawn(rs2.getInt("npc_templateid"));
                            spawnDat.setAmount(rs2.getInt("count"));
                            spawnDat.setX(rs2.getInt("locx"));
                            spawnDat.setY(rs2.getInt("locy"));
                            spawnDat.setZ(rs2.getInt("locz"));
                            spawnDat.setHeading(rs2.getInt("heading"));
                            spawnDat.setRespawnDelay(rs2.getInt("respawn_delay"));
                            SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                            this._emperorsGraveSpawns.add(spawnDat);
                            ++loaded;
                        }
                    }
                    ps2.clearParameters();
                    this._emperorsGraveNpcs.put(keyNpcId, this._emperorsGraveSpawns);
                }
            }
            LOG.info("Loaded {} Emperor's Grave spawns.", (Object)loaded);
        }
        catch (Exception ex) {
            LOG.warn("Emperor's Grave spawns could not be initialized!", ex);
        }
    }

    protected void initLocationShadowSpawns() {
        int locNo = Rnd.get((int)4);
        int[] gateKeeper = new int[]{31929, 31934, 31939, 31944};
        this._shadowSpawns.clear();
        for (int i = 0; i <= 3; ++i) {
            try {
                L2Spawn spawnDat = new L2Spawn(this._shadowSpawnLoc[locNo][i][0]);
                spawnDat.setAmount(1);
                spawnDat.setX(this._shadowSpawnLoc[locNo][i][1]);
                spawnDat.setY(this._shadowSpawnLoc[locNo][i][2]);
                spawnDat.setZ(this._shadowSpawnLoc[locNo][i][3]);
                spawnDat.setHeading(this._shadowSpawnLoc[locNo][i][4]);
                SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                this._shadowSpawns.put(gateKeeper[i], spawnDat);
                continue;
            }
            catch (Exception ex) {
                LOG.warn("There has been an error spawning shadows!", ex);
            }
        }
    }

    protected void initExecutionerSpawns() {
        for (int keyNpcId : this._victim.keySet()) {
            try {
                L2Spawn spawnDat = new L2Spawn(this._victim.get(keyNpcId));
                spawnDat.setAmount(1);
                spawnDat.setX(0);
                spawnDat.setY(0);
                spawnDat.setZ(0);
                spawnDat.setHeading(0);
                spawnDat.setRespawnDelay(3600);
                SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                this._executionerSpawns.put(keyNpcId, spawnDat);
            }
            catch (Exception ex) {
                LOG.warn("Executioner spawns could not be initialized!", ex);
            }
        }
    }

    public ScheduledFuture<?> getChangeAttackTimeTask() {
        return this._changeAttackTimeTask;
    }

    public void setChangeAttackTimeTask(ScheduledFuture<?> task) {
        this._changeAttackTimeTask = task;
    }

    public ScheduledFuture<?> getChangeCoolDownTimeTask() {
        return this._changeCoolDownTimeTask;
    }

    public void setChangeCoolDownTimeTask(ScheduledFuture<?> task) {
        this._changeCoolDownTimeTask = task;
    }

    public ScheduledFuture<?> getChangeEntryTimeTask() {
        return this._changeEntryTimeTask;
    }

    public void setChangeEntryTimeTask(ScheduledFuture<?> task) {
        this._changeEntryTimeTask = task;
    }

    public ScheduledFuture<?> getChangeWarmUpTimeTask() {
        return this._changeWarmUpTimeTask;
    }

    public void setChangeWarmUpTimeTask(ScheduledFuture<?> task) {
        this._changeWarmUpTimeTask = task;
    }

    public long getAttackTimeEnd() {
        return this._attackTimeEnd;
    }

    public void setAttackTimeEnd(long attackTimeEnd) {
        this._attackTimeEnd = attackTimeEnd;
    }

    public byte getCycleMin() {
        return 55;
    }

    public long getEntrytTimeEnd() {
        return this._entryTimeEnd;
    }

    public void setEntryTimeEnd(long entryTimeEnd) {
        this._entryTimeEnd = entryTimeEnd;
    }

    public long getWarmUpTimeEnd() {
        return this._warmUpTimeEnd;
    }

    public void setWarmUpTimeEnd(long warmUpTimeEnd) {
        this._warmUpTimeEnd = warmUpTimeEnd;
    }

    public boolean isAttackTime() {
        return this._inAttackTime;
    }

    public void setIsAttackTime(boolean attackTime) {
        this._inAttackTime = attackTime;
    }

    public boolean isCoolDownTime() {
        return this._inCoolDownTime;
    }

    public void setIsCoolDownTime(boolean isCoolDownTime) {
        this._inCoolDownTime = isCoolDownTime;
    }

    public boolean isEntryTime() {
        return this._inEntryTime;
    }

    public void setIsEntryTime(boolean entryTime) {
        this._inEntryTime = entryTime;
    }

    public boolean isFirstTimeRun() {
        return this._firstTimeRun;
    }

    public void setIsFirstTimeRun(boolean isFirstTimeRun) {
        this._firstTimeRun = isFirstTimeRun;
    }

    public boolean isWarmUpTime() {
        return this._inWarmUpTime;
    }

    public void setIsWarmUpTime(boolean isWarmUpTime) {
        this._inWarmUpTime = isWarmUpTime;
    }

    public synchronized void tryEntry(L2Npc npc, L2PcInstance player) {
        Quest hostQuest = QuestManager.getInstance().getQuest(620);
        if (hostQuest == null) {
            LOG.warn("Could not find quest Id {}!", (Object)620);
            return;
        }
        int npcId = npc.getId();
        switch (npcId) {
            case 31921: 
            case 31922: 
            case 31923: 
            case 31924: {
                break;
            }
            default: {
                if (!player.isGM()) {
                    LOG.warn("Player {} tried to cheat in four sepulchers.", (Object)player);
                    Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " tried to enter four sepulchers with invalid npc id.");
                }
                return;
            }
        }
        if (this._hallInUse.get(npcId).booleanValue()) {
            this.showHtmlFile(player, npcId + "-FULL.htm", npc, null);
            return;
        }
        if (Configuration.general().getNumberOfNecessaryPartyMembers() > 1) {
            if (!player.isInParty() || player.getParty().getMemberCount() < Configuration.general().getNumberOfNecessaryPartyMembers()) {
                this.showHtmlFile(player, npcId + "-SP.htm", npc, null);
                return;
            }
            if (!player.getParty().isLeader(player)) {
                this.showHtmlFile(player, npcId + "-NL.htm", npc, null);
                return;
            }
            for (L2PcInstance mem : player.getParty().getMembers()) {
                QuestState qs = mem.getQuestState(hostQuest.getName());
                if (qs == null || !qs.isStarted() && !qs.isCompleted()) {
                    this.showHtmlFile(player, npcId + "-NS.htm", npc, mem);
                    return;
                }
                if (mem.getInventory().getItemByItemId(7075) == null) {
                    this.showHtmlFile(player, npcId + "-SE.htm", npc, mem);
                    return;
                }
                if (player.getWeightPenalty() < 3) continue;
                mem.sendPacket(SystemMessageId.INVENTORY_LESS_THAN_80_PERCENT);
                return;
            }
        } else if (Configuration.general().getNumberOfNecessaryPartyMembers() <= 1 && player.isInParty()) {
            if (!player.getParty().isLeader(player)) {
                this.showHtmlFile(player, npcId + "-NL.htm", npc, null);
                return;
            }
            for (L2PcInstance mem : player.getParty().getMembers()) {
                QuestState qs = mem.getQuestState(hostQuest.getName());
                if (qs == null || !qs.isStarted() && !qs.isCompleted()) {
                    this.showHtmlFile(player, npcId + "-NS.htm", npc, mem);
                    return;
                }
                if (mem.getInventory().getItemByItemId(7075) == null) {
                    this.showHtmlFile(player, npcId + "-SE.htm", npc, mem);
                    return;
                }
                if (player.getWeightPenalty() < 3) continue;
                mem.sendPacket(SystemMessageId.INVENTORY_LESS_THAN_80_PERCENT);
                return;
            }
        } else {
            QuestState qs = player.getQuestState(hostQuest.getName());
            if (qs == null || !qs.isStarted() && !qs.isCompleted()) {
                this.showHtmlFile(player, npcId + "-NS.htm", npc, player);
                return;
            }
            if (player.getInventory().getItemByItemId(7075) == null) {
                this.showHtmlFile(player, npcId + "-SE.htm", npc, player);
                return;
            }
            if (player.getWeightPenalty() >= 3) {
                player.sendPacket(SystemMessageId.INVENTORY_LESS_THAN_80_PERCENT);
                return;
            }
        }
        if (!this.isEntryTime()) {
            this.showHtmlFile(player, npcId + "-NE.htm", npc, null);
            return;
        }
        this.showHtmlFile(player, npcId + "-OK.htm", npc, null);
        this.entry(npcId, player);
    }

    private void entry(int npcId, L2PcInstance player) {
        L2ItemInstance hallsKey;
        int drifty;
        int driftx;
        LinkedList<L2PcInstance> members;
        int[] Location2 = this._startHallSpawns.get(npcId);
        if (Configuration.general().getNumberOfNecessaryPartyMembers() > 1) {
            members = new LinkedList<L2PcInstance>();
            for (L2PcInstance mem : player.getParty().getMembers()) {
                if (mem.isDead() || !Util.checkIfInRange(700, player, mem, true)) continue;
                members.add(mem);
            }
            for (L2PcInstance mem : members) {
                GrandBossManager.getInstance().getZone(Location2[0], Location2[1], Location2[2]).allowPlayerEntry(mem, 30);
                driftx = Rnd.get((int)-80, (int)80);
                drifty = Rnd.get((int)-80, (int)80);
                mem.teleToLocation(Location2[0] + driftx, Location2[1] + drifty, Location2[2]);
                mem.destroyItemByItemId("Quest", 7075, 1L, mem, true);
                if (mem.getInventory().getItemByItemId(7262) == null) {
                    mem.addItem("Quest", 7261, 1L, mem, true);
                }
                if ((hallsKey = mem.getInventory().getItemByItemId(7260)) == null) continue;
                mem.destroyItemByItemId("Quest", 7260, hallsKey.getCount(), mem, true);
            }
            this._challengers.put(npcId, player);
            this._hallInUse.put(npcId, true);
        }
        if (Configuration.general().getNumberOfNecessaryPartyMembers() <= 1 && player.isInParty()) {
            members = new LinkedList();
            for (L2PcInstance mem : player.getParty().getMembers()) {
                if (mem.isDead() || !Util.checkIfInRange(700, player, mem, true)) continue;
                members.add(mem);
            }
            for (L2PcInstance mem : members) {
                GrandBossManager.getInstance().getZone(Location2[0], Location2[1], Location2[2]).allowPlayerEntry(mem, 30);
                driftx = Rnd.get((int)-80, (int)80);
                drifty = Rnd.get((int)-80, (int)80);
                mem.teleToLocation(Location2[0] + driftx, Location2[1] + drifty, Location2[2]);
                mem.destroyItemByItemId("Quest", 7075, 1L, mem, true);
                if (mem.getInventory().getItemByItemId(7262) == null) {
                    mem.addItem("Quest", 7261, 1L, mem, true);
                }
                if ((hallsKey = mem.getInventory().getItemByItemId(7260)) == null) continue;
                mem.destroyItemByItemId("Quest", 7260, hallsKey.getCount(), mem, true);
            }
            this._challengers.put(npcId, player);
            this._hallInUse.put(npcId, true);
        } else {
            L2ItemInstance hallsKey2;
            GrandBossManager.getInstance().getZone(Location2[0], Location2[1], Location2[2]).allowPlayerEntry(player, 30);
            driftx = Rnd.get((int)-80, (int)80);
            drifty = Rnd.get((int)-80, (int)80);
            player.teleToLocation(Location2[0] + driftx, Location2[1] + drifty, Location2[2]);
            player.destroyItemByItemId("Quest", 7075, 1L, player, true);
            if (player.getInventory().getItemByItemId(7262) == null) {
                player.addItem("Quest", 7261, 1L, player, true);
            }
            if ((hallsKey2 = player.getInventory().getItemByItemId(7260)) != null) {
                player.destroyItemByItemId("Quest", 7260, hallsKey2.getCount(), player, true);
            }
            this._challengers.put(npcId, player);
            this._hallInUse.put(npcId, true);
        }
    }

    public void spawnMysteriousBox(int npcId) {
        if (!this.isAttackTime()) {
            return;
        }
        L2Spawn spawnDat = this._mysteriousBoxSpawns.get(npcId);
        if (spawnDat != null) {
            this._allMobs.add(spawnDat.doSpawn());
            spawnDat.stopRespawn();
        }
    }

    public void spawnMonster(int npcId) {
        if (!this.isAttackTime()) {
            return;
        }
        CopyOnWriteArrayList<L2SepulcherMonsterInstance> mobs = new CopyOnWriteArrayList<L2SepulcherMonsterInstance>();
        List<L2Spawn> monsterList = Rnd.get((int)2) == 0 ? this._physicalMonsters.get(npcId) : this._magicalMonsters.get(npcId);
        if (monsterList != null) {
            boolean spawnKeyBoxMob = false;
            boolean spawnedKeyBoxMob = false;
            for (L2Spawn spawnDat : monsterList) {
                if (spawnedKeyBoxMob) {
                    spawnKeyBoxMob = false;
                } else {
                    switch (npcId) {
                        case 31469: 
                        case 31474: 
                        case 31479: 
                        case 31484: {
                            if (Rnd.get((int)48) != 0) break;
                            spawnKeyBoxMob = true;
                            break;
                        }
                        default: {
                            spawnKeyBoxMob = false;
                        }
                    }
                }
                L2SepulcherMonsterInstance mob = null;
                if (spawnKeyBoxMob) {
                    try {
                        L2Spawn keyBoxMobSpawn = new L2Spawn(18149);
                        keyBoxMobSpawn.setAmount(1);
                        keyBoxMobSpawn.setLocation(spawnDat.getLocation());
                        keyBoxMobSpawn.setRespawnDelay(3600);
                        SpawnTable.getInstance().addNewSpawn(keyBoxMobSpawn, false);
                        mob = (L2SepulcherMonsterInstance)keyBoxMobSpawn.doSpawn();
                        keyBoxMobSpawn.stopRespawn();
                    }
                    catch (Exception ex) {
                        LOG.warn("Monster spawns could not be initialized!", ex);
                    }
                    spawnedKeyBoxMob = true;
                } else {
                    mob = (L2SepulcherMonsterInstance)spawnDat.doSpawn();
                    spawnDat.stopRespawn();
                }
                if (mob == null) continue;
                mob.mysteriousBoxId = npcId;
                switch (npcId) {
                    case 31469: 
                    case 31472: 
                    case 31474: 
                    case 31477: 
                    case 31479: 
                    case 31482: 
                    case 31484: 
                    case 31487: {
                        mobs.add(mob);
                    }
                }
                this._allMobs.add(mob);
            }
            switch (npcId) {
                case 31469: 
                case 31474: 
                case 31479: 
                case 31484: {
                    this._viscountMobs.put(npcId, mobs);
                    break;
                }
                case 31472: 
                case 31477: 
                case 31482: 
                case 31487: {
                    this._dukeMobs.put(npcId, mobs);
                }
            }
        }
    }

    public synchronized boolean isViscountMobsAnnihilated(int npcId) {
        List<L2SepulcherMonsterInstance> mobs = this._viscountMobs.get(npcId);
        if (mobs == null) {
            return true;
        }
        for (L2SepulcherMonsterInstance mob : mobs) {
            if (mob.isDead()) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean isDukeMobsAnnihilated(int npcId) {
        List<L2SepulcherMonsterInstance> mobs = this._dukeMobs.get(npcId);
        if (mobs == null) {
            return true;
        }
        for (L2SepulcherMonsterInstance mob : mobs) {
            if (mob.isDead()) continue;
            return false;
        }
        return true;
    }

    public void spawnKeyBox(L2Npc activeChar) {
        if (!this.isAttackTime()) {
            return;
        }
        L2Spawn spawnDat = this._keyBoxSpawns.get(activeChar.getId());
        if (spawnDat != null) {
            spawnDat.setAmount(1);
            spawnDat.setX(activeChar.getX());
            spawnDat.setY(activeChar.getY());
            spawnDat.setZ(activeChar.getZ());
            spawnDat.setHeading(activeChar.getHeading());
            spawnDat.setRespawnDelay(3600);
            this._allMobs.add(spawnDat.doSpawn());
            spawnDat.stopRespawn();
        }
    }

    public void spawnExecutionerOfHalisha(L2Npc activeChar) {
        if (!this.isAttackTime()) {
            return;
        }
        L2Spawn spawnDat = this._executionerSpawns.get(activeChar.getId());
        if (spawnDat != null) {
            spawnDat.setAmount(1);
            spawnDat.setX(activeChar.getX());
            spawnDat.setY(activeChar.getY());
            spawnDat.setZ(activeChar.getZ());
            spawnDat.setHeading(activeChar.getHeading());
            spawnDat.setRespawnDelay(3600);
            this._allMobs.add(spawnDat.doSpawn());
            spawnDat.stopRespawn();
        }
    }

    public void spawnArchonOfHalisha(int npcId) {
        if (!this.isAttackTime()) {
            return;
        }
        if (this._archonSpawned.get(npcId).booleanValue()) {
            return;
        }
        List<L2Spawn> monsterList = this._dukeFinalMobs.get(npcId);
        if (monsterList != null) {
            for (L2Spawn spawnDat : monsterList) {
                L2SepulcherMonsterInstance mob = (L2SepulcherMonsterInstance)spawnDat.doSpawn();
                spawnDat.stopRespawn();
                if (mob == null) continue;
                mob.mysteriousBoxId = npcId;
                this._allMobs.add(mob);
            }
            this._archonSpawned.put(npcId, true);
        }
    }

    public void spawnEmperorsGraveNpc(int npcId) {
        if (!this.isAttackTime()) {
            return;
        }
        List<L2Spawn> monsterList = this._emperorsGraveNpcs.get(npcId);
        if (monsterList != null) {
            for (L2Spawn spawnDat : monsterList) {
                this._allMobs.add(spawnDat.doSpawn());
                spawnDat.stopRespawn();
            }
        }
    }

    public void locationShadowSpawns() {
        int locNo = Rnd.get((int)4);
        int[] gateKeeper = new int[]{31929, 31934, 31939, 31944};
        for (int i = 0; i <= 3; ++i) {
            int keyNpcId = gateKeeper[i];
            L2Spawn spawnDat = this._shadowSpawns.get(keyNpcId);
            spawnDat.setX(this._shadowSpawnLoc[locNo][i][1]);
            spawnDat.setY(this._shadowSpawnLoc[locNo][i][2]);
            spawnDat.setZ(this._shadowSpawnLoc[locNo][i][3]);
            spawnDat.setHeading(this._shadowSpawnLoc[locNo][i][4]);
            this._shadowSpawns.put(keyNpcId, spawnDat);
        }
    }

    public void spawnShadow(int npcId) {
        if (!this.isAttackTime()) {
            return;
        }
        L2Spawn spawnDat = this._shadowSpawns.get(npcId);
        if (spawnDat != null) {
            L2SepulcherMonsterInstance mob = (L2SepulcherMonsterInstance)spawnDat.doSpawn();
            spawnDat.stopRespawn();
            if (mob != null) {
                mob.mysteriousBoxId = npcId;
                this._allMobs.add(mob);
            }
        }
    }

    public void deleteAllMobs() {
        for (L2Npc mob : this._allMobs) {
            try {
                if (mob.getSpawn() != null) {
                    mob.getSpawn().stopRespawn();
                }
                mob.deleteMe();
            }
            catch (Exception ex) {
                LOG.warn("Failed deleting mob!", ex);
            }
        }
        this._allMobs.clear();
    }

    protected void closeAllDoors() {
        for (int doorId : this._hallGateKeepers.values()) {
            try {
                L2DoorInstance door = DoorData.getInstance().getDoor(doorId);
                if (door != null) {
                    door.closeMe();
                    continue;
                }
                LOG.warn("Attempted to close undefined door Id {}!", (Object)doorId);
            }
            catch (Exception ex) {
                LOG.warn("Failed closing door Id {}!", (Object)doorId, (Object)ex);
            }
        }
    }

    protected byte minuteSelect(byte min) {
        if ((double)min % 5.0 != 0.0) {
            switch (min) {
                case 6: 
                case 7: {
                    min = (byte)5;
                    break;
                }
                case 8: 
                case 9: 
                case 11: 
                case 12: {
                    min = (byte)10;
                    break;
                }
                case 13: 
                case 14: 
                case 16: 
                case 17: {
                    min = (byte)15;
                    break;
                }
                case 18: 
                case 19: 
                case 21: 
                case 22: {
                    min = (byte)20;
                    break;
                }
                case 23: 
                case 24: 
                case 26: 
                case 27: {
                    min = (byte)25;
                    break;
                }
                case 28: 
                case 29: 
                case 31: 
                case 32: {
                    min = (byte)30;
                    break;
                }
                case 33: 
                case 34: 
                case 36: 
                case 37: {
                    min = (byte)35;
                    break;
                }
                case 38: 
                case 39: 
                case 41: 
                case 42: {
                    min = (byte)40;
                    break;
                }
                case 43: 
                case 44: 
                case 46: 
                case 47: {
                    min = (byte)45;
                    break;
                }
                case 48: 
                case 49: 
                case 51: 
                case 52: {
                    min = (byte)50;
                    break;
                }
                case 53: 
                case 54: 
                case 56: 
                case 57: {
                    min = (byte)55;
                }
            }
        }
        return min;
    }

    public void managerSay(byte min) {
        block9: {
            block8: {
                if (!this._inAttackTime) break block8;
                if (min < 5) {
                    return;
                }
                min = this.minuteSelect(min);
                NpcStringId msg = NpcStringId.MINUTES_HAVE_PASSED;
                if (min == 90) {
                    msg = NpcStringId.GAME_OVER_THE_TELEPORT_WILL_APPEAR_MOMENTARILY;
                }
                for (L2Spawn temp : this._managers) {
                    if (temp == null) {
                        LOG.warn("Manager is null on attack time!");
                        continue;
                    }
                    if (!(temp.getLastSpawn() instanceof L2SepulcherNpcInstance)) {
                        LOG.warn("Manager is not Sepulcher instance on attack time!");
                        continue;
                    }
                    if (!this._hallInUse.get(temp.getId()).booleanValue()) continue;
                    ((L2SepulcherNpcInstance)temp.getLastSpawn()).sayInShout(msg);
                }
                break block9;
            }
            if (!this._inEntryTime) break block9;
            NpcStringId msg1 = NpcStringId.YOU_MAY_NOW_ENTER_THE_SEPULCHER;
            NpcStringId msg2 = NpcStringId.IF_YOU_PLACE_YOUR_HAND_ON_THE_STONE_STATUE_IN_FRONT_OF_EACH_SEPULCHER_YOU_WILL_BE_ABLE_TO_ENTER;
            for (L2Spawn temp : this._managers) {
                if (temp == null) {
                    LOG.warn("Manager is null on entry time!");
                    continue;
                }
                if (!(temp.getLastSpawn() instanceof L2SepulcherNpcInstance)) {
                    LOG.warn("Manager is not Sepulcher instance on entry time!");
                    continue;
                }
                ((L2SepulcherNpcInstance)temp.getLastSpawn()).sayInShout(msg1);
                ((L2SepulcherNpcInstance)temp.getLastSpawn()).sayInShout(msg2);
            }
        }
    }

    public Map<Integer, Integer> getHallGateKeepers() {
        return this._hallGateKeepers;
    }

    public void showHtmlFile(L2PcInstance player, String file, L2Npc npc, L2PcInstance member) {
        NpcHtmlMessage html = new NpcHtmlMessage(npc.getObjectId());
        html.setFile(player.getHtmlPrefix(), "data/html/SepulcherNpc/" + file);
        if (member != null) {
            html.replace("%member%", member.getName());
        }
        player.sendPacket(html);
    }

    public static FourSepulchersManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final FourSepulchersManager _instance = new FourSepulchersManager();

        private SingletonHolder() {
        }
    }
}

