/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.instancemanager.GlobalVariablesManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.instancemanager.tasks.UpdateSoDStateTask;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.quest.Quest;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraciaSeedsManager {
    private static final Logger LOG = LoggerFactory.getLogger(GraciaSeedsManager.class);
    private static final String ENERGY_SEEDS = "EnergySeeds";
    private static final String SOD_DEFENCE = "Defence";
    private static final byte SOITYPE = 2;
    private static final byte SOATYPE = 3;
    private static final int EDRIC = 32527;
    private static final Location EDRIC_SPAWN_LOCATION = new Location(-248525, 250048, 4307, 24576);
    private static final byte SODTYPE = 1;
    private L2Npc edricSpawn = null;
    private int _SoDTiatKilled = 0;
    private int _SoDState = 1;
    private final Calendar _SoDLastStateChangeDate = Calendar.getInstance();

    private GraciaSeedsManager() {
        this.loadData();
        this.handleSodStages();
    }

    private void saveData(byte seedType) {
        switch (seedType) {
            case 1: {
                GlobalVariablesManager.getInstance().set("SoDState", this._SoDState);
                GlobalVariablesManager.getInstance().set("SoDTiatKilled", this._SoDTiatKilled);
                GlobalVariablesManager.getInstance().set("SoDLSCDate", this._SoDLastStateChangeDate.getTimeInMillis());
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                LOG.warn("Unknown SeedType in SaveData: {}", (Object)seedType);
            }
        }
    }

    private void loadData() {
        if (GlobalVariablesManager.getInstance().hasVariable("SoDState")) {
            this._SoDState = GlobalVariablesManager.getInstance().getInt("SoDState");
            this._SoDTiatKilled = GlobalVariablesManager.getInstance().getInt("SoDTiatKilled", this._SoDTiatKilled);
            this._SoDLastStateChangeDate.setTimeInMillis(GlobalVariablesManager.getInstance().getLong("SoDLSCDate"));
        } else {
            this.saveData((byte)1);
        }
    }

    private void handleSodStages() {
        switch (this._SoDState) {
            case 1: {
                this.despawnSoDRemnantManager();
                break;
            }
            case 2: {
                long timePast = System.currentTimeMillis() - this._SoDLastStateChangeDate.getTimeInMillis();
                if (timePast >= Configuration.graciaSeeds().getStage2Length()) {
                    this.setSoDState(5, true, false);
                } else {
                    ThreadPoolManager.getInstance().scheduleEffect(new UpdateSoDStateTask(), Configuration.graciaSeeds().getStage2Length() - timePast);
                }
                this.spawnSoDRemnantManager();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.spawnSoDRemnantManager();
                break;
            }
            default: {
                LOG.warn("Unknown Seed of Destruction state({})! ", (Object)this._SoDState);
            }
        }
    }

    private void updateSoDDefence(int state) {
        if (state >= 3 && state <= 5) {
            Quest quest = QuestManager.getInstance().getQuest(SOD_DEFENCE);
            if (quest == null) {
                LOG.warn(": missing Defence Quest!");
            } else {
                quest.notifyEvent("start", null, null);
            }
        } else {
            LOG.warn("Invalid Seed of Destruction defence state({}), should be 3, 4 or 5", (Object)state);
        }
    }

    private void stopSoDInvasion() {
        Quest defQuest = QuestManager.getInstance().getQuest(SOD_DEFENCE);
        if (defQuest == null) {
            LOG.warn("Missing Defence Quest!");
        } else {
            defQuest.notifyEvent("stop", null, null);
        }
    }

    public void updateSodState() {
        Quest esQuest = QuestManager.getInstance().getQuest(ENERGY_SEEDS);
        if (esQuest == null) {
            LOG.warn("Missing EnergySeeds Quest!");
        } else {
            esQuest.notifyEvent("StopSoDAi", null, null);
            this.stopSoDInvasion();
        }
    }

    public void increaseSoDTiatKilled() {
        if (this._SoDState == 1) {
            ++this._SoDTiatKilled;
            if (this._SoDTiatKilled >= Configuration.graciaSeeds().getTiatKillCountForNextState()) {
                this.setSoDState(2, false, true);
            }
            this.saveData((byte)1);
        }
    }

    private void setSoDOpenState() {
        Quest esQuest = QuestManager.getInstance().getQuest(ENERGY_SEEDS);
        if (esQuest == null) {
            LOG.warn(this.getClass().getSimpleName() + ": missing EnergySeeds Quest!");
        } else {
            esQuest.notifyEvent("StartSoDAi", null, null);
            this.stopSoDInvasion();
        }
    }

    private void spawnSoDRemnantManager() {
        try {
            if (this.edricSpawn == null || this.edricSpawn.isDecayed()) {
                L2Spawn spawn = new L2Spawn(32527);
                spawn.setInstanceId(0);
                spawn.setLocation(EDRIC_SPAWN_LOCATION);
                spawn.stopRespawn();
                this.edricSpawn = spawn.spawnOne(false);
            }
        }
        catch (Exception e) {
            LOG.warn("Could not spawn NPC Edric #32527; error: {}", (Object)e.getMessage());
        }
    }

    private void despawnSoDRemnantManager() {
        if (this.edricSpawn != null) {
            this.edricSpawn.deleteMe();
        }
    }

    public int getSoDTiatKilled() {
        return this._SoDTiatKilled;
    }

    public void setSoDState(int value, boolean doSave, boolean updateDate) {
        LOG.info("New Seed of Destruction state -> {}.", (Object)value);
        if (updateDate) {
            this._SoDLastStateChangeDate.setTimeInMillis(System.currentTimeMillis());
        }
        this._SoDState = value;
        if (this._SoDState == 1) {
            this._SoDTiatKilled = 0;
            this.updateSodState();
        } else if (this._SoDState == 2) {
            this.setSoDOpenState();
        } else if (this._SoDState > 2) {
            this.updateSoDDefence(this._SoDState);
        }
        this.handleSodStages();
        if (doSave) {
            this.saveData((byte)1);
        }
    }

    public long getSoDTimeForNextStateChange() {
        return switch (this._SoDState) {
            case 2 -> this._SoDLastStateChangeDate.getTimeInMillis() + Configuration.graciaSeeds().getStage2Length() - System.currentTimeMillis();
            default -> -1L;
        };
    }

    public Calendar getSoDLastStateChangeDate() {
        return this._SoDLastStateChangeDate;
    }

    public int getSoDState() {
        return this._SoDState;
    }

    public static GraciaSeedsManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final GraciaSeedsManager _instance = new GraciaSeedsManager();

        private SingletonHolder() {
        }
    }
}

