/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.instancezone.InstanceWorld;
import com.l2jserver.gameserver.util.IXmlReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class InstanceManager
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceManager.class);
    private static final Map<Integer, Instance> INSTANCES = new ConcurrentHashMap<Integer, Instance>();
    private final Map<Integer, InstanceWorld> _instanceWorlds = new ConcurrentHashMap<Integer, InstanceWorld>();
    private int _dynamic = 300000;
    private static final Map<Integer, String> _instanceIdNames = new HashMap<Integer, String>();
    private final Map<Integer, Map<Integer, Long>> _playerInstanceTimes = new ConcurrentHashMap<Integer, Map<Integer, Long>>();
    private static final String ADD_INSTANCE_TIME = "INSERT INTO character_instance_time (charId,instanceId,time) values (?,?,?) ON DUPLICATE KEY UPDATE time=?";
    private static final String RESTORE_INSTANCE_TIMES = "SELECT instanceId,time FROM character_instance_time WHERE charId=?";
    private static final String DELETE_INSTANCE_TIME = "DELETE FROM character_instance_time WHERE charId=? AND instanceId=?";

    protected InstanceManager() {
        INSTANCES.put(-1, new Instance(-1, "multiverse"));
        LOG.info("Multiverse Instance created.");
        INSTANCES.put(0, new Instance(0, "universe"));
        LOG.info("Universe Instance created.");
        this.load();
    }

    @Override
    public void load() {
        _instanceIdNames.clear();
        this.parseDatapackFile("data/instancenames.xml");
        LOG.info("Loaded {} instance names.", (Object)_instanceIdNames.size());
    }

    public long getInstanceTime(int playerObjId, int id) {
        if (!this._playerInstanceTimes.containsKey(playerObjId)) {
            this.restoreInstanceTimes(playerObjId);
        }
        if (this._playerInstanceTimes.get(playerObjId).containsKey(id)) {
            return this._playerInstanceTimes.get(playerObjId).get(id);
        }
        return -1L;
    }

    public Map<Integer, Long> getAllInstanceTimes(int playerObjId) {
        if (!this._playerInstanceTimes.containsKey(playerObjId)) {
            this.restoreInstanceTimes(playerObjId);
        }
        return this._playerInstanceTimes.get(playerObjId);
    }

    public void setInstanceTime(int playerObjId, int id, long time) {
        if (!this._playerInstanceTimes.containsKey(playerObjId)) {
            this.restoreInstanceTimes(playerObjId);
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(ADD_INSTANCE_TIME);){
            ps.setInt(1, playerObjId);
            ps.setInt(2, id);
            ps.setLong(3, time);
            ps.setLong(4, time);
            ps.execute();
            this._playerInstanceTimes.get(playerObjId).put(id, time);
        }
        catch (Exception ex) {
            LOG.warn("Could not insert character instance time data!", ex);
        }
    }

    public void deleteInstanceTime(int playerObjId, int id) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE_INSTANCE_TIME);){
            ps.setInt(1, playerObjId);
            ps.setInt(2, id);
            ps.execute();
            this._playerInstanceTimes.get(playerObjId).remove(id);
        }
        catch (Exception ex) {
            LOG.warn("Could not delete character instance time data!", ex);
        }
    }

    public void restoreInstanceTimes(int playerObjId) {
        if (this._playerInstanceTimes.containsKey(playerObjId)) {
            return;
        }
        this._playerInstanceTimes.put(playerObjId, new ConcurrentHashMap());
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(RESTORE_INSTANCE_TIMES);){
            ps.setInt(1, playerObjId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int id = rs.getInt("instanceId");
                    long time = rs.getLong("time");
                    if (time < System.currentTimeMillis()) {
                        this.deleteInstanceTime(playerObjId, id);
                        continue;
                    }
                    this._playerInstanceTimes.get(playerObjId).put(id, time);
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not delete character instance time data!", ex);
        }
    }

    public String getInstanceIdName(int id) {
        if (_instanceIdNames.containsKey(id)) {
            return _instanceIdNames.get(id);
        }
        return "UnknownInstance";
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equals(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"instance".equals(d.getNodeName())) continue;
                NamedNodeMap attrs = d.getAttributes();
                _instanceIdNames.put(this.parseInteger(attrs, "id"), attrs.getNamedItem("name").getNodeValue());
            }
        }
    }

    public void addWorld(InstanceWorld world) {
        this._instanceWorlds.put(world.getInstanceId(), world);
    }

    public InstanceWorld getWorld(int instanceId) {
        return this._instanceWorlds.get(instanceId);
    }

    public InstanceWorld getPlayerWorld(L2PcInstance player) {
        for (InstanceWorld temp : this._instanceWorlds.values()) {
            if (temp == null || !temp.isAllowed(player.getObjectId())) continue;
            return temp;
        }
        return null;
    }

    public void destroyInstance(int instanceid) {
        if (instanceid <= 0) {
            return;
        }
        Instance temp = INSTANCES.get(instanceid);
        if (temp != null) {
            temp.removeNpcs();
            temp.removePlayers();
            temp.removeDoors();
            temp.cancelTimer();
            INSTANCES.remove(instanceid);
            this._instanceWorlds.remove(instanceid);
        }
    }

    public Instance getInstance(int instanceid) {
        return INSTANCES.get(instanceid);
    }

    public Map<Integer, Instance> getInstances() {
        return INSTANCES;
    }

    public int getPlayerInstance(int objectId) {
        for (Instance temp : INSTANCES.values()) {
            if (temp == null || !temp.containsPlayer(objectId)) continue;
            return temp.getId();
        }
        return 0;
    }

    public boolean createInstance(int id) {
        if (this.getInstance(id) != null) {
            return false;
        }
        Instance instance = new Instance(id);
        INSTANCES.put(id, instance);
        return true;
    }

    public boolean createInstanceFromTemplate(int id, String template) {
        if (this.getInstance(id) != null) {
            return false;
        }
        Instance instance = new Instance(id);
        INSTANCES.put(id, instance);
        instance.loadInstanceTemplate(template);
        return true;
    }

    public int createDynamicInstance(String template) {
        while (this.getInstance(this._dynamic) != null) {
            ++this._dynamic;
            if (this._dynamic != Integer.MAX_VALUE) continue;
            LOG.warn("More then {} instances has been created!", (Object)2147183647);
            this._dynamic = 300000;
        }
        Instance instance = new Instance(this._dynamic);
        INSTANCES.put(this._dynamic, instance);
        if (template != null) {
            instance.loadInstanceTemplate(template);
        }
        return this._dynamic;
    }

    public static InstanceManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final InstanceManager _instance = new InstanceManager();

        private SingletonHolder() {
        }
    }
}

