/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.ItemsAutoDestroy;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ItemsOnGroundManager
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ItemsOnGroundManager.class);
    private final List<L2ItemInstance> _items = new CopyOnWriteArrayList<L2ItemInstance>();

    private ItemsOnGroundManager() {
        if (Configuration.general().getSaveDroppedItemInterval() > 0L) {
            ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(this, Configuration.general().getSaveDroppedItemInterval(), Configuration.general().getSaveDroppedItemInterval());
        }
        this.load();
    }

    private void load() {
        if (!Configuration.general().saveDroppedItem() && Configuration.general().clearDroppedItemTable()) {
            this.emptyTable();
        }
        if (!Configuration.general().saveDroppedItem()) {
            return;
        }
        if (Configuration.general().destroyPlayerDroppedItem()) {
            String str = !Configuration.general().destroyEquipableItem() ? "UPDATE itemsonground SET drop_time = ? WHERE drop_time = -1 AND equipable = 0" : "UPDATE itemsonground SET drop_time = ? WHERE drop_time = -1";
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement ps = con.prepareStatement(str);){
                ps.setLong(1, System.currentTimeMillis());
                ps.execute();
            }
            catch (Exception e) {
                LOG.error("Error while updating table ItemsOnGround: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT object_id,item_id,count,enchant_level,x,y,z,drop_time,equipable FROM itemsonground");){
            int count = 0;
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    L2ItemInstance item = new L2ItemInstance(rs.getInt(1), rs.getInt(2));
                    L2World.getInstance().storeObject(item);
                    if (item.isStackable() && rs.getInt(3) > 1) {
                        item.setCount(rs.getInt(3));
                    }
                    if (rs.getInt(4) > 0) {
                        item.setEnchantLevel(rs.getInt(4));
                    }
                    item.setXYZ(rs.getInt(5), rs.getInt(6), rs.getInt(7));
                    item.setWorldRegion(L2World.getInstance().getRegion(item.getLocation()));
                    item.getWorldRegion().addVisibleObject(item);
                    long dropTime = rs.getLong(8);
                    item.setDropTime(dropTime);
                    item.setProtected(dropTime == -1L);
                    item.setIsVisible(true);
                    L2World.getInstance().addVisibleObject(item, item.getWorldRegion());
                    this._items.add(item);
                    ++count;
                    if (Configuration.general().getProtectedItems().contains(item.getId()) || dropTime <= -1L || (Configuration.general().getAutoDestroyDroppedItemAfter() <= 0 || item.getItem().hasExImmediateEffect()) && (Configuration.general().getAutoDestroyHerbTime() <= 0L || !item.getItem().hasExImmediateEffect())) continue;
                    ItemsAutoDestroy.getInstance().addItem(item);
                }
            }
            LOG.info("Loaded {} items.", (Object)count);
        }
        catch (Exception e) {
            LOG.error("Error while loading ItemsOnGround: {}", (Object)e.getMessage(), (Object)e);
        }
        if (Configuration.general().emptyDroppedItemTableAfterLoad()) {
            this.emptyTable();
        }
    }

    public void save(L2ItemInstance item) {
        if (!Configuration.general().saveDroppedItem()) {
            return;
        }
        this._items.add(item);
    }

    public void removeObject(L2ItemInstance item) {
        if (Configuration.general().saveDroppedItem()) {
            this._items.remove(item);
        }
    }

    public void saveInDb() {
        this.run();
    }

    public void cleanUp() {
        this._items.clear();
    }

    private void emptyTable() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();){
            s.executeUpdate("DELETE FROM itemsonground");
        }
        catch (Exception e1) {
            LOG.error("Error while cleaning table ItemsOnGround: {}", (Object)e1.getMessage(), (Object)e1);
        }
    }

    @Override
    public synchronized void run() {
        if (!Configuration.general().saveDroppedItem()) {
            return;
        }
        this.emptyTable();
        if (this._items.isEmpty()) {
            return;
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("INSERT INTO itemsonground(object_id,item_id,count,enchant_level,x,y,z,drop_time,equipable) VALUES(?,?,?,?,?,?,?,?,?)");){
            for (L2ItemInstance item : this._items) {
                if (item == null || CursedWeaponsManager.getInstance().isCursed(item.getId())) continue;
                try {
                    ps.setInt(1, item.getObjectId());
                    ps.setInt(2, item.getId());
                    ps.setLong(3, item.getCount());
                    ps.setInt(4, item.getEnchantLevel());
                    ps.setInt(5, item.getX());
                    ps.setInt(6, item.getY());
                    ps.setInt(7, item.getZ());
                    ps.setLong(8, item.isProtected() ? -1L : item.getDropTime());
                    ps.setLong(9, item.isEquipable() ? 1 : 0);
                    ps.execute();
                    ps.clearParameters();
                }
                catch (Exception e) {
                    LOG.error("Error while inserting into table ItemsOnGround: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            LOG.error("SQL error while storing items on ground: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static ItemsOnGroundManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final ItemsOnGroundManager _instance = new ItemsOnGroundManager();

        private SingletonHolder() {
        }
    }
}

