/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public class CombatFlag {
    private L2PcInstance _player = null;
    private int _playerId = 0;
    private L2ItemInstance _item = null;
    private L2ItemInstance _itemInstance;
    private final Location _location;
    private final int _itemId;

    public CombatFlag(int fortId, int x, int y, int z, int heading, int item_id) {
        this._location = new Location(x, y, z, heading);
        this._itemId = item_id;
    }

    public synchronized void spawnMe() {
        this._itemInstance = ItemTable.getInstance().createItem("Combat", this._itemId, 1L, null, null);
        this._itemInstance.dropMe(null, this._location.getX(), this._location.getY(), this._location.getZ());
    }

    public synchronized void unSpawnMe() {
        if (this._player != null) {
            this.dropIt();
        }
        if (this._itemInstance != null) {
            this._itemInstance.decayMe();
        }
    }

    public boolean activate(L2PcInstance player, L2ItemInstance item) {
        if (player.isMounted()) {
            player.sendPacket(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
            return false;
        }
        this._player = player;
        this._playerId = this._player.getObjectId();
        this._itemInstance = null;
        this._item = item;
        this._player.getInventory().equipItem(this._item);
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_EQUIPPED);
        sm.addItemName(this._item);
        this._player.sendPacket(sm);
        if (!Configuration.general().forceInventoryUpdate()) {
            InventoryUpdate iu = new InventoryUpdate();
            iu.addItem(this._item);
            this._player.sendPacket(iu);
        } else {
            this._player.sendPacket(new ItemList(this._player, false));
        }
        this._player.broadcastUserInfo();
        this._player.setCombatFlagEquipped(true);
        return true;
    }

    public void dropIt() {
        this._player.setCombatFlagEquipped(false);
        int slot = this._player.getInventory().getSlotFromItem(this._item);
        this._player.getInventory().unEquipItemInBodySlot(slot);
        this._player.destroyItem("CombatFlag", this._item, null, true);
        this._item = null;
        this._player.broadcastUserInfo();
        this._player = null;
        this._playerId = 0;
    }

    public int getPlayerObjectId() {
        return this._playerId;
    }

    public L2ItemInstance getCombatFlagInstance() {
        return this._itemInstance;
    }
}

