/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.model.Location;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2Territory {
    private static final Logger LOG = LoggerFactory.getLogger(L2Territory.class);
    private final List<Point> _points = new CopyOnWriteArrayList<Point>();
    private final int _terr;
    private int _xMin;
    private int _xMax;
    private int _yMin;
    private int _yMax;
    private int _zMin;
    private int _zMax;
    private int _procMax;

    public L2Territory(int terr) {
        this._terr = terr;
        this._xMin = 999999;
        this._xMax = -999999;
        this._yMin = 999999;
        this._yMax = -999999;
        this._zMin = 999999;
        this._zMax = -999999;
        this._procMax = 0;
    }

    public void add(int x, int y, int zmin, int zmax, int proc) {
        this._points.add(new Point(x, y, zmin, zmax, proc));
        if (x < this._xMin) {
            this._xMin = x;
        }
        if (y < this._yMin) {
            this._yMin = y;
        }
        if (x > this._xMax) {
            this._xMax = x;
        }
        if (y > this._yMax) {
            this._yMax = y;
        }
        if (zmin < this._zMin) {
            this._zMin = zmin;
        }
        if (zmax > this._zMax) {
            this._zMax = zmax;
        }
        this._procMax += proc;
    }

    public boolean isIntersect(int x, int y, Point p1, Point p2) {
        double dy1 = p1._y - y;
        double dy2 = p2._y - y;
        if (Math.abs(Math.signum(dy1) - Math.signum(dy2)) <= 1.0E-6) {
            return false;
        }
        double dx1 = p1._x - x;
        double dx2 = p2._x - x;
        if (dx1 >= 0.0 && dx2 >= 0.0) {
            return true;
        }
        if (dx1 < 0.0 && dx2 < 0.0) {
            return false;
        }
        double dx0 = dy1 * (double)(p1._x - p2._x) / (double)(p1._y - p2._y);
        return dx0 <= dx1;
    }

    public boolean isInside(int x, int y) {
        int intersect_count = 0;
        for (int i = 0; i < this._points.size(); ++i) {
            Point p2;
            Point p1 = this._points.get(i > 0 ? i - 1 : this._points.size() - 1);
            if (!this.isIntersect(x, y, p1, p2 = this._points.get(i))) continue;
            ++intersect_count;
        }
        return intersect_count % 2 == 1;
    }

    public Location getRandomPoint() {
        if (this._procMax > 0) {
            int pos = 0;
            int rnd = Rnd.nextInt((int)this._procMax);
            for (Point p1 : this._points) {
                if (rnd > (pos += p1._proc)) continue;
                return new Location(p1._x, p1._y, Rnd.get((int)p1._zmin, (int)p1._zmax));
            }
        }
        for (int i = 0; i < 100; ++i) {
            int y;
            int x = Rnd.get((int)this._xMin, (int)this._xMax);
            if (!this.isInside(x, y = Rnd.get((int)this._yMin, (int)this._yMax))) continue;
            double curdistance = 0.0;
            int zmin = this._zMin;
            for (Point p1 : this._points) {
                double distance = Math.hypot(p1._x - x, p1._y - y);
                if (curdistance != 0.0 && !(distance < curdistance)) continue;
                curdistance = distance;
                zmin = p1._zmin;
            }
            return new Location(x, y, Rnd.get((int)zmin, (int)this._zMax));
        }
        LOG.warn("Can't make point for territory {}", (Object)this._terr);
        return null;
    }

    public int getProcMax() {
        return this._procMax;
    }

    protected static class Point {
        protected int _x;
        protected int _y;
        protected int _zmin;
        protected int _zmax;
        protected int _proc;

        Point(int x, int y, int zmin, int zmax, int proc) {
            this._x = x;
            this._y = y;
            this._zmin = zmin;
            this._zmax = zmax;
            this._proc = proc;
        }
    }
}

