/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;

public class PartyMatchWaitingList {
    private final Set<L2PcInstance> _members = ConcurrentHashMap.newKeySet(1);

    protected PartyMatchWaitingList() {
    }

    public void addPlayer(L2PcInstance player) {
        this._members.add(player);
    }

    public void removePlayer(L2PcInstance player) {
        this._members.remove(player);
    }

    public Set<L2PcInstance> getPlayers() {
        return this._members;
    }

    public List<L2PcInstance> findPlayers(int minLevel, int maxLevel, Set<Integer> classes, String filter) {
        return this._members.stream().filter(p -> p.getLevel() >= minLevel).filter(p -> p.getLevel() <= maxLevel).filter(p -> classes.isEmpty() || classes.contains(p.getClassId().getId())).filter(p -> Strings.isBlank((String)filter) || p.getName().toLowerCase().contains(filter.toLowerCase())).filter(L2PcInstance::isPartyWaiting).collect(Collectors.toList());
    }

    public static PartyMatchWaitingList getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final PartyMatchWaitingList INSTANCE = new PartyMatchWaitingList();

        private SingletonHolder() {
        }
    }
}

