/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import java.util.concurrent.atomic.AtomicLong;

public class SeedProduction {
    private final int _seedId;
    private final long _price;
    private final long _startAmount;
    private final AtomicLong _amount;

    public SeedProduction(int id, long amount, long price, long startAmount) {
        this._seedId = id;
        this._amount = new AtomicLong(amount);
        this._price = price;
        this._startAmount = startAmount;
    }

    public final int getId() {
        return this._seedId;
    }

    public final long getAmount() {
        return this._amount.get();
    }

    public final long getPrice() {
        return this._price;
    }

    public final long getStartAmount() {
        return this._startAmount;
    }

    public final void setAmount(long amount) {
        this._amount.set(amount);
    }

    public final boolean decreaseAmount(long val) {
        long next;
        long current;
        do {
            if ((next = (current = this._amount.get()) - val) >= 0L) continue;
            return false;
        } while (!this._amount.compareAndSet(current, next));
        return true;
    }
}

