/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2AttackableAI;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.CategoryData;
import com.l2jserver.gameserver.data.xml.impl.DoorData;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.enums.CategoryType;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.enums.Race;
import com.l2jserver.gameserver.enums.ShotType;
import com.l2jserver.gameserver.enums.Team;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.CharEffectList;
import com.l2jserver.gameserver.model.L2AccessLevel;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.TimeStamp;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2RiftInvaderInstance;
import com.l2jserver.gameserver.model.actor.knownlist.CharKnownList;
import com.l2jserver.gameserver.model.actor.stat.CharStat;
import com.l2jserver.gameserver.model.actor.status.CharStatus;
import com.l2jserver.gameserver.model.actor.tasks.character.FlyToLocationTask;
import com.l2jserver.gameserver.model.actor.tasks.character.HitTask;
import com.l2jserver.gameserver.model.actor.tasks.character.MagicUseTask;
import com.l2jserver.gameserver.model.actor.tasks.character.NotifyAITask;
import com.l2jserver.gameserver.model.actor.tasks.character.QueuedMagicUseTask;
import com.l2jserver.gameserver.model.actor.templates.L2CharTemplate;
import com.l2jserver.gameserver.model.actor.transform.Transform;
import com.l2jserver.gameserver.model.actor.transform.TransformTemplate;
import com.l2jserver.gameserver.model.effects.EffectFlag;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.events.Containers;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.EventType;
import com.l2jserver.gameserver.model.events.impl.character.CreatureAttack;
import com.l2jserver.gameserver.model.events.impl.character.CreatureAttackAvoid;
import com.l2jserver.gameserver.model.events.impl.character.CreatureAttacked;
import com.l2jserver.gameserver.model.events.impl.character.CreatureDamageDealt;
import com.l2jserver.gameserver.model.events.impl.character.CreatureDamageReceived;
import com.l2jserver.gameserver.model.events.impl.character.CreatureKill;
import com.l2jserver.gameserver.model.events.impl.character.CreatureSkillUse;
import com.l2jserver.gameserver.model.events.impl.character.CreatureTeleported;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcSkillSee;
import com.l2jserver.gameserver.model.events.listeners.AbstractEventListener;
import com.l2jserver.gameserver.model.events.returns.TerminateReturn;
import com.l2jserver.gameserver.model.holders.InvulSkillHolder;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.holders.SkillUseHolder;
import com.l2jserver.gameserver.model.interfaces.IDeletable;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.interfaces.ISkillsHolder;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.WeaponType;
import com.l2jserver.gameserver.model.options.OptionsSkillHolder;
import com.l2jserver.gameserver.model.options.OptionsSkillType;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.AbnormalVisualEffect;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.CommonSkill;
import com.l2jserver.gameserver.model.skills.EffectScope;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.skills.SkillChannelized;
import com.l2jserver.gameserver.model.skills.SkillChannelizer;
import com.l2jserver.gameserver.model.skills.targets.AffectScope;
import com.l2jserver.gameserver.model.skills.targets.TargetType;
import com.l2jserver.gameserver.model.stats.Calculator;
import com.l2jserver.gameserver.model.stats.Formulas;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.model.stats.functions.AbstractFunction;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.Attack;
import com.l2jserver.gameserver.network.serverpackets.ChangeMoveType;
import com.l2jserver.gameserver.network.serverpackets.ChangeWaitType;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.ExRotation;
import com.l2jserver.gameserver.network.serverpackets.FlyToLocation;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillCanceled;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillLaunched;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.MoveToLocation;
import com.l2jserver.gameserver.network.serverpackets.Revive;
import com.l2jserver.gameserver.network.serverpackets.ServerObjectInfo;
import com.l2jserver.gameserver.network.serverpackets.SetupGauge;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.StopMove;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.TeleportToLocation;
import com.l2jserver.gameserver.pathfinding.AbstractNodeLoc;
import com.l2jserver.gameserver.pathfinding.PathFinding;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import com.l2jserver.gameserver.util.EmptyQueue;
import com.l2jserver.gameserver.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.StampedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class L2Character
extends L2Object
implements ISkillsHolder,
IDeletable {
    private static final Logger LOG = LoggerFactory.getLogger(L2Character.class);
    private volatile Set<L2Character> _attackByList;
    private volatile boolean _isCastingNow = false;
    private volatile boolean _isCastingSimultaneouslyNow = false;
    private Skill _lastSkillCast;
    private Skill _lastSimultaneousSkillCast;
    private boolean _isDead = false;
    private boolean _isImmobilized = false;
    private boolean _isOverloaded = false;
    private boolean _isPendingRevive = false;
    private boolean _isRunning = false;
    private boolean _isNoRndWalk = false;
    protected boolean _showSummonAnimation = false;
    protected boolean _isTeleporting = false;
    private boolean _isInvul = false;
    private boolean _isMortal = true;
    private boolean _isFlying = false;
    private CharStat _stat;
    private CharStatus _status;
    private L2CharTemplate _template;
    private String _title;
    public static final double MAX_HP_BAR_PX = 352.0;
    private double _hpUpdateIncCheck = 0.0;
    private double _hpUpdateDecCheck = 0.0;
    private double _hpUpdateInterval = 0.0;
    private Calculator[] _calculators;
    private final Map<Integer, Skill> _skills = new ConcurrentHashMap<Integer, Skill>();
    private volatile Map<Integer, TimeStamp> _reuseTimeStampsSkills = null;
    private volatile Map<Integer, TimeStamp> _reuseTimeStampsItems = null;
    private volatile Map<Integer, Long> _disabledSkills = null;
    private boolean _allSkillsDisabled;
    private final byte[] _zones = new byte[ZoneId.getZoneCount()];
    protected byte _zoneValidateCounter = (byte)4;
    private L2Character _debugger = null;
    private final ReentrantLock _teleportLock = new ReentrantLock();
    private final StampedLock _attackLock = new StampedLock();
    private Team _team = Team.NONE;
    protected long _exceptions = 0L;
    private boolean _lethalable = true;
    private volatile Map<Integer, OptionsSkillHolder> _triggerSkills;
    private volatile Map<Integer, InvulSkillHolder> _invulAgainst;
    private final CharEffectList _effectList = new CharEffectList(this);
    private L2Character _summoner = null;
    private SkillChannelizer _channelizer = null;
    private SkillChannelized _channelized = null;
    private int _abnormalVisualEffects;
    private int _abnormalVisualEffectsSpecial;
    private int _abnormalVisualEffectsEvent;
    protected MoveData _move;
    private L2Object _target;
    private volatile long _attackEndTime;
    private long _disableBowAttackEndTime;
    private int _castInterruptTime;
    private static final Calculator[] NPC_STD_CALCULATOR = Formulas.getStdNPCCalculators();
    private volatile L2CharacterAI _ai = null;
    protected Future<?> _skillCast;
    protected Future<?> _skillCast2;
    private boolean _AIdisabled = false;

    public L2Character(int objectId, L2CharTemplate template) {
        super(objectId);
        if (template == null) {
            throw new NullPointerException("Template is null!");
        }
        this.setInstanceType(InstanceType.L2Character);
        this.initCharStat();
        this.initCharStatus();
        this._template = template;
        this._calculators = this.isDoor() ? Formulas.getStdDoorCalculators() : (this.isNpc() ? NPC_STD_CALCULATOR : new Calculator[Stats.NUM_STATS]);
        this.setIsInvul(true);
    }

    public final CharEffectList getEffectList() {
        return this._effectList;
    }

    public boolean isDebug() {
        return this._debugger != null;
    }

    public void setDebug(L2Character debugger) {
        this._debugger = debugger;
    }

    public void sendDebugPacket(L2GameServerPacket pkt) {
        if (this._debugger != null) {
            this._debugger.sendPacket(pkt);
        }
    }

    public void sendDebugMessage(String msg) {
        if (this._debugger != null) {
            this._debugger.sendMessage(msg);
        }
    }

    public Inventory getInventory() {
        return null;
    }

    public boolean destroyItemByItemId(String process, int itemId, long count, L2Object reference, boolean sendMessage) {
        return true;
    }

    public boolean destroyItem(String process, int objectId, long count, L2Object reference, boolean sendMessage) {
        return true;
    }

    @Override
    public final boolean isInsideZone(ZoneId zone) {
        Instance instance = InstanceManager.getInstance().getInstance(this.getInstanceId());
        switch (zone) {
            case PVP: {
                if (instance != null && instance.isPvPInstance()) {
                    return true;
                }
                return this._zones[ZoneId.PVP.ordinal()] > 0 && this._zones[ZoneId.PEACE.ordinal()] == 0;
            }
            case PEACE: {
                if (instance == null || !instance.isPvPInstance()) break;
                return false;
            }
        }
        return this._zones[zone.ordinal()] > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInsideZone(ZoneId zone, boolean state) {
        byte[] byArray = this._zones;
        synchronized (this._zones) {
            if (state) {
                int n = zone.ordinal();
                this._zones[n] = (byte)(this._zones[n] + 1);
            } else if (this._zones[zone.ordinal()] > 0) {
                int n = zone.ordinal();
                this._zones[n] = (byte)(this._zones[n] - 1);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public boolean isTransformed() {
        return false;
    }

    public Transform getTransformation() {
        return null;
    }

    public void untransform() {
    }

    public boolean isGM() {
        return false;
    }

    public L2AccessLevel getAccessLevel() {
        return null;
    }

    protected void initCharStatusUpdateValues() {
        this._hpUpdateIncCheck = this.getMaxHp();
        this._hpUpdateInterval = this._hpUpdateIncCheck / 352.0;
        this._hpUpdateDecCheck = this._hpUpdateIncCheck - this._hpUpdateInterval;
    }

    public void onDecay() {
        this.decayMe();
        L2WorldRegion reg = this.getWorldRegion();
        if (reg != null) {
            reg.removeFromZones(this);
        }
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this.revalidateZone(true);
    }

    public void onTeleported() {
        if (!this._teleportLock.tryLock()) {
            return;
        }
        try {
            if (!this.isTeleporting()) {
                return;
            }
            this.spawnMe(this.getX(), this.getY(), this.getZ());
            this.setIsTeleporting(false);
            EventDispatcher.getInstance().notifyEventAsync(new CreatureTeleported(this), this);
        }
        finally {
            this._teleportLock.unlock();
        }
    }

    public void addAttackerToAttackByList(L2Character player) {
    }

    public void broadcastPacket(L2GameServerPacket mov) {
        mov.setInvisible(this.isInvisible());
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null) continue;
            player.sendPacket(mov);
        }
    }

    public void broadcastPacket(L2GameServerPacket mov, int radiusInKnownlist) {
        mov.setInvisible(this.isInvisible());
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null || !this.isInsideRadius(player, radiusInKnownlist, false, false)) continue;
            player.sendPacket(mov);
        }
    }

    protected boolean needHpUpdate() {
        double currentHp = this.getCurrentHp();
        double maxHp = this.getMaxHp();
        if (currentHp <= 1.0 || maxHp < 352.0) {
            return true;
        }
        if (currentHp < this._hpUpdateDecCheck || Math.abs(currentHp - this._hpUpdateDecCheck) <= 1.0E-6 || currentHp > this._hpUpdateIncCheck || Math.abs(currentHp - this._hpUpdateIncCheck) <= 1.0E-6) {
            if (Math.abs(currentHp - maxHp) <= 1.0E-6) {
                this._hpUpdateIncCheck = currentHp + 1.0;
                this._hpUpdateDecCheck = currentHp - this._hpUpdateInterval;
            } else {
                double doubleMulti = currentHp / this._hpUpdateInterval;
                int intMulti = (int)doubleMulti;
                this._hpUpdateDecCheck = this._hpUpdateInterval * (double)(doubleMulti < (double)intMulti ? intMulti-- : intMulti);
                this._hpUpdateIncCheck = this._hpUpdateDecCheck + this._hpUpdateInterval;
            }
            return true;
        }
        return false;
    }

    public void broadcastStatusUpdate() {
        if (this.getStatus().getStatusListener().isEmpty() || !this.needHpUpdate()) {
            return;
        }
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(10, this.getMaxHp());
        su.addAttribute(9, (int)this.getCurrentHp());
        for (L2Character temp : this.getStatus().getStatusListener()) {
            if (temp == null) continue;
            temp.sendPacket(su);
        }
    }

    public void sendMessage(String text) {
    }

    public void teleToLocation(int x, int y, int z, int heading, int instanceId, int randomOffset) {
        this.setInstanceId(instanceId);
        if (this._isPendingRevive) {
            this.doRevive();
        }
        this.stopMove(null, false);
        this.abortAttack();
        this.abortCast();
        this.setIsTeleporting(true);
        this.setTarget(null);
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        if (Configuration.character().offsetOnTeleport() && randomOffset > 0) {
            x += Rnd.get((int)(-randomOffset), (int)randomOffset);
            y += Rnd.get((int)(-randomOffset), (int)randomOffset);
        }
        this.broadcastPacket(new TeleportToLocation(this, x, y, z += 5, heading));
        this.decayMe();
        this.setXYZ(x, y, z);
        if (heading != 0) {
            this.setHeading(heading);
        }
        if (!this.isPlayer() || this.getActingPlayer().getClient() != null && this.getActingPlayer().getClient().isDetached()) {
            this.onTeleported();
        }
        this.revalidateZone(true);
    }

    public void teleToLocation(int x, int y, int z, int heading, int instanceId, boolean randomOffset) {
        this.teleToLocation(x, y, z, heading, instanceId, randomOffset ? Configuration.character().getMaxOffsetOnTeleport() : 0);
    }

    public void teleToLocation(int x, int y, int z, int heading, int instanceId) {
        this.teleToLocation(x, y, z, heading, instanceId, 0);
    }

    public void teleToLocation(int x, int y, int z, int heading, boolean randomOffset) {
        this.teleToLocation(x, y, z, heading, -1, randomOffset ? Configuration.character().getMaxOffsetOnTeleport() : 0);
    }

    public void teleToLocation(int x, int y, int z, int heading) {
        this.teleToLocation(x, y, z, heading, -1, 0);
    }

    public void teleToLocation(int x, int y, int z, boolean randomOffset) {
        this.teleToLocation(x, y, z, 0, -1, randomOffset ? Configuration.character().getMaxOffsetOnTeleport() : 0);
    }

    public void teleToLocation(int x, int y, int z) {
        this.teleToLocation(x, y, z, 0, -1, 0);
    }

    public void teleToLocation(ILocational loc, int randomOffset) {
        this.teleToLocation(loc.getX(), loc.getY(), loc.getZ(), loc.getHeading(), loc.getInstanceId(), randomOffset);
    }

    public void teleToLocation(ILocational loc, int instanceId, int randomOffset) {
        this.teleToLocation(loc.getX(), loc.getY(), loc.getZ(), loc.getHeading(), instanceId, randomOffset);
    }

    public void teleToLocation(ILocational loc, boolean randomOffset) {
        this.teleToLocation(loc.getX(), loc.getY(), loc.getZ(), loc.getHeading(), loc.getInstanceId(), randomOffset ? Configuration.character().getMaxOffsetOnTeleport() : 0);
    }

    public void teleToLocation(ILocational loc) {
        this.teleToLocation(loc.getX(), loc.getY(), loc.getZ(), loc.getHeading(), loc.getInstanceId(), 0);
    }

    public void teleToLocation(TeleportWhereType teleportWhere) {
        this.teleToLocation((ILocational)MapRegionManager.getInstance().getTeleToLocation(this, teleportWhere), true);
    }

    private boolean canUseRangeWeapon() {
        if (this.isTransformed()) {
            return true;
        }
        L2Weapon weaponItem = this.getActiveWeaponItem();
        long betweenRangedAttack = this._disableBowAttackEndTime - System.currentTimeMillis();
        if (this.isPlayer()) {
            if (weaponItem == null || !weaponItem.isRange()) {
                return false;
            }
            if (!this.checkAndEquipArrows()) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(weaponItem.isBow() ? SystemMessageId.NOT_ENOUGH_ARROWS : SystemMessageId.NOT_ENOUGH_BOLTS);
                return false;
            }
            if (betweenRangedAttack > 0L) {
                ThreadPoolManager.getInstance().scheduleAi(new NotifyAITask(this, CtrlEvent.EVT_READY_TO_ACT), betweenRangedAttack);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            int mpConsume = weaponItem.getMpConsume();
            if (weaponItem.getReducedMpConsume() > 0 && Rnd.get((int)100) < weaponItem.getReducedMpConsumeChance()) {
                mpConsume = weaponItem.getReducedMpConsume();
            }
            mpConsume = (int)this.calcStat(Stats.BOW_MP_CONSUME_RATE, mpConsume, null, null);
            if (this.getCurrentMp() < (double)mpConsume) {
                ThreadPoolManager.getInstance().scheduleAi(new NotifyAITask(this, CtrlEvent.EVT_READY_TO_ACT), 100L);
                this.sendPacket(SystemMessageId.NOT_ENOUGH_MP);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (mpConsume > 0) {
                this.getStatus().reduceMp(mpConsume);
            }
        } else if (this.isNpc() && betweenRangedAttack > 0L) {
            ThreadPoolManager.getInstance().scheduleAi(new NotifyAITask(this, CtrlEvent.EVT_READY_TO_ACT), betweenRangedAttack);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAttack(L2Character target) {
        long stamp = this._attackLock.tryWriteLock();
        if (stamp == 0L) {
            return;
        }
        try {
            boolean hitted;
            L2Weapon wpn;
            if (target == null || this.isAttackingDisabled()) {
                return;
            }
            TerminateReturn attackReturn = EventDispatcher.getInstance().notifyEvent(new CreatureAttack(this, target), this, TerminateReturn.class);
            if (attackReturn != null && attackReturn.terminate()) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            TerminateReturn attackedReturn = EventDispatcher.getInstance().notifyEvent(new CreatureAttacked(this, target), target, TerminateReturn.class);
            if (attackedReturn != null && attackedReturn.terminate()) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (!this.isAlikeDead()) {
                if (this.isNpc() && target.isAlikeDead() || !this.getKnownList().knowsObject(target)) {
                    this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
                if (this.isPlayer()) {
                    if (target.isDead()) {
                        this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                        this.sendPacket(ActionFailed.STATIC_PACKET);
                        return;
                    }
                    L2PcInstance actor = this.getActingPlayer();
                    if (actor.isTransformed() && !actor.getTransformation().canAttack()) {
                        this.sendPacket(ActionFailed.STATIC_PACKET);
                        return;
                    }
                }
            }
            if (this.getActiveWeaponItem() != null && !(wpn = this.getActiveWeaponItem()).isAttackWeapon() && !this.isGM()) {
                if (wpn.getItemType() == WeaponType.FISHINGROD) {
                    this.sendPacket(SystemMessageId.CANNOT_ATTACK_WITH_FISHING_POLE);
                } else {
                    this.sendPacket(SystemMessageId.THAT_WEAPON_CANT_ATTACK);
                }
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (this.getActingPlayer() != null) {
                if (this.getActingPlayer().inObserverMode()) {
                    this.sendPacket(SystemMessageId.OBSERVERS_CANNOT_PARTICIPATE);
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
                if (target.getActingPlayer() != null && this.getActingPlayer().getSiegeState() > 0 && this.isInsideZone(ZoneId.SIEGE) && target.getActingPlayer().getSiegeState() == this.getActingPlayer().getSiegeState() && target.getActingPlayer() != this && target.getActingPlayer().getSiegeSide() == this.getActingPlayer().getSiegeSide()) {
                    if (TerritoryWarManager.getInstance().isTWInProgress()) {
                        this.sendPacket(SystemMessageId.YOU_CANNOT_ATTACK_A_MEMBER_OF_THE_SAME_TERRITORY);
                    } else {
                        this.sendPacket(SystemMessageId.FORCED_ATTACK_IS_IMPOSSIBLE_AGAINST_SIEGE_SIDE_TEMPORARY_ALLIED_MEMBERS);
                    }
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
                if (target.isInsidePeaceZone(this.getActingPlayer())) {
                    this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
            } else if (this.isInsidePeaceZone(this, (L2Object)target)) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            this.stopEffectsOnAction();
            if (!GeoData.getInstance().canSeeTarget((L2Object)this, target)) {
                this.sendPacket(SystemMessageId.CANT_SEE_TARGET);
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            target.getKnownList().addKnownObject(this);
            L2Weapon weaponItem = this.getActiveWeaponItem();
            int timeAtk = this.calculateTimeBetweenAttacks();
            int timeToHit = timeAtk / 2;
            Attack attack = new Attack(this, target, this.isChargedShot(ShotType.SOULSHOTS), weaponItem != null ? weaponItem.getItemGradeSPlus().getId() : 0);
            this.setHeading(Util.calculateHeadingFrom(this, target));
            int reuse = this.calculateReuseTime(weaponItem);
            if (this.isNpc()) {
                if (weaponItem == null) {
                    reuse = timeAtk;
                }
                reuse += this.getTemplate().getBaseReuseDelay();
            }
            switch (this.getAttackType()) {
                case BOW: {
                    if (!this.canUseRangeWeapon()) {
                        return;
                    }
                    this._attackEndTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeAtk, TimeUnit.MILLISECONDS);
                    hitted = this.doAttackHitByBow(attack, target, timeAtk, reuse);
                    break;
                }
                case CROSSBOW: {
                    if (!this.canUseRangeWeapon()) {
                        return;
                    }
                    this._attackEndTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeAtk, TimeUnit.MILLISECONDS);
                    hitted = this.doAttackHitByCrossBow(attack, target, timeAtk, reuse);
                    break;
                }
                case POLE: {
                    this._attackEndTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeAtk, TimeUnit.MILLISECONDS);
                    hitted = this.doAttackHitByPole(attack, target, timeToHit);
                    break;
                }
                case FIST: {
                    if (!this.isPlayer()) {
                        this._attackEndTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeAtk, TimeUnit.MILLISECONDS);
                        hitted = this.doAttackHitSimple(attack, target, timeToHit);
                        break;
                    }
                }
                case DUAL: 
                case DUALFIST: 
                case DUALDAGGER: {
                    this._attackEndTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeAtk, TimeUnit.MILLISECONDS);
                    hitted = this.doAttackHitByDual(attack, target, timeToHit);
                    break;
                }
                default: {
                    this._attackEndTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeAtk, TimeUnit.MILLISECONDS);
                    hitted = this.doAttackHitSimple(attack, target, timeToHit);
                }
            }
            L2PcInstance player = this.getActingPlayer();
            if (player != null) {
                AttackStanceTaskManager.getInstance().addAttackStanceTask(player);
                if (player.getSummon() != target) {
                    player.updatePvPStatus(target);
                }
            }
            if (!hitted) {
                this.abortAttack();
            } else {
                this.setChargedShot(ShotType.SOULSHOTS, false);
                if (player != null) {
                    if (player.isCursedWeaponEquipped()) {
                        if (!target.isInvul()) {
                            target.setCurrentCp(0.0);
                        }
                    } else if (player.isHero() && target.isPlayer() && target.getActingPlayer().isCursedWeaponEquipped()) {
                        target.setCurrentCp(0.0);
                    }
                }
            }
            if (attack.hasHits()) {
                this.broadcastPacket(attack);
            }
            ThreadPoolManager.getInstance().scheduleAi(new NotifyAITask(this, CtrlEvent.EVT_READY_TO_ACT), timeAtk);
        }
        finally {
            this._attackLock.unlockWrite(stamp);
        }
    }

    private boolean doAttackHitByBow(Attack attack, L2Character target, int sAtk, int reuse) {
        int damage1 = 0;
        byte shld1 = 0;
        boolean crit1 = false;
        boolean miss1 = Formulas.calcHitMiss(this, target);
        this.reduceArrowCount(false);
        this._move = null;
        if (!miss1) {
            shld1 = Formulas.calcShldUse(this, target);
            crit1 = Formulas.calcCrit(this, target);
            damage1 = (int)Formulas.calcPhysDam(this, target, shld1, crit1, attack.hasSoulshot());
            damage1 = (int)((double)damage1 * (this.calculateDistance(target, true, false) / 4000.0 + 0.8));
        }
        if (this.isPlayer()) {
            this.sendPacket(new SetupGauge(1, sAtk + reuse));
        }
        ThreadPoolManager.getInstance().scheduleAi(new HitTask(this, target, damage1, crit1, miss1, attack.hasSoulshot(), shld1), sAtk);
        this._disableBowAttackEndTime = (long)(sAtk + reuse) + System.currentTimeMillis();
        attack.addHit(target, damage1, miss1, crit1, shld1);
        return !miss1;
    }

    private boolean doAttackHitByCrossBow(Attack attack, L2Character target, int sAtk, int reuse) {
        int damage1 = 0;
        byte shld1 = 0;
        boolean crit1 = false;
        boolean miss1 = Formulas.calcHitMiss(this, target);
        this.reduceArrowCount(true);
        this._move = null;
        if (!miss1) {
            shld1 = Formulas.calcShldUse(this, target);
            crit1 = Formulas.calcCrit(this, target);
            damage1 = (int)Formulas.calcPhysDam(this, target, shld1, crit1, attack.hasSoulshot());
        }
        if (this.isPlayer()) {
            this.sendPacket(SystemMessageId.CROSSBOW_PREPARING_TO_FIRE);
            SetupGauge sg = new SetupGauge(1, sAtk + reuse);
            this.sendPacket(sg);
        }
        ThreadPoolManager.getInstance().scheduleAi(new HitTask(this, target, damage1, crit1, miss1, attack.hasSoulshot(), shld1), sAtk);
        this._disableBowAttackEndTime = (long)(sAtk + reuse) + System.currentTimeMillis();
        attack.addHit(target, damage1, miss1, crit1, shld1);
        return !miss1;
    }

    private boolean doAttackHitByDual(Attack attack, L2Character target, int sAtk) {
        int damage1 = 0;
        int damage2 = 0;
        byte shld1 = 0;
        byte shld2 = 0;
        boolean crit1 = false;
        boolean crit2 = false;
        boolean miss1 = Formulas.calcHitMiss(this, target);
        boolean miss2 = Formulas.calcHitMiss(this, target);
        if (!miss1) {
            shld1 = Formulas.calcShldUse(this, target);
            crit1 = Formulas.calcCrit(this, target);
            damage1 = (int)Formulas.calcPhysDam(this, target, shld1, crit1, attack.hasSoulshot());
            damage1 /= 2;
        }
        if (!miss2) {
            shld2 = Formulas.calcShldUse(this, target);
            crit2 = Formulas.calcCrit(this, target);
            damage2 = (int)Formulas.calcPhysDam(this, target, shld2, crit2, attack.hasSoulshot());
            damage2 /= 2;
        }
        ThreadPoolManager.getInstance().scheduleAi(new HitTask(this, target, damage1, crit1, miss1, attack.hasSoulshot(), shld1), sAtk / 2);
        ThreadPoolManager.getInstance().scheduleAi(new HitTask(this, target, damage2, crit2, miss2, attack.hasSoulshot(), shld2), sAtk);
        attack.addHit(target, damage1, miss1, crit1, shld1);
        attack.addHit(target, damage2, miss2, crit2, shld2);
        return !miss1 || !miss2;
    }

    private boolean doAttackHitByPole(Attack attack, L2Character target, int sAtk) {
        boolean hitted = this.doAttackHitSimple(attack, target, 100.0, sAtk);
        if (this.isAffected(EffectFlag.SINGLE_TARGET)) {
            return hitted;
        }
        int maxRadius = this.getStat().getPhysicalAttackRange();
        int maxAngleDiff = this.getStat().getPhysicalAttackAngle();
        int attackRandomCountMax = (int)this.getStat().calcStat(Stats.ATTACK_COUNT_MAX, 1.0, null, null);
        int attackcount = 0;
        double attackpercent = 85.0;
        Collection<L2Object> objs = this.getKnownList().getKnownObjects().values();
        for (L2Object obj : objs) {
            L2Character temp;
            if (obj == target || obj == null || !obj.isCharacter() || obj.isPet() && this.isPlayer() && ((L2PetInstance)obj).getOwner() == this.getActingPlayer() || !Util.checkIfInRange(maxRadius, this, obj, false) || Math.abs(obj.getZ() - this.getZ()) > 650 || !this.isFacing(obj, maxAngleDiff) || this.isAttackable() && obj.isPlayer() && obj.isAttackable() || this.isAttackable() && obj.isAttackable() && !((L2Attackable)this).isChaos() || (temp = (L2Character)obj).isAlikeDead() || temp != this.getAI().getAttackTarget() && !temp.isAutoAttackable(this)) continue;
            hitted |= this.doAttackHitSimple(attack, temp, attackpercent, sAtk);
            attackpercent /= 1.15;
            if (++attackcount <= attackRandomCountMax) continue;
            break;
        }
        return hitted;
    }

    private boolean doAttackHitSimple(Attack attack, L2Character target, int sAtk) {
        return this.doAttackHitSimple(attack, target, 100.0, sAtk);
    }

    private boolean doAttackHitSimple(Attack attack, L2Character target, double attackpercent, int sAtk) {
        int damage1 = 0;
        byte shld1 = 0;
        boolean crit1 = false;
        boolean miss1 = Formulas.calcHitMiss(this, target);
        if (!miss1) {
            shld1 = Formulas.calcShldUse(this, target);
            crit1 = Formulas.calcCrit(this, target);
            damage1 = (int)Formulas.calcPhysDam(this, target, shld1, crit1, attack.hasSoulshot());
            if (attackpercent != 100.0) {
                damage1 = (int)((double)damage1 * attackpercent / 100.0);
            }
        }
        ThreadPoolManager.getInstance().scheduleAi(new HitTask(this, target, damage1, crit1, miss1, attack.hasSoulshot(), shld1), sAtk);
        attack.addHit(target, damage1, miss1, crit1, shld1);
        return !miss1;
    }

    public void doCast(Skill skill) {
        this.beginCast(skill, false);
    }

    public void doCast(SkillHolder skill) {
        this.beginCast(skill.getSkill(), false);
    }

    public void doSimultaneousCast(Skill skill) {
        this.beginCast(skill, true);
    }

    public void doSimultaneousCast(SkillHolder skill) {
        this.beginCast(skill.getSkill(), true);
    }

    public void doCast(Skill skill, L2Character target, List<L2Object> targets) {
        if (!this.checkDoCastConditions(skill)) {
            this.setIsCastingNow(false);
            return;
        }
        if (skill.isSimultaneousCast()) {
            this.doSimultaneousCast(skill, target, targets);
            return;
        }
        this.stopEffectsOnAction();
        this.beginCast(skill, false, target, targets);
    }

    public void doSimultaneousCast(Skill skill, L2Character target, List<L2Object> targets) {
        if (!this.checkDoCastConditions(skill)) {
            this.setIsCastingSimultaneouslyNow(false);
            return;
        }
        this.stopEffectsOnAction();
        this.beginCast(skill, true, target, targets);
    }

    private void beginCast(Skill skill, boolean simultaneously) {
        if (!this.checkDoCastConditions(skill)) {
            if (simultaneously) {
                this.setIsCastingSimultaneouslyNow(false);
            } else {
                this.setIsCastingNow(false);
            }
            if (this.isPlayer()) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            }
            return;
        }
        if (skill.isSimultaneousCast() && !simultaneously) {
            simultaneously = true;
        }
        this.stopEffectsOnAction();
        L2Object target = skill.getTargetType().getTarget(skill, this, this._target);
        List<L2Object> targets = skill.getTargetType().getTargets(skill, this, this._target);
        this.beginCast(skill, simultaneously, (L2Character)target, targets);
    }

    private void beginCast(Skill skill, boolean simultaneously, L2Character target, List<L2Object> targets) {
        int initmpcons;
        if (target == null) {
            if (simultaneously) {
                this.setIsCastingSimultaneouslyNow(false);
            } else {
                this.setIsCastingNow(false);
            }
            if (this.isPlayer()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            }
            return;
        }
        TerminateReturn term = EventDispatcher.getInstance().notifyEvent(new CreatureSkillUse(this, skill, simultaneously, target, targets), this, TerminateReturn.class);
        if (term != null && term.terminate()) {
            if (simultaneously) {
                this.setIsCastingSimultaneouslyNow(false);
            } else {
                this.setIsCastingNow(false);
            }
            if (this.isPlayer()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            }
            return;
        }
        if (skill.hasEffectType(L2EffectType.RESURRECTION, new L2EffectType[0]) && (this.isResurrectionBlocked() || target.isResurrectionBlocked())) {
            this.sendPacket(SystemMessageId.REJECT_RESURRECTION);
            target.sendPacket(SystemMessageId.REJECT_RESURRECTION);
            if (simultaneously) {
                this.setIsCastingSimultaneouslyNow(false);
            } else {
                this.setIsCastingNow(false);
            }
            if (this.isPlayer()) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                this.sendPacket(ActionFailed.STATIC_PACKET);
            }
            return;
        }
        int magicId = skill.getId();
        double skillAnimTime = Formulas.calcCastTime(this, skill);
        if (this.isCastingSimultaneouslyNow() && simultaneously) {
            ThreadPoolManager.getInstance().scheduleAi(() -> this.beginCast(skill, simultaneously, target, targets), 100L);
            return;
        }
        if (simultaneously) {
            this.setIsCastingSimultaneouslyNow(true);
            this.setLastSimultaneousSkillCast(skill);
        } else {
            this.setIsCastingNow(true);
            this._castInterruptTime = -2 + GameTimeController.getInstance().getGameTicks() + (int)skillAnimTime / 100;
            this.setLastSkillCast(skill);
        }
        int reuseDelay = skill.isReuseDelayLocked() || skill.isStatic() ? skill.getReuseDelay() : (skill.isMagic() ? (int)((double)skill.getReuseDelay() * this.calcStat(Stats.MAGIC_REUSE_RATE, 1.0, null, null)) : (skill.isPhysical() ? (int)((double)skill.getReuseDelay() * this.calcStat(Stats.P_REUSE, 1.0, null, null)) : (int)((double)skill.getReuseDelay() * this.calcStat(Stats.DANCE_REUSE, 1.0, null, null))));
        boolean skillMastery = Formulas.calcSkillMastery(this, skill);
        if (reuseDelay > 30000 && !skillMastery) {
            this.addTimeStamp(skill, reuseDelay);
        }
        if ((initmpcons = this.getStat().getMpConsume1(skill)) > 0) {
            this.getStatus().reduceMp(initmpcons);
            StatusUpdate su = new StatusUpdate(this);
            su.addAttribute(11, (int)this.getCurrentMp());
            this.sendPacket(su);
        }
        if (reuseDelay > 10) {
            if (skillMastery) {
                reuseDelay = 100;
                if (this.getActingPlayer() != null) {
                    this.getActingPlayer().sendPacket(SystemMessageId.SKILL_READY_TO_USE_AGAIN);
                }
            }
            this.disableSkill(skill, reuseDelay);
        }
        if (target != this) {
            this.setHeading(Util.calculateHeadingFrom(this, target));
            this.broadcastPacket(new ExRotation(this.getObjectId(), this.getHeading()));
        }
        if (this.isPlayable()) {
            if (skill.getItemConsumeId() > 0 && !this.destroyItemByItemId("Consume", skill.getItemConsumeId(), skill.getItemConsumeCount(), null, true)) {
                this.getActingPlayer().sendPacket(SystemMessageId.NOT_ENOUGH_ITEMS);
                this.abortCast();
                return;
            }
            if (skill.getReferenceItemId() > 0 && ItemTable.getInstance().getTemplate(skill.getReferenceItemId()).getBodyPart() == 0x400000) {
                for (L2ItemInstance item : this.getInventory().getItemsByItemId(skill.getReferenceItemId())) {
                    if (!item.isEquipped()) continue;
                    if (item.getMana() < item.useSkillDisTime()) {
                        this.abortCast();
                        return;
                    }
                    item.decreaseMana(false, item.useSkillDisTime());
                    break;
                }
            }
        }
        this.broadcastPacket(new MagicSkillUse(this, target, skill.getDisplayId(), skill.getDisplayLevel(), (int)skillAnimTime, reuseDelay));
        if (this.isPlayer() && !skill.isAbnormalInstant()) {
            SystemMessage sm = null;
            switch (magicId) {
                case 1312: {
                    break;
                }
                case 2046: {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.SUMMON_A_PET);
                    break;
                }
                default: {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.USE_S1);
                    sm.addSkillName(skill);
                }
            }
            this.sendPacket(sm);
        }
        if (skill.hasEffects(EffectScope.START)) {
            skill.applyEffectScope(EffectScope.START, new BuffInfo(this, target, skill), true, false);
        }
        if (skill.isFlyType()) {
            ThreadPoolManager.getInstance().scheduleEffect(new FlyToLocationTask(this, target, FlyToLocation.FlyType.CHARGE), 50L);
        }
        MagicUseTask mut = new MagicUseTask(this, targets, skill, (int)skillAnimTime, simultaneously);
        if (skillAnimTime > 0.0) {
            if (this.isPlayer() && !simultaneously) {
                this.sendPacket(new SetupGauge(0, (int)skillAnimTime));
            }
            if (skill.isChanneling() && skill.getChannelingSkillId() > 0) {
                this.getSkillChannelizer().startChanneling(skill);
            } else if (skill.isContinuous()) {
                skillAnimTime -= 300.0;
            }
            if (simultaneously) {
                future = this._skillCast2;
                if (future != null) {
                    future.cancel(true);
                    this._skillCast2 = null;
                }
                this._skillCast2 = ThreadPoolManager.getInstance().scheduleEffect(mut, (int)skillAnimTime - 400);
            } else {
                future = this._skillCast;
                if (future != null) {
                    future.cancel(true);
                    this._skillCast = null;
                }
                this._skillCast = ThreadPoolManager.getInstance().scheduleEffect(mut, (int)skillAnimTime - 400);
            }
        } else {
            mut.setSkillTime(0);
            this.onMagicLaunchedTimer(mut);
        }
    }

    public boolean checkDoCastConditions(Skill skill) {
        L2ItemInstance requiredItems;
        L2Weapon wep;
        if (skill == null || this.isSkillDisabled(skill) || skill.isFlyType() && this.isMovementDisabled()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.getCurrentMp() < (double)(this.getStat().getMpConsume1(skill) + this.getStat().getMpConsume2(skill))) {
            this.sendPacket(SystemMessageId.NOT_ENOUGH_MP);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.getCurrentHp() <= (double)skill.getHpConsume()) {
            this.sendPacket(SystemMessageId.NOT_ENOUGH_HP);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (!skill.isStatic()) {
            if (skill.isMagic()) {
                if (this.isMuted()) {
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return false;
                }
            } else if (this.isPhysicalMuted()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
        }
        if (skill.isChanneling() && skill.getChannelingSkillId() > 0) {
            L2WorldRegion region = this.getWorldRegion();
            if (region == null) {
                return false;
            }
            boolean canCast = true;
            if (skill.getTargetType() == TargetType.GROUND && this.isPlayer()) {
                Location wp = this.getActingPlayer().getCurrentSkillWorldPosition();
                if (!region.checkEffectRangeInsidePeaceZone(skill, wp.getX(), wp.getY(), wp.getZ())) {
                    canCast = false;
                }
            } else if (!region.checkEffectRangeInsidePeaceZone(skill, this.getX(), this.getY(), this.getZ())) {
                canCast = false;
            }
            if (!canCast) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
                sm.addSkillName(skill);
                this.sendPacket(sm);
                return false;
            }
        }
        if (this.getActiveWeaponItem() != null && (wep = this.getActiveWeaponItem()).useWeaponSkillsOnly() && !this.isGM() && wep.hasSkills()) {
            boolean found = false;
            for (SkillHolder sh : wep.getSkills()) {
                if (sh.getSkillId() != skill.getId()) continue;
                found = true;
                break;
            }
            if (!found) {
                if (this.getActingPlayer() != null) {
                    this.sendPacket(SystemMessageId.WEAPON_CAN_USE_ONLY_WEAPON_SKILL);
                }
                return false;
            }
        }
        if (skill.getItemConsumeId() > 0 && this.getInventory() != null && ((requiredItems = this.getInventory().getItemByItemId(skill.getItemConsumeId())) == null || requiredItems.getCount() < (long)skill.getItemConsumeCount())) {
            if (skill.hasEffectType(L2EffectType.SUMMON, new L2EffectType[0])) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.SUMMONING_SERVITOR_COSTS_S2_S1);
                sm.addItemName(skill.getItemConsumeId());
                sm.addInt(skill.getItemConsumeCount());
                this.sendPacket(sm);
            } else {
                this.sendPacket(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL);
            }
            return false;
        }
        return true;
    }

    public final Map<Integer, TimeStamp> getItemReuseTimeStamps() {
        return this._reuseTimeStampsItems;
    }

    public final void addTimeStampItem(L2ItemInstance item, long reuse) {
        this.addTimeStampItem(item, reuse, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTimeStampItem(L2ItemInstance item, long reuse, long systime) {
        if (this._reuseTimeStampsItems == null) {
            L2Character l2Character = this;
            synchronized (l2Character) {
                if (this._reuseTimeStampsItems == null) {
                    this._reuseTimeStampsItems = new ConcurrentHashMap<Integer, TimeStamp>();
                }
            }
        }
        this._reuseTimeStampsItems.put(item.getObjectId(), new TimeStamp(item, reuse, systime));
    }

    public final synchronized long getItemRemainingReuseTime(int itemObjId) {
        TimeStamp reuseStamp = this._reuseTimeStampsItems != null ? this._reuseTimeStampsItems.get(itemObjId) : null;
        return reuseStamp != null ? reuseStamp.getRemaining() : -1L;
    }

    public final long getReuseDelayOnGroup(int group) {
        if (group > 0 && this._reuseTimeStampsItems != null) {
            for (TimeStamp ts : this._reuseTimeStampsItems.values()) {
                if (ts.getSharedReuseGroup() != group || !ts.hasNotPassed()) continue;
                return ts.getRemaining();
            }
        }
        return -1L;
    }

    public final Map<Integer, TimeStamp> getSkillReuseTimeStamps() {
        return this._reuseTimeStampsSkills;
    }

    public final void addTimeStamp(Skill skill, long reuse) {
        this.addTimeStamp(skill, reuse, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTimeStamp(Skill skill, long reuse, long systime) {
        if (this._reuseTimeStampsSkills == null) {
            L2Character l2Character = this;
            synchronized (l2Character) {
                if (this._reuseTimeStampsSkills == null) {
                    this._reuseTimeStampsSkills = new ConcurrentHashMap<Integer, TimeStamp>();
                }
            }
        }
        this._reuseTimeStampsSkills.put(skill.getReuseHashCode(), new TimeStamp(skill, reuse, systime));
    }

    public final synchronized void removeTimeStamp(Skill skill) {
        if (this._reuseTimeStampsSkills != null) {
            this._reuseTimeStampsSkills.remove(skill.getReuseHashCode());
        }
    }

    public final synchronized void resetTimeStamps() {
        if (this._reuseTimeStampsSkills != null) {
            this._reuseTimeStampsSkills.clear();
        }
    }

    public final synchronized long getSkillRemainingReuseTime(int hashCode) {
        TimeStamp reuseStamp = this._reuseTimeStampsSkills != null ? this._reuseTimeStampsSkills.get(hashCode) : null;
        return reuseStamp != null ? reuseStamp.getRemaining() : -1L;
    }

    public final synchronized boolean hasSkillReuse(int hashCode) {
        TimeStamp reuseStamp = this._reuseTimeStampsSkills != null ? this._reuseTimeStampsSkills.get(hashCode) : null;
        return reuseStamp != null && reuseStamp.hasNotPassed();
    }

    public final synchronized TimeStamp getSkillReuseTimeStamp(int hashCode) {
        return this._reuseTimeStampsSkills != null ? this._reuseTimeStampsSkills.get(hashCode) : null;
    }

    public Map<Integer, Long> getDisabledSkills() {
        return this._disabledSkills;
    }

    public void enableSkill(Skill skill) {
        if (skill == null || this._disabledSkills == null) {
            return;
        }
        this._disabledSkills.remove(skill.getReuseHashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableSkill(Skill skill, long delay) {
        if (skill == null) {
            return;
        }
        if (this._disabledSkills == null) {
            L2Character l2Character = this;
            synchronized (l2Character) {
                if (this._disabledSkills == null) {
                    this._disabledSkills = new ConcurrentHashMap<Integer, Long>();
                }
            }
        }
        this._disabledSkills.put(skill.getReuseHashCode(), delay > 0L ? System.currentTimeMillis() + delay : Long.MAX_VALUE);
    }

    public final synchronized void resetDisabledSkills() {
        if (this._disabledSkills != null) {
            this._disabledSkills.clear();
        }
    }

    public boolean isSkillDisabled(Skill skill) {
        return skill != null && this.isSkillDisabled(skill.getReuseHashCode());
    }

    public boolean isSkillDisabled(int hashCode) {
        if (this.isAllSkillsDisabled()) {
            return true;
        }
        if (this._disabledSkills == null) {
            return false;
        }
        Long stamp = this._disabledSkills.get(hashCode);
        if (stamp == null) {
            return false;
        }
        if (stamp < System.currentTimeMillis()) {
            this._disabledSkills.remove(hashCode);
            return false;
        }
        return true;
    }

    public void disableAllSkills() {
        this._allSkillsDisabled = true;
    }

    public void enableAllSkills() {
        this._allSkillsDisabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doDie(L2Character killer) {
        TerminateReturn returnBack = EventDispatcher.getInstance().notifyEvent(new CreatureKill(killer, this), this, TerminateReturn.class);
        if (returnBack != null && returnBack.terminate()) {
            return false;
        }
        L2Character l2Character = this;
        synchronized (l2Character) {
            if (this.isDead()) {
                return false;
            }
            this.setCurrentHp(0.0);
            this.setIsDead(true);
        }
        this.setTarget(null);
        this.stopMove(null);
        this.getStatus().stopHpMpRegeneration();
        this.stopAllEffectsExceptThoseThatLastThroughDeath();
        this.calculateRewards(killer);
        this.broadcastStatusUpdate();
        if (this.hasAI()) {
            this.getAI().notifyEvent(CtrlEvent.EVT_DEAD);
        }
        if (this.getWorldRegion() != null) {
            this.getWorldRegion().onDeath(this);
        }
        this.getAttackByList().clear();
        if (this.isChannelized()) {
            this.getSkillChannelized().abortChannelization();
        }
        return true;
    }

    @Override
    public boolean deleteMe() {
        this.setDebug(null);
        if (this.hasAI()) {
            this.getAI().stopAITask();
        }
        return true;
    }

    public void detachAI() {
        if (this.isWalker()) {
            return;
        }
        this.setAI(null);
    }

    protected void calculateRewards(L2Character killer) {
    }

    public void doRevive() {
        if (!this.isDead()) {
            return;
        }
        if (!this.isTeleporting()) {
            this.setIsPendingRevive(false);
            this.setIsDead(false);
            if (Configuration.character().getRespawnRestoreCP() > 0.0 && this.getCurrentCp() < (double)this.getMaxCp() * Configuration.character().getRespawnRestoreCP()) {
                this._status.setCurrentCp((double)this.getMaxCp() * Configuration.character().getRespawnRestoreCP());
            }
            if (Configuration.character().getRespawnRestoreHP() > 0.0 && this.getCurrentHp() < (double)this.getMaxHp() * Configuration.character().getRespawnRestoreHP()) {
                this._status.setCurrentHp((double)this.getMaxHp() * Configuration.character().getRespawnRestoreHP());
            }
            if (Configuration.character().getRespawnRestoreMP() > 0.0 && this.getCurrentMp() < (double)this.getMaxMp() * Configuration.character().getRespawnRestoreMP()) {
                this._status.setCurrentMp((double)this.getMaxMp() * Configuration.character().getRespawnRestoreMP());
            }
            this.broadcastPacket(new Revive(this));
            if (this.getWorldRegion() != null) {
                this.getWorldRegion().onRevive(this);
            }
        } else {
            this.setIsPendingRevive(true);
        }
    }

    public void doRevive(double revivePower) {
        this.doRevive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final L2CharacterAI getAI() {
        if (this._ai == null) {
            L2Character l2Character = this;
            synchronized (l2Character) {
                if (this._ai == null) {
                    this._ai = this.initAI();
                    return this._ai;
                }
            }
        }
        return this._ai;
    }

    protected L2CharacterAI initAI() {
        return new L2CharacterAI(this);
    }

    public void setAI(L2CharacterAI newAI) {
        L2CharacterAI oldAI = this._ai;
        if (oldAI != newAI && oldAI instanceof L2AttackableAI) {
            oldAI.stopAITask();
        }
        this._ai = newAI;
    }

    public boolean hasAI() {
        return this._ai != null;
    }

    public boolean isRaid() {
        return false;
    }

    public boolean isMinion() {
        return false;
    }

    public boolean isRaidMinion() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<L2Character> getAttackByList() {
        if (this._attackByList == null) {
            L2Character l2Character = this;
            synchronized (l2Character) {
                if (this._attackByList == null) {
                    this._attackByList = ConcurrentHashMap.newKeySet();
                }
            }
        }
        return this._attackByList;
    }

    public final Skill getLastSimultaneousSkillCast() {
        return this._lastSimultaneousSkillCast;
    }

    public void setLastSimultaneousSkillCast(Skill skill) {
        this._lastSimultaneousSkillCast = skill;
    }

    public final Skill getLastSkillCast() {
        return this._lastSkillCast;
    }

    public void setLastSkillCast(Skill skill) {
        this._lastSkillCast = skill;
    }

    public final boolean isNoRndWalk() {
        return this._isNoRndWalk;
    }

    public final void setIsNoRndWalk(boolean value) {
        this._isNoRndWalk = value;
    }

    public final boolean isAfraid() {
        return this.isAffected(EffectFlag.FEAR);
    }

    public final boolean isAllSkillsDisabled() {
        return this._allSkillsDisabled || this.isStunned() || this.isSleeping();
    }

    public boolean isAttackingDisabled() {
        return this.isFlying() || this.isStunned() || this.isSleeping() || this.isAttackingNow() || this.isAlikeDead() || this.isPhysicalAttackMuted() || this.isCoreAIDisabled();
    }

    public final Calculator[] getCalculators() {
        return this._calculators;
    }

    public final boolean isConfused() {
        return this.isAffected(EffectFlag.CONFUSED);
    }

    public boolean isAlikeDead() {
        return this._isDead;
    }

    public final boolean isDead() {
        return this._isDead;
    }

    public final void setIsDead(boolean value) {
        this._isDead = value;
    }

    public boolean isImmobilized() {
        return this._isImmobilized;
    }

    public void setIsImmobilized(boolean value) {
        this._isImmobilized = value;
    }

    public final boolean isMuted() {
        return this.isAffected(EffectFlag.MUTED);
    }

    public final boolean isPhysicalMuted() {
        return this.isAffected(EffectFlag.PSYCHICAL_MUTED);
    }

    public final boolean isPhysicalAttackMuted() {
        return this.isAffected(EffectFlag.PSYCHICAL_ATTACK_MUTED);
    }

    public boolean isMovementDisabled() {
        return this.isStunned() || this.isRooted() || this.isSleeping() || this.isOverloaded() || this.isImmobilized() || this.isAlikeDead() || this.isTeleporting();
    }

    public final boolean isOutOfControl() {
        return this.isConfused() || this.isAfraid();
    }

    public final boolean isOverloaded() {
        return this._isOverloaded;
    }

    public final void setIsOverloaded(boolean value) {
        this._isOverloaded = value;
    }

    public final boolean isPendingRevive() {
        return this.isDead() && this._isPendingRevive;
    }

    public final void setIsPendingRevive(boolean value) {
        this._isPendingRevive = value;
    }

    public final boolean isDisarmed() {
        return this.isAffected(EffectFlag.DISARMED);
    }

    public L2Summon getSummon() {
        return null;
    }

    public final boolean hasSummon() {
        return this.getSummon() != null;
    }

    public final boolean hasPet() {
        return this.hasSummon() && this.getSummon().isPet();
    }

    public final boolean hasServitor() {
        return this.hasSummon() && this.getSummon().isServitor();
    }

    public final boolean isRooted() {
        return this.isAffected(EffectFlag.ROOTED);
    }

    public boolean isRunning() {
        return this._isRunning;
    }

    public final void setIsRunning(boolean value) {
        if (this._isRunning == value) {
            return;
        }
        this._isRunning = value;
        if (this.getRunSpeed() != 0.0) {
            this.broadcastPacket(new ChangeMoveType(this));
        }
        if (this.isPlayer()) {
            this.getActingPlayer().broadcastUserInfo();
        } else if (this.isSummon()) {
            this.broadcastStatusUpdate();
        } else if (this.isNpc()) {
            Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
            for (L2PcInstance player : plrs) {
                if (player == null || !this.isVisibleFor(player)) continue;
                if (this.getRunSpeed() == 0.0) {
                    player.sendPacket(new ServerObjectInfo((L2Npc)this, player));
                    continue;
                }
                player.sendPacket(new AbstractNpcInfo.NpcInfo((L2Npc)this, player));
            }
        }
    }

    public final void setRunning() {
        if (!this.isRunning()) {
            this.setIsRunning(true);
        }
    }

    public final boolean isSleeping() {
        return this.isAffected(EffectFlag.SLEEP);
    }

    public final boolean isStunned() {
        return this.isAffected(EffectFlag.STUNNED);
    }

    public final boolean isBetrayed() {
        return this.isAffected(EffectFlag.BETRAYED);
    }

    public final boolean isTeleporting() {
        return this._isTeleporting;
    }

    public void setIsTeleporting(boolean value) {
        this._isTeleporting = value;
    }

    public void setIsInvul(boolean b) {
        this._isInvul = b;
    }

    public boolean isInvul() {
        return this._isInvul || this._isTeleporting;
    }

    public boolean isHpBlocked() {
        return this.isAffected(EffectFlag.BLOCK_HP);
    }

    public boolean isMpBlocked() {
        return this.isAffected(EffectFlag.BLOCK_MP);
    }

    public boolean isBuffBlocked() {
        return this.isAffected(EffectFlag.BLOCK_BUFF);
    }

    public boolean isDebuffBlocked() {
        return this.isAffected(EffectFlag.BLOCK_DEBUFF);
    }

    public void setIsMortal(boolean b) {
        this._isMortal = b;
    }

    public boolean isMortal() {
        return this._isMortal;
    }

    public boolean isUndead() {
        return false;
    }

    public boolean isResurrectionBlocked() {
        return this.isAffected(EffectFlag.BLOCK_RESURRECTION);
    }

    public final boolean isFlying() {
        return this._isFlying;
    }

    public final void setIsFlying(boolean mode) {
        this._isFlying = mode;
    }

    @Override
    public CharKnownList getKnownList() {
        return (CharKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new CharKnownList(this));
    }

    public CharStat getStat() {
        return this._stat;
    }

    public void initCharStat() {
        this._stat = new CharStat(this);
    }

    public final void setStat(CharStat value) {
        this._stat = value;
    }

    public CharStatus getStatus() {
        return this._status;
    }

    public void initCharStatus() {
        this._status = new CharStatus(this);
    }

    public final void setStatus(CharStatus value) {
        this._status = value;
    }

    public L2CharTemplate getTemplate() {
        return this._template;
    }

    protected final void setTemplate(L2CharTemplate template) {
        this._template = template;
    }

    public final String getTitle() {
        return this._title;
    }

    public final void setTitle(String value) {
        this._title = value == null ? "" : (value.length() > 21 ? value.substring(0, 20) : value);
    }

    public final void setWalking() {
        if (this.isRunning()) {
            this.setIsRunning(false);
        }
    }

    public int getAbnormalVisualEffects() {
        return this._abnormalVisualEffects;
    }

    public int getAbnormalVisualEffectSpecial() {
        return this._abnormalVisualEffectsSpecial;
    }

    public int getAbnormalVisualEffectEvent() {
        return this._abnormalVisualEffectsEvent;
    }

    public boolean hasAbnormalVisualEffect(AbnormalVisualEffect ave) {
        if (ave.isEvent()) {
            return (this.getAbnormalVisualEffectEvent() & ave.getMask()) == ave.getMask();
        }
        if (ave.isSpecial()) {
            return (this.getAbnormalVisualEffectSpecial() & ave.getMask()) == ave.getMask();
        }
        return (this.getAbnormalVisualEffects() & ave.getMask()) == ave.getMask();
    }

    public final void startAbnormalVisualEffect(boolean update, AbnormalVisualEffect ... aves) {
        for (AbnormalVisualEffect ave : aves) {
            if (ave.isEvent()) {
                this._abnormalVisualEffectsEvent |= ave.getMask();
                continue;
            }
            if (ave.isSpecial()) {
                this._abnormalVisualEffectsSpecial |= ave.getMask();
                continue;
            }
            this._abnormalVisualEffects |= ave.getMask();
        }
        if (update) {
            this.updateAbnormalEffect();
        }
    }

    public final void stopAbnormalVisualEffect(boolean update, AbnormalVisualEffect ... aves) {
        for (AbnormalVisualEffect ave : aves) {
            if (ave.isEvent()) {
                this._abnormalVisualEffectsEvent &= ~ave.getMask();
                continue;
            }
            if (ave.isSpecial()) {
                this._abnormalVisualEffectsSpecial &= ~ave.getMask();
                continue;
            }
            this._abnormalVisualEffects &= ~ave.getMask();
        }
        if (update) {
            this.updateAbnormalEffect();
        }
    }

    public final void startFakeDeath() {
        if (!this.isPlayer()) {
            return;
        }
        this.getActingPlayer().setIsFakeDeath(true);
        this.abortAttack();
        this.abortCast();
        this.stopMove(null);
        this.getAI().notifyEvent(CtrlEvent.EVT_FAKE_DEATH);
        this.broadcastPacket(new ChangeWaitType(this, 2));
    }

    public final void startStunning() {
        this.abortAttack();
        this.abortCast();
        this.stopMove(null);
        this.getAI().notifyEvent(CtrlEvent.EVT_STUNNED);
        if (!this.isSummon()) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        }
        this.updateAbnormalEffect();
    }

    public void stopAllEffects() {
        this._effectList.stopAllEffects();
    }

    public void stopAllEffectsExceptThoseThatLastThroughDeath() {
        this._effectList.stopAllEffectsExceptThoseThatLastThroughDeath();
    }

    public void stopSkillEffects(boolean removed, int skillId) {
        this._effectList.stopSkillEffects(removed, skillId);
    }

    public final void stopEffects(L2EffectType type) {
        this._effectList.stopEffects(type);
    }

    public final void stopEffectsOnAction() {
        this._effectList.stopEffectsOnAction();
    }

    public final void stopEffectsOnDamage(boolean awake) {
        this._effectList.stopEffectsOnDamage(awake);
    }

    public final void stopFakeDeath(boolean removeEffects) {
        if (removeEffects) {
            this.stopEffects(L2EffectType.FAKE_DEATH);
        }
        if (this.isPlayer()) {
            this.getActingPlayer().setIsFakeDeath(false);
            this.getActingPlayer().setRecentFakeDeath(true);
        }
        this.broadcastPacket(new ChangeWaitType(this, 3));
        this.broadcastPacket(new Revive(this));
    }

    public final void stopStunning(boolean removeEffects) {
        if (removeEffects) {
            this.stopEffects(L2EffectType.STUN);
        }
        if (!this.isPlayer()) {
            this.getAI().notifyEvent(CtrlEvent.EVT_THINK);
        }
        this.updateAbnormalEffect();
    }

    public final void stopTransformation(boolean removeEffects) {
        if (removeEffects) {
            this.getEffectList().stopSkillEffects(false, AbnormalType.TRANSFORM);
        }
        if (this.isPlayer() && this.getActingPlayer().getTransformation() != null) {
            this.getActingPlayer().untransform();
        }
        if (!this.isPlayer()) {
            this.getAI().notifyEvent(CtrlEvent.EVT_THINK);
        }
        this.updateAbnormalEffect();
    }

    public abstract void updateAbnormalEffect();

    public final void updateEffectIcons() {
        this.updateEffectIcons(false);
    }

    public void updateEffectIcons(boolean partyOnly) {
    }

    public boolean isAffectedBySkill(int skillId) {
        return this._effectList.isAffectedBySkill(skillId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addStatFunc(AbstractFunction function) {
        if (function == null) {
            return;
        }
        L2Character l2Character = this;
        synchronized (l2Character) {
            int stat;
            if (this._calculators == NPC_STD_CALCULATOR) {
                this._calculators = new Calculator[Stats.NUM_STATS];
                for (int i = 0; i < Stats.NUM_STATS; ++i) {
                    if (NPC_STD_CALCULATOR[i] == null) continue;
                    this._calculators[i] = new Calculator(NPC_STD_CALCULATOR[i]);
                }
            }
            if (this._calculators[stat = function.getStat().ordinal()] == null) {
                this._calculators[stat] = new Calculator();
            }
            this._calculators[stat].addFunc(function);
        }
    }

    public final void addStatFuncs(List<AbstractFunction> functions) {
        if (!this.isPlayer() && this.getKnownList().getKnownPlayers().isEmpty()) {
            for (AbstractFunction f : functions) {
                this.addStatFunc(f);
            }
        } else {
            ArrayList<Stats> modifiedStats = new ArrayList<Stats>();
            for (AbstractFunction f : functions) {
                modifiedStats.add(f.getStat());
                this.addStatFunc(f);
            }
            this.broadcastModifiedStats(modifiedStats);
        }
    }

    public final void addStatFuncs(AbstractFunction function) {
        this.addStatFuncs(List.of(function));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeStatFunc(AbstractFunction function) {
        if (function == null) {
            return;
        }
        int stat = function.getStat().ordinal();
        L2Character l2Character = this;
        synchronized (l2Character) {
            if (this._calculators[stat] == null) {
                return;
            }
            this._calculators[stat].removeFunc(function);
            if (this._calculators[stat].size() == 0) {
                this._calculators[stat] = null;
            }
            if (this.isNpc()) {
                int i;
                for (i = 0; i < Stats.NUM_STATS && Calculator.equalsCals(this._calculators[i], NPC_STD_CALCULATOR[i]); ++i) {
                }
                if (i >= Stats.NUM_STATS) {
                    this._calculators = NPC_STD_CALCULATOR;
                }
            }
        }
    }

    public final void removeStatFuncs(AbstractFunction[] functions) {
        if (!this.isPlayer() && this.getKnownList().getKnownPlayers().isEmpty()) {
            for (AbstractFunction f : functions) {
                this.removeStatFunc(f);
            }
        } else {
            ArrayList<Stats> modifiedStats = new ArrayList<Stats>();
            for (AbstractFunction f : functions) {
                modifiedStats.add(f.getStat());
                this.removeStatFunc(f);
            }
            this.broadcastModifiedStats(modifiedStats);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeStatsOwner(Object owner) {
        List<Stats> modifiedStats = null;
        int i = 0;
        L2Character l2Character = this;
        synchronized (l2Character) {
            for (Calculator calc : this._calculators) {
                if (calc != null) {
                    if (modifiedStats != null) {
                        modifiedStats.addAll(calc.removeOwner(owner));
                    } else {
                        modifiedStats = calc.removeOwner(owner);
                    }
                    if (calc.size() == 0) {
                        this._calculators[i] = null;
                    }
                }
                ++i;
            }
            if (this.isNpc()) {
                for (i = 0; i < Stats.NUM_STATS && Calculator.equalsCals(this._calculators[i], NPC_STD_CALCULATOR[i]); ++i) {
                }
                if (i >= Stats.NUM_STATS) {
                    this._calculators = NPC_STD_CALCULATOR;
                }
            }
            this.broadcastModifiedStats(modifiedStats);
        }
    }

    protected void broadcastModifiedStats(List<Stats> stats) {
        if (stats == null || stats.isEmpty()) {
            return;
        }
        if (this.isSummon()) {
            L2Summon summon = (L2Summon)this;
            if (summon.getOwner() != null) {
                summon.updateAndBroadcastStatus(1);
            }
        } else {
            boolean broadcastFull = false;
            StatusUpdate su = new StatusUpdate(this);
            for (Stats stat : stats) {
                if (stat == Stats.POWER_ATTACK_SPEED) {
                    su.addAttribute(18, (int)this.getPAtkSpd());
                    continue;
                }
                if (stat == Stats.MAGIC_ATTACK_SPEED) {
                    su.addAttribute(24, this.getMAtkSpd());
                    continue;
                }
                if (stat != Stats.MOVE_SPEED) continue;
                broadcastFull = true;
            }
            if (this.isPlayer()) {
                if (broadcastFull) {
                    this.getActingPlayer().updateAndBroadcastStatus(2);
                } else {
                    this.getActingPlayer().updateAndBroadcastStatus(1);
                    if (su.hasAttributes()) {
                        this.broadcastPacket(su);
                    }
                }
                if (this.getSummon() != null && this.isAffected(EffectFlag.SERVITOR_SHARE)) {
                    this.getSummon().broadcastStatusUpdate();
                }
            } else if (this.isNpc()) {
                if (broadcastFull) {
                    Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
                    for (L2PcInstance player : plrs) {
                        if (player == null || !this.isVisibleFor(player)) continue;
                        if (this.getRunSpeed() == 0.0) {
                            player.sendPacket(new ServerObjectInfo((L2Npc)this, player));
                            continue;
                        }
                        player.sendPacket(new AbstractNpcInfo.NpcInfo((L2Npc)this, player));
                    }
                } else if (su.hasAttributes()) {
                    this.broadcastPacket(su);
                }
            } else if (su.hasAttributes()) {
                this.broadcastPacket(su);
            }
        }
    }

    public final int getXdestination() {
        MoveData m = this._move;
        if (m != null) {
            return m._xDestination;
        }
        return this.getX();
    }

    public final int getYdestination() {
        MoveData m = this._move;
        if (m != null) {
            return m._yDestination;
        }
        return this.getY();
    }

    public final int getZdestination() {
        MoveData m = this._move;
        if (m != null) {
            return m._zDestination;
        }
        return this.getZ();
    }

    public boolean isInCombat() {
        return this.hasAI() && (this.getAI().getAttackTarget() != null || this.getAI().isAutoAttacking());
    }

    public final boolean isMoving() {
        return this._move != null;
    }

    public final boolean isOnGeodataPath() {
        MoveData m = this._move;
        if (m == null) {
            return false;
        }
        if (m.onGeodataPathIndex == -1) {
            return false;
        }
        return m.onGeodataPathIndex != m.geoPath.size() - 1;
    }

    public final boolean isCastingNow() {
        return this._isCastingNow;
    }

    public void setIsCastingNow(boolean value) {
        this._isCastingNow = value;
    }

    public final boolean isCastingSimultaneouslyNow() {
        return this._isCastingSimultaneouslyNow;
    }

    public void setIsCastingSimultaneouslyNow(boolean value) {
        this._isCastingSimultaneouslyNow = value;
    }

    public final boolean canAbortCast() {
        return this._castInterruptTime > GameTimeController.getInstance().getGameTicks();
    }

    public int getCastInterruptTime() {
        return this._castInterruptTime;
    }

    public final boolean isAttackingNow() {
        return this._attackEndTime > System.nanoTime();
    }

    public final void abortAttack() {
        if (this.isAttackingNow()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
        }
    }

    public final void abortCast() {
        if (this.isCastingNow() || this.isCastingSimultaneouslyNow()) {
            Future<?> future = this._skillCast;
            if (future != null) {
                future.cancel(true);
                this._skillCast = null;
            }
            if ((future = this._skillCast2) != null) {
                future.cancel(true);
                this._skillCast2 = null;
            }
            if (this.isChanneling()) {
                this.getSkillChannelizer().stopChanneling();
            }
            if (this._allSkillsDisabled) {
                this.enableAllSkills();
            }
            this.setIsCastingNow(false);
            this.setIsCastingSimultaneouslyNow(false);
            this._castInterruptTime = 0;
            if (this.isPlayer()) {
                this.getAI().notifyEvent(CtrlEvent.EVT_FINISH_CASTING);
            }
            this.broadcastPacket(new MagicSkillCanceled(this.getObjectId()));
            this.sendPacket(ActionFailed.STATIC_PACKET);
        }
    }

    public boolean updatePosition() {
        double dz;
        boolean isFloating;
        double dy;
        double dx;
        int gameTicks;
        MoveData m = this._move;
        if (m == null) {
            return true;
        }
        if (!this.isVisible()) {
            this._move = null;
            return true;
        }
        if (m._moveTimestamp == 0) {
            m._moveTimestamp = m._moveStartTime;
            m._xAccurate = this.getX();
            m._yAccurate = this.getY();
        }
        if (m._moveTimestamp == (gameTicks = GameTimeController.getInstance().getGameTicks())) {
            return false;
        }
        int xPrev = this.getX();
        int yPrev = this.getY();
        int zPrev = this.getZ();
        if (Configuration.geodata().getCoordSynchronize() == 1) {
            dx = m._xDestination - xPrev;
            dy = m._yDestination - yPrev;
        } else {
            dx = (double)m._xDestination - m._xAccurate;
            dy = (double)m._yDestination - m._yAccurate;
        }
        boolean bl = isFloating = this.isFlying() || this.isInsideZone(ZoneId.WATER);
        if (Configuration.geodata().getCoordSynchronize() == 2 && !isFloating && !m.disregardingGeodata && GameTimeController.getInstance().getGameTicks() % 10 == 0 && GeoData.getInstance().hasGeo(xPrev, yPrev)) {
            int geoHeight = GeoData.getInstance().getSpawnHeight(xPrev, yPrev, zPrev);
            dz = m._zDestination - geoHeight;
            if (this.isPlayer() && Math.abs(this.getActingPlayer().getClientZ() - geoHeight) > 200 && Math.abs(this.getActingPlayer().getClientZ() - geoHeight) < 1500) {
                dz = m._zDestination - zPrev;
            } else if (this.isInCombat() && Math.abs(dz) > 200.0 && dx * dx + dy * dy < 40000.0) {
                dz = m._zDestination - zPrev;
            } else {
                zPrev = geoHeight;
            }
        } else {
            dz = m._zDestination - zPrev;
        }
        double delta = dx * dx + dy * dy;
        delta = delta < 10000.0 && dz * dz > 2500.0 && !isFloating ? Math.sqrt(delta) : Math.sqrt(delta + dz * dz);
        double distFraction = Double.MAX_VALUE;
        if (delta > 1.0) {
            double distPassed = this.getMoveSpeed() * (double)(gameTicks - m._moveTimestamp) / 10.0;
            distFraction = distPassed / delta;
        }
        if (distFraction > 1.0) {
            super.setXYZ(m._xDestination, m._yDestination, m._zDestination);
        } else {
            m._xAccurate += dx * distFraction;
            m._yAccurate += dy * distFraction;
            super.setXYZ((int)m._xAccurate, (int)m._yAccurate, zPrev + (int)(dz * distFraction + 0.5));
        }
        this.revalidateZone(false);
        m._moveTimestamp = gameTicks;
        if (distFraction > 1.0) {
            ThreadPoolManager.getInstance().executeAi(() -> {
                try {
                    if (Configuration.general().moveBasedKnownList()) {
                        this.getKnownList().findObjects();
                    }
                    this.getAI().notifyEvent(CtrlEvent.EVT_ARRIVED);
                }
                catch (Throwable e) {
                    LOG.warn("{}", e);
                }
            });
            return true;
        }
        return false;
    }

    public void revalidateZone(boolean force) {
        if (this.getWorldRegion() == null) {
            return;
        }
        if (force) {
            this._zoneValidateCounter = (byte)4;
        } else {
            this._zoneValidateCounter = (byte)(this._zoneValidateCounter - 1);
            if (this._zoneValidateCounter < 0) {
                this._zoneValidateCounter = (byte)4;
            } else {
                return;
            }
        }
        this.getWorldRegion().revalidateZones(this);
    }

    public void stopMove(Location loc) {
        this.stopMove(loc, false);
    }

    public void stopMove(Location loc, boolean updateKnownObjects) {
        this._move = null;
        if (loc != null) {
            this.setXYZ(loc.getX(), loc.getY(), loc.getZ());
            this.setHeading(loc.getHeading());
            this.revalidateZone(true);
        }
        this.broadcastPacket(new StopMove(this));
        if (Configuration.general().moveBasedKnownList() && updateKnownObjects) {
            this.getKnownList().findObjects();
        }
    }

    public boolean isShowSummonAnimation() {
        return this._showSummonAnimation;
    }

    public void setShowSummonAnimation(boolean showSummonAnimation) {
        this._showSummonAnimation = showSummonAnimation;
    }

    public void setTarget(L2Object object) {
        if (object != null && !object.isVisible()) {
            object = null;
        }
        if (object != null && object != this._target) {
            this.getKnownList().addKnownObject(object);
            object.getKnownList().addKnownObject(this);
        }
        this._target = object;
    }

    public final int getTargetId() {
        if (this._target != null) {
            return this._target.getObjectId();
        }
        return 0;
    }

    public final L2Object getTarget() {
        return this._target;
    }

    public void moveToLocation(int x, int y, int z, int offset) {
        double cos;
        double sin;
        boolean verticalMovementOnly;
        double speed = this.getMoveSpeed();
        if (speed <= 0.0 || this.isMovementDisabled()) {
            return;
        }
        int curX = super.getX();
        int curY = super.getY();
        int curZ = super.getZ();
        double dx = x - curX;
        double dy = y - curY;
        double dz = z - curZ;
        double distance = Math.hypot(dx, dy);
        boolean bl = verticalMovementOnly = this.isFlying() && distance == 0.0 && dz != 0.0;
        if (verticalMovementOnly) {
            distance = Math.abs(dz);
        }
        if (this.isInsideZone(ZoneId.WATER) && distance > 700.0) {
            double divider = 700.0 / distance;
            x = curX + (int)(divider * dx);
            y = curY + (int)(divider * dy);
            z = curZ + (int)(divider * dz);
            dx = x - curX;
            dy = y - curY;
            dz = z - curZ;
            distance = Math.hypot(dx, dy);
        }
        if (offset > 0 || distance < 1.0) {
            if ((offset = (int)((double)offset - Math.abs(dz))) < 5) {
                offset = 5;
            }
            if (distance < 1.0 || distance - (double)offset <= 0.0) {
                this.getAI().notifyEvent(CtrlEvent.EVT_ARRIVED);
                return;
            }
            sin = dy / distance;
            cos = dx / distance;
            x = curX + (int)((distance -= (double)(offset - 5)) * cos);
            y = curY + (int)(distance * sin);
        } else {
            sin = dy / distance;
            cos = dx / distance;
        }
        MoveData m = new MoveData();
        m.onGeodataPathIndex = -1;
        m.disregardingGeodata = false;
        if (!(this.isFlying() || this.isInsideZone(ZoneId.WATER) && !this.isInsideZone(ZoneId.SIEGE))) {
            boolean isInVehicle;
            boolean bl2 = isInVehicle = this.isPlayer() && this.getActingPlayer().getVehicle() != null;
            if (isInVehicle) {
                m.disregardingGeodata = true;
            }
            double originalDistance = distance;
            int originalX = x;
            int originalY = y;
            int originalZ = z;
            int gtx = originalX - -294912 >> 4;
            int gty = originalY - -262144 >> 4;
            if (Configuration.geodata().getPathFinding() > 0 && (!this.isAttackable() || !((L2Attackable)this).isReturningToSpawnPoint()) || this.isPlayer() && (!isInVehicle || !(distance > 1500.0)) || this instanceof L2RiftInvaderInstance) {
                if (this.isOnGeodataPath()) {
                    try {
                        if (gtx == this._move.geoPathGtx && gty == this._move.geoPathGty) {
                            return;
                        }
                        this._move.onGeodataPathIndex = -1;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                if (curX < -294912 || curX > 229376 || curY < -262144 || curY > 294912) {
                    LOG.warn("{} is outside world area, in coordinates x:{} y:{}", this, curX, curY);
                    this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                    if (this.isPlayer()) {
                        this.getActingPlayer().logout();
                    } else {
                        if (this.isSummon()) {
                            return;
                        }
                        this.onDecay();
                    }
                    return;
                }
                Location destiny = GeoData.getInstance().moveCheck(curX, curY, curZ, x, y, z, this.getInstanceId());
                x = destiny.getX();
                y = destiny.getY();
                z = destiny.getZ();
                dx = x - curX;
                dy = y - curY;
                dz = z - curZ;
                double d = distance = verticalMovementOnly ? Math.pow(dz, 2.0) : Math.hypot(dx, dy);
            }
            if (Configuration.geodata().getPathFinding() > 0 && originalDistance - distance > 30.0 && (this.isPlayable() && !isInVehicle || this.isMinion() || this.isInCombat())) {
                m.geoPath = PathFinding.getInstance().findPath(curX, curY, curZ, originalX, originalY, originalZ, this.getInstanceId(), this.isPlayable());
                if (m.geoPath == null || m.geoPath.size() < 2) {
                    if (this.isPlayer() || !this.isPlayable() && !this.isMinion() && Math.abs(z - curZ) > 140 || this.isSummon() && !((L2Summon)this).getFollowStatus()) {
                        Location destination = GeoData.getInstance().moveCheck(curX, curY, curZ, x, y, z, this.getInstanceId());
                        this.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, destination);
                        return;
                    }
                    m.disregardingGeodata = true;
                    x = originalX;
                    y = originalY;
                    z = originalZ;
                    distance = originalDistance;
                } else {
                    m.onGeodataPathIndex = 0;
                    m.geoPathGtx = gtx;
                    m.geoPathGty = gty;
                    m.geoPathAccurateTx = originalX;
                    m.geoPathAccurateTy = originalY;
                    x = m.geoPath.get(m.onGeodataPathIndex).getX();
                    y = m.geoPath.get(m.onGeodataPathIndex).getY();
                    z = m.geoPath.get(m.onGeodataPathIndex).getZ();
                    if (DoorData.getInstance().checkIfDoorsBetween(curX, curY, curZ, x, y, z, this.getInstanceId())) {
                        m.geoPath = null;
                        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                        return;
                    }
                    for (int i = 0; i < m.geoPath.size() - 1; ++i) {
                        if (!DoorData.getInstance().checkIfDoorsBetween(m.geoPath.get(i), m.geoPath.get(i + 1), this.getInstanceId())) continue;
                        m.geoPath = null;
                        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                        return;
                    }
                    dx = x - curX;
                    dy = y - curY;
                    dz = z - curZ;
                    distance = verticalMovementOnly ? Math.pow(dz, 2.0) : Math.hypot(dx, dy);
                    sin = dy / distance;
                    cos = dx / distance;
                }
            }
            if (distance < 1.0 && (Configuration.geodata().getPathFinding() > 0 || this.isPlayable() || this instanceof L2RiftInvaderInstance || this.isAfraid())) {
                if (this.isSummon()) {
                    ((L2Summon)this).setFollowStatus(false);
                }
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                return;
            }
        }
        if ((this.isFlying() || this.isInsideZone(ZoneId.WATER)) && !verticalMovementOnly) {
            distance = Math.hypot(distance, dz);
        }
        int ticksToMove = 1 + (int)(10.0 * distance / speed);
        m._xDestination = x;
        m._yDestination = y;
        m._zDestination = z;
        m._heading = 0;
        if (!verticalMovementOnly) {
            this.setHeading(Util.calculateHeadingFrom(cos, sin));
        }
        m._moveStartTime = GameTimeController.getInstance().getGameTicks();
        this._move = m;
        GameTimeController.getInstance().registerMovingObject(this);
        if (ticksToMove * 100 > 3000) {
            ThreadPoolManager.getInstance().scheduleAi(new NotifyAITask(this, CtrlEvent.EVT_ARRIVED_REVALIDATE), 2000L);
        }
    }

    public boolean moveToNextRoutePoint() {
        if (!this.isOnGeodataPath()) {
            this._move = null;
            return false;
        }
        double speed = this.getMoveSpeed();
        if (speed <= 0.0 || this.isMovementDisabled()) {
            this._move = null;
            return false;
        }
        MoveData md = this._move;
        if (md == null) {
            return false;
        }
        MoveData m = new MoveData();
        m.onGeodataPathIndex = md.onGeodataPathIndex + 1;
        m.geoPath = md.geoPath;
        m.geoPathGtx = md.geoPathGtx;
        m.geoPathGty = md.geoPathGty;
        m.geoPathAccurateTx = md.geoPathAccurateTx;
        m.geoPathAccurateTy = md.geoPathAccurateTy;
        if (md.onGeodataPathIndex == md.geoPath.size() - 2) {
            m._xDestination = md.geoPathAccurateTx;
            m._yDestination = md.geoPathAccurateTy;
            m._zDestination = md.geoPath.get(m.onGeodataPathIndex).getZ();
        } else {
            m._xDestination = md.geoPath.get(m.onGeodataPathIndex).getX();
            m._yDestination = md.geoPath.get(m.onGeodataPathIndex).getY();
            m._zDestination = md.geoPath.get(m.onGeodataPathIndex).getZ();
        }
        double distance = Math.hypot(m._xDestination - super.getX(), m._yDestination - super.getY());
        if (distance != 0.0) {
            this.setHeading(Util.calculateHeadingFrom(this.getX(), this.getY(), m._xDestination, m._yDestination));
        }
        int ticksToMove = 1 + (int)(10.0 * distance / speed);
        m._heading = 0;
        m._moveStartTime = GameTimeController.getInstance().getGameTicks();
        this._move = m;
        GameTimeController.getInstance().registerMovingObject(this);
        if (ticksToMove * 100 > 3000) {
            ThreadPoolManager.getInstance().scheduleAi(new NotifyAITask(this, CtrlEvent.EVT_ARRIVED_REVALIDATE), 2000L);
        }
        MoveToLocation msg = new MoveToLocation(this);
        this.broadcastPacket(msg);
        return true;
    }

    public boolean validateMovementHeading(int heading) {
        MoveData m = this._move;
        if (m == null) {
            return true;
        }
        boolean result = true;
        if (m._heading != heading) {
            result = m._heading == 0;
            m._heading = heading;
        }
        return result;
    }

    public final boolean isInsideRadius(ILocational loc, int radius, boolean checkZAxis, boolean strictCheck) {
        return this.isInsideRadius(loc.getX(), loc.getY(), loc.getZ(), radius, checkZAxis, strictCheck);
    }

    public final boolean isInsideRadius(int x, int y, int z, int radius, boolean checkZAxis, boolean strictCheck) {
        double distance = this.calculateDistance(x, y, z, checkZAxis, true);
        return strictCheck ? distance < (double)(radius * radius) : distance <= (double)(radius * radius);
    }

    protected boolean checkAndEquipArrows() {
        return true;
    }

    protected boolean checkAndEquipBolts() {
        return true;
    }

    public void addExpAndSp(long addToExp, int addToSp) {
    }

    public abstract L2ItemInstance getActiveWeaponInstance();

    public abstract L2Weapon getActiveWeaponItem();

    public abstract L2ItemInstance getSecondaryWeaponInstance();

    public abstract L2Item getSecondaryWeaponItem();

    public void onHitTimer(L2Character target, int damage, boolean crit, boolean miss, boolean soulshot, byte shld) {
        if (target == null || this.isAlikeDead() || this.isNpc() && ((L2Npc)this).isEventMob()) {
            this.getAI().notifyEvent(CtrlEvent.EVT_CANCEL);
            return;
        }
        if (this.isStunned() || this.isSleeping() || this.isAfraid() || this.isPhysicalAttackMuted()) {
            this.getAI().notifyEvent(CtrlEvent.EVT_CANCEL);
            return;
        }
        if (this.isNpc() && target.isAlikeDead() || target.isDead() || !this.getKnownList().knowsObject(target) && !this.isDoor()) {
            this.rechargeShots(true, false);
            this.getAI().notifyEvent(CtrlEvent.EVT_CANCEL);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (miss) {
            if (target.hasAI()) {
                target.getAI().notifyEvent(CtrlEvent.EVT_EVADED, (Object)this);
            }
            this.notifyAttackAvoid(target, false);
        }
        this.sendDamageMessage(target, damage, false, crit, miss);
        if (target.isRaid() && target.giveRaidCurse() && Configuration.npc().raidCurse() && this.getLevel() > target.getLevel() + 8) {
            Skill skill = CommonSkill.RAID_CURSE2.getSkill();
            if (skill != null) {
                this.abortAttack();
                this.abortCast();
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                skill.applyEffects(target, this);
            } else {
                LOG.warn("Skill 4515 at level 1 is missing in DP.");
            }
            damage = 0;
        }
        if (target.isPlayer()) {
            L2PcInstance enemy = target.getActingPlayer();
            enemy.getAI().clientStartAutoAttack();
        }
        if (!miss && damage > 0) {
            L2PcInstance owner;
            double reflectPercent;
            L2Weapon weapon = this.getActiveWeaponItem();
            boolean isBow = weapon != null && (weapon.getItemType() == WeaponType.BOW || weapon.getItemType() == WeaponType.CROSSBOW);
            int reflectedDamage = 0;
            if (!(isBow || target.isInvul() || target.isRaid() && this.getActingPlayer() != null && this.getActingPlayer().getLevel() > target.getLevel() + 8 || !((reflectPercent = target.getStat().calcStat(Stats.REFLECT_DAMAGE_PERCENT, 0.0, null, null)) > 0.0) || (reflectedDamage = (int)(reflectPercent / 100.0 * (double)damage)) <= target.getMaxHp())) {
                reflectedDamage = target.getMaxHp();
            }
            target.reduceCurrentHp(damage, this, null);
            target.notifyDamageReceived(damage, this, null, crit, false, false);
            if (reflectedDamage > 0) {
                if (target.isPlayable()) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_DONE_S3_DAMAGE_TO_C2);
                    ((SystemMessage)((Object)((SystemMessage)((Object)sm.addCharName(target))).addCharName(this))).addInt(reflectedDamage);
                    target.sendPacket(sm);
                }
                if (this.isSummon()) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_RECEIVED_DAMAGE_OF_S3_FROM_C2);
                    ((SystemMessage)((Object)((SystemMessage)((Object)sm.addCharName(this))).addCharName(target))).addInt(reflectedDamage);
                    this.getActingPlayer().sendPacket(sm);
                }
                this.reduceCurrentHp(reflectedDamage, target, true, false, null);
                this.notifyDamageReceived(reflectedDamage, target, null, crit, false, true);
            }
            if (!isBow) {
                int maxCanAbsorb;
                int absorbDamage;
                double absorbPercent = this.getStat().calcStat(Stats.ABSORB_DAMAGE_PERCENT, 0.0, null, null);
                if (absorbPercent > 0.0) {
                    absorbDamage = (int)(absorbPercent / 100.0 * (double)damage);
                    maxCanAbsorb = (int)((double)this.getMaxRecoverableHp() - this.getCurrentHp());
                    if (absorbDamage > maxCanAbsorb) {
                        absorbDamage = maxCanAbsorb;
                    }
                    if (absorbDamage > 0) {
                        this.setCurrentHp(this.getCurrentHp() + (double)absorbDamage);
                    }
                }
                if ((absorbPercent = this.getStat().calcStat(Stats.ABSORB_MANA_DAMAGE_PERCENT, 0.0, null, null)) > 0.0) {
                    absorbDamage = (int)(absorbPercent / 100.0 * (double)damage);
                    maxCanAbsorb = (int)((double)this.getMaxRecoverableMp() - this.getCurrentMp());
                    if (absorbDamage > maxCanAbsorb) {
                        absorbDamage = maxCanAbsorb;
                    }
                    if (absorbDamage > 0) {
                        this.setCurrentMp(this.getCurrentMp() + (double)absorbDamage);
                    }
                }
            }
            if (target.hasAI()) {
                target.getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, (Object)this);
            }
            this.getAI().clientStartAutoAttack();
            if (this.isSummon() && (owner = ((L2Summon)this).getOwner()) != null) {
                owner.getAI().clientStartAutoAttack();
            }
            if (!target.isRaid() && Formulas.calcAtkBreak(target, damage)) {
                target.breakAttack();
                target.breakCast();
            }
            if (this._triggerSkills != null) {
                for (OptionsSkillHolder holder : this._triggerSkills.values()) {
                    if ((crit || holder.getSkillType() != OptionsSkillType.ATTACK) && (holder.getSkillType() != OptionsSkillType.CRITICAL || !crit) || !((double)Rnd.get((int)100) < holder.getChance())) continue;
                    this.makeTriggerCast(holder.getSkill(), target);
                }
            }
            if (crit && weapon != null) {
                weapon.castOnCriticalSkill(this, target);
            }
        }
        this.rechargeShots(true, false);
    }

    public void breakAttack() {
        if (this.isAttackingNow()) {
            this.abortAttack();
            if (this.isPlayer()) {
                this.sendPacket(SystemMessageId.ATTACK_FAILED);
            }
        }
    }

    public void breakCast() {
        if (this.isCastingNow() && this.canAbortCast() && this.getLastSkillCast() != null && (this.getLastSkillCast().isMagic() || this.getLastSkillCast().isStatic())) {
            this.abortCast();
            if (this.isPlayer()) {
                this.sendPacket(SystemMessageId.CASTING_INTERRUPTED);
            }
        }
    }

    protected void reduceArrowCount(boolean bolts) {
    }

    @Override
    public void onForcedAttack(L2PcInstance player) {
        if (this.isInsidePeaceZone(player)) {
            player.sendPacket(SystemMessageId.TARGET_IN_PEACEZONE);
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (player.isInOlympiadMode() && player.getTarget() != null && player.getTarget().isPlayable()) {
            L2PcInstance target = null;
            L2Object object = player.getTarget();
            if (object != null && object.isPlayable()) {
                target = object.getActingPlayer();
            }
            if (target == null || target.isInOlympiadMode() && (!player.isOlympiadStart() || player.getOlympiadGameId() != target.getOlympiadGameId())) {
                player.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
        }
        if (player.getTarget() != null && !player.getTarget().canBeAttacked() && !player.getAccessLevel().allowPeaceAttack()) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (player.isConfused()) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!GeoData.getInstance().canSeeTarget((L2Object)player, this)) {
            player.sendPacket(SystemMessageId.CANT_SEE_TARGET);
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (player.getBlockCheckerArena() != -1) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
    }

    public boolean isInsidePeaceZone(L2PcInstance attacker) {
        return this.isInsidePeaceZone(attacker, (L2Object)this);
    }

    public boolean isInsidePeaceZone(L2PcInstance attacker, L2Object target) {
        return !attacker.getAccessLevel().allowPeaceAttack() && this.isInsidePeaceZone((L2Object)attacker, target);
    }

    public boolean isInsidePeaceZone(L2Object attacker, L2Object target) {
        if (target == null) {
            return false;
        }
        if (!target.isPlayable() || !attacker.isPlayable()) {
            return false;
        }
        if (InstanceManager.getInstance().getInstance(this.getInstanceId()).isPvPInstance()) {
            return false;
        }
        if (Configuration.territoryWar().playerWithWardCanBeKilledInPeaceZone() && TerritoryWarManager.getInstance().isTWInProgress() && target.isPlayer() && target.getActingPlayer().isCombatFlagEquipped()) {
            return false;
        }
        if (Configuration.character().karmaPlayerCanBeKilledInPeaceZone()) {
            if (target.getActingPlayer() != null && target.getActingPlayer().getKarma() > 0) {
                return false;
            }
            if (attacker.getActingPlayer() != null && attacker.getActingPlayer().getKarma() > 0 && target.getActingPlayer() != null && target.getActingPlayer().getPvpFlag() > 0) {
                return false;
            }
        }
        return target.isInsideZone(ZoneId.PEACE) || attacker.isInsideZone(ZoneId.PEACE);
    }

    public boolean isInActiveRegion() {
        L2WorldRegion region = this.getWorldRegion();
        return region != null && region.isActive();
    }

    public boolean isInParty() {
        return false;
    }

    public L2Party getParty() {
        return null;
    }

    public int calculateTimeBetweenAttacks() {
        return (int)(500000.0 / this.getPAtkSpd());
    }

    public int calculateReuseTime(L2Weapon weapon) {
        if (this.isTransformed()) {
            switch (this.getAttackType()) {
                case BOW: {
                    return (int)(499500.0 * this.getStat().getWeaponReuseModifier(null) / this.getStat().getPAtkSpd());
                }
                case CROSSBOW: {
                    return (int)(399600.0 * this.getStat().getWeaponReuseModifier(null) / this.getStat().getPAtkSpd());
                }
            }
        }
        if (weapon == null || weapon.getReuseDelay() == 0) {
            return 0;
        }
        return (int)((double)(weapon.getReuseDelay() * 333) / this.getPAtkSpd());
    }

    @Override
    public Skill addSkill(Skill newSkill) {
        Skill oldSkill = null;
        if (newSkill != null) {
            oldSkill = this._skills.put(newSkill.getId(), newSkill);
            if (oldSkill != null) {
                this.removeStatsOwner(oldSkill);
                if (oldSkill.isPassive()) {
                    this.stopSkillEffects(false, oldSkill.getId());
                }
            }
            this.addStatFuncs(newSkill.getStatFuncs(null, this));
            if (newSkill.isPassive()) {
                newSkill.applyEffects(this, this, -1, false, true, false, 0);
            }
        }
        return oldSkill;
    }

    public Skill removeSkill(Skill skill, boolean cancelEffect) {
        return skill != null ? this.removeSkill(skill.getId(), cancelEffect) : null;
    }

    public Skill removeSkill(int skillId) {
        return this.removeSkill(skillId, true);
    }

    public Skill removeSkill(int skillId, boolean cancelEffect) {
        Skill oldSkill = this._skills.remove(skillId);
        if (oldSkill != null) {
            if (this.getLastSkillCast() != null && this.isCastingNow() && oldSkill.getId() == this.getLastSkillCast().getId()) {
                this.abortCast();
            }
            if (this.getLastSimultaneousSkillCast() != null && this.isCastingSimultaneouslyNow() && oldSkill.getId() == this.getLastSimultaneousSkillCast().getId()) {
                this.abortCast();
            }
            if (cancelEffect || oldSkill.isToggle() || oldSkill.isPassive()) {
                this.removeStatsOwner(oldSkill);
                this.stopSkillEffects(false, oldSkill.getId());
            }
        }
        return oldSkill;
    }

    public final Collection<Skill> getAllSkills() {
        return this._skills.values();
    }

    @Override
    public Map<Integer, Skill> getSkills() {
        return this._skills;
    }

    @Override
    public int getSkillLevel(int skillId) {
        Skill skill = this.getKnownSkill(skillId);
        return skill == null ? -1 : skill.getLevel();
    }

    @Override
    public final Skill getKnownSkill(int skillId) {
        return this._skills.get(skillId);
    }

    public int getBuffCount() {
        return this._effectList.getBuffCount();
    }

    public int getDanceCount() {
        return this._effectList.getDanceCount();
    }

    public void onMagicLaunchedTimer(MagicUseTask mut) {
        Skill skill = mut.getSkill();
        int escapeRange = 0;
        if (skill.getEffectRange() > escapeRange) {
            escapeRange = skill.getEffectRange();
        } else if (skill.getCastRange() < 0 && skill.getAffectRange() > 80) {
            escapeRange = skill.getAffectRange();
        }
        List<L2Object> targets = mut.getTargets();
        if (!targets.isEmpty() && escapeRange > 0) {
            int skipRange = 0;
            int skipLOS = 0;
            int skipPeaceZone = 0;
            ArrayList<L2Object> targetList = new ArrayList<L2Object>();
            for (L2Object target : targets) {
                if (!(target instanceof L2Character)) continue;
                L2Character creature = (L2Character)target;
                if (!this.isInsideRadius(target.getX(), target.getY(), target.getZ(), escapeRange + this.getTemplate().getCollisionRadius(), true, false)) {
                    ++skipRange;
                    continue;
                }
                if (!(skill.getAffectScope() == AffectScope.PARTY && skill.hasEffectType(L2EffectType.HP, new L2EffectType[0]) || GeoData.getInstance().canSeeTarget((L2Object)this, target))) {
                    ++skipLOS;
                    continue;
                }
                if (skill.isBad()) {
                    if (this.isPlayer()) {
                        if (creature.isInsidePeaceZone(this.getActingPlayer())) {
                            ++skipPeaceZone;
                            continue;
                        }
                    } else if (creature.isInsidePeaceZone(this, target)) {
                        ++skipPeaceZone;
                        continue;
                    }
                }
                targetList.add(target);
            }
            if (targetList.isEmpty()) {
                if (this.isPlayer()) {
                    if (skipRange > 0) {
                        this.sendPacket(SystemMessageId.DIST_TOO_FAR_CASTING_STOPPED);
                    } else if (skipLOS > 0) {
                        this.sendPacket(SystemMessageId.CANT_SEE_TARGET);
                    } else if (skipPeaceZone > 0) {
                        this.sendPacket(SystemMessageId.A_MALICIOUS_SKILL_CANNOT_BE_USED_IN_PEACE_ZONE);
                    }
                }
                this.abortCast();
                return;
            }
            mut.setTargets(targetList);
        }
        if (mut.isSimultaneous() && !this.isCastingSimultaneouslyNow() || !mut.isSimultaneous() && !this.isCastingNow() || this.isAlikeDead() && !skill.isStatic()) {
            this.getAI().notifyEvent(CtrlEvent.EVT_CANCEL);
            return;
        }
        if (!skill.isToggle()) {
            this.broadcastPacket(new MagicSkillLaunched(this, skill.getDisplayId(), skill.getDisplayLevel(), targets));
        }
        mut.setPhase(2);
        if (mut.getSkillTime() == 0) {
            this.onMagicHitTimer(mut);
        } else {
            this._skillCast = ThreadPoolManager.getInstance().scheduleEffect(mut, 400L);
        }
    }

    public void onMagicHitTimer(MagicUseTask mut) {
        Skill skill = mut.getSkill();
        List<L2Object> targets = mut.getTargets();
        if (skill == null || targets == null) {
            this.abortCast();
            return;
        }
        for (L2Object tgt : targets) {
            if (tgt.isPlayable()) {
                if (!this.isPlayer() || !tgt.isSummon()) continue;
                ((L2Summon)tgt).updateAndBroadcastStatus(1);
                continue;
            }
            if (!this.isPlayable() || !tgt.isAttackable()) continue;
            L2Character target = (L2Character)tgt;
            if (skill.getEffectPoint() > 0) {
                ((L2Attackable)target).reduceHate(this, skill.getEffectPoint());
                continue;
            }
            if (skill.getEffectPoint() >= 0) continue;
            ((L2Attackable)target).addDamageHate(this, 0, -skill.getEffectPoint());
        }
        this.rechargeShots(skill.useSoulShot(), skill.useSpiritShot());
        StatusUpdate su = new StatusUpdate(this);
        boolean isSendStatus = false;
        double mpConsume2 = this.getStat().getMpConsume2(skill);
        if (mpConsume2 > 0.0) {
            if (mpConsume2 > this.getCurrentMp()) {
                this.sendPacket(SystemMessageId.NOT_ENOUGH_MP);
                this.abortCast();
                return;
            }
            this.getStatus().reduceMp(mpConsume2);
            su.addAttribute(11, (int)this.getCurrentMp());
            isSendStatus = true;
        }
        if (skill.getHpConsume() > 0) {
            double consumeHp = skill.getHpConsume();
            if (consumeHp >= this.getCurrentHp()) {
                this.sendPacket(SystemMessageId.NOT_ENOUGH_HP);
                this.abortCast();
                return;
            }
            this.getStatus().reduceHp(consumeHp, this, true);
            su.addAttribute(9, (int)this.getCurrentHp());
            isSendStatus = true;
        }
        if (isSendStatus) {
            this.sendPacket(su);
        }
        if (this.isPlayer() && skill.getChargeConsume() > 0) {
            this.getActingPlayer().decreaseCharges(skill.getChargeConsume());
        }
        this.callSkill(mut.getSkill(), mut.getTargets());
        if (mut.getSkillTime() > 0) {
            mut.setCount(mut.getCount() + 1);
        }
        mut.setPhase(3);
        if (mut.getSkillTime() == 0) {
            this.onMagicFinalizer(mut);
        } else if (mut.isSimultaneous()) {
            this._skillCast2 = ThreadPoolManager.getInstance().scheduleEffect(mut, 0L);
        } else {
            this._skillCast = ThreadPoolManager.getInstance().scheduleEffect(mut, 0L);
        }
    }

    public void onMagicFinalizer(MagicUseTask mut) {
        L2Object target;
        if (mut.isSimultaneous()) {
            this._skillCast2 = null;
            this.setIsCastingSimultaneouslyNow(false);
            return;
        }
        this._skillCast = null;
        this._castInterruptTime = 0;
        this.setIsCastingNow(false);
        this.setIsCastingSimultaneouslyNow(false);
        L2PcInstance player = this.getActingPlayer();
        Skill skill = mut.getSkill();
        L2Object l2Object = target = !mut.getTargets().isEmpty() ? mut.getTargets().get(0) : null;
        if (mut.getCount() > 0) {
            this.rechargeShots(mut.getSkill().useSoulShot(), mut.getSkill().useSpiritShot());
        }
        if (skill.nextActionIsAttack() && this.getTarget() instanceof L2Character && this.getTarget() != this && target != null && this.getTarget() == target && target.canBeAttacked() && (this.getAI().getNextIntention() == null || this.getAI().getNextIntention().getCtrlIntention() != CtrlIntention.AI_INTENTION_MOVE_TO)) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, target);
        }
        if (skill.isBad() && skill.getTargetType() != TargetType.DOOR_TREASURE) {
            this.getAI().clientStartAutoAttack();
        }
        this.getAI().notifyEvent(CtrlEvent.EVT_FINISH_CASTING);
        this.notifyQuestEventSkillFinished(skill, target);
        if (this.isPlayer()) {
            SkillUseHolder queuedSkill = player.getQueuedSkill();
            player.setCurrentSkill(null, false, false);
            if (queuedSkill != null) {
                player.setQueuedSkill(null, false, false);
                ThreadPoolManager.getInstance().executeGeneral(new QueuedMagicUseTask(player, queuedSkill.getSkill(), queuedSkill.isCtrlPressed(), queuedSkill.isShiftPressed()));
            }
        }
        if (this.isChanneling()) {
            this.getSkillChannelizer().stopChanneling();
        }
    }

    protected void notifyQuestEventSkillFinished(Skill skill, L2Object target) {
    }

    public void callSkill(Skill skill, List<L2Object> targets) {
        try {
            L2Character creature;
            L2Weapon activeWeapon = this.getActiveWeaponItem();
            if (skill.isToggle() && this.isAffectedBySkill(skill.getId())) {
                return;
            }
            for (L2Object l2Object : targets) {
                if (l2Object == null || !l2Object.isCharacter()) continue;
                L2Character l2Character = (L2Character)l2Object;
                L2Character targetsAttackTarget = null;
                L2Character targetsCastTarget = null;
                if (l2Character.hasAI()) {
                    targetsAttackTarget = l2Character.getAI().getAttackTarget();
                    targetsCastTarget = l2Character.getAI().getCastTarget();
                }
                if (Configuration.npc().raidCurse() && (l2Character.isRaid() && l2Character.giveRaidCurse() && this.getLevel() > l2Character.getLevel() + 8 || !skill.isBad() && targetsAttackTarget != null && targetsAttackTarget.isRaid() && targetsAttackTarget.giveRaidCurse() && targetsAttackTarget.getAttackByList().contains(l2Character) && this.getLevel() > targetsAttackTarget.getLevel() + 8 || !skill.isBad() && targetsCastTarget != null && targetsCastTarget.isRaid() && targetsCastTarget.giveRaidCurse() && targetsCastTarget.getAttackByList().contains(l2Character) && this.getLevel() > targetsCastTarget.getLevel() + 8)) {
                    Object curse = skill.isMagic() ? CommonSkill.RAID_CURSE : CommonSkill.RAID_CURSE2;
                    Skill curseSkill = ((CommonSkill)((Object)curse)).getSkill();
                    if (curseSkill != null) {
                        this.abortAttack();
                        this.abortCast();
                        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                        curseSkill.applyEffects(l2Character, this);
                    } else {
                        LOG.warn("Skill ID {} level {} is missing in DP!", (Object)((CommonSkill)((Object)curse)).getId(), (Object)((CommonSkill)((Object)curse)).getLevel());
                    }
                    return;
                }
                if (skill.isOverhit() && l2Character.isAttackable()) {
                    ((L2Attackable)l2Character).overhitEnabled(true);
                }
                if (skill.isStatic()) continue;
                if (activeWeapon != null && !l2Character.isDead()) {
                    activeWeapon.castOnMagicSkill(this, l2Character, skill);
                }
                if (this._triggerSkills == null) continue;
                for (OptionsSkillHolder holder : this._triggerSkills.values()) {
                    if ((!skill.isMagic() || holder.getSkillType() != OptionsSkillType.MAGIC) && (!skill.isPhysical() || holder.getSkillType() != OptionsSkillType.ATTACK) || !((double)Rnd.get((int)100) < holder.getChance())) continue;
                    this.makeTriggerCast(holder.getSkill(), l2Character);
                }
            }
            skill.activateSkill(this, targets);
            L2PcInstance player = this.getActingPlayer();
            if (player != null) {
                for (L2Object l2Object : targets) {
                    if (!(l2Object instanceof L2Character)) continue;
                    creature = (L2Character)l2Object;
                    if (skill.getEffectPoint() <= 0) {
                        if (l2Object.isPlayable() || l2Object.isTrap()) {
                            if (!l2Object.equals(this)) {
                                L2PcInstance owner;
                                if (l2Object.isPlayer()) {
                                    l2Object.getActingPlayer().getAI().clientStartAutoAttack();
                                } else if (l2Object.isSummon() && creature.hasAI() && (owner = ((L2Summon)l2Object).getOwner()) != null) {
                                    owner.getAI().clientStartAutoAttack();
                                }
                                if (player.getSummon() != l2Object && !this.isTrap() && skill.isBad()) {
                                    player.updatePvPStatus(creature);
                                }
                            }
                        } else if (l2Object.isAttackable()) {
                            switch (skill.getId()) {
                                case 51: 
                                case 511: {
                                    break;
                                }
                                default: {
                                    creature.addAttackerToAttackByList(this);
                                }
                            }
                        }
                        if (!creature.hasAI() || skill.hasEffectType(L2EffectType.HATE, new L2EffectType[0])) continue;
                        creature.getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, (Object)this);
                        continue;
                    }
                    if (l2Object.isPlayer()) {
                        if (l2Object.equals(this) || l2Object.equals(player) || l2Object.getActingPlayer().getPvpFlag() <= 0 && l2Object.getActingPlayer().getKarma() <= 0) continue;
                        player.updatePvPStatus();
                        continue;
                    }
                    if (!l2Object.isAttackable()) continue;
                    player.updatePvPStatus();
                }
                Collection<L2Object> collection = player.getKnownList().getKnownObjects().values();
                for (L2Object spMob : collection) {
                    L2Npc npcMob;
                    if (spMob == null || !spMob.isNpc() || !(npcMob = (L2Npc)spMob).isInsideRadius(player, 1000, true, true)) continue;
                    EventDispatcher.getInstance().notifyEventAsync(new NpcSkillSee(npcMob, player, skill, targets, this.isSummon()), npcMob);
                    if (!npcMob.isAttackable()) continue;
                    L2Attackable attackable = (L2Attackable)npcMob;
                    int skillEffectPoint = skill.getEffectPoint();
                    if (player.hasSummon() && targets.size() == 1 && targets.contains(player.getSummon())) {
                        skillEffectPoint = 0;
                    }
                    if (skillEffectPoint <= 0 || !attackable.hasAI() || attackable.getAI().getIntention() != CtrlIntention.AI_INTENTION_ATTACK) continue;
                    L2Object npcTarget = attackable.getTarget();
                    for (L2Object skillTarget : targets) {
                        if (npcTarget != skillTarget && npcMob != skillTarget) continue;
                        L2Playable originalCaster = this.isSummon() ? this.getSummon() : player;
                        attackable.addDamageHate(originalCaster, 0, skillEffectPoint * 150 / (attackable.getLevel() + 7));
                    }
                }
            }
            if (skill.isBad() && !skill.hasEffectType(L2EffectType.HATE, new L2EffectType[0])) {
                for (L2Object l2Object : targets) {
                    if (!l2Object.isCharacter() || !(creature = (L2Character)l2Object).hasAI()) continue;
                    creature.getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, (Object)this);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("callSkill() failed. skill={} actor(id={}, name={})", skill.getId(), this.getObjectId(), this.getName(), e);
        }
    }

    public boolean isBehind(L2Object target) {
        double maxAngleDiff = 60.0;
        if (target instanceof L2Character) {
            double angleTarget;
            L2Character creature = (L2Character)target;
            double angleChar = Util.calculateAngleFrom(this, creature);
            double angleDiff = angleChar - (angleTarget = Util.convertHeadingToDegree(creature.getHeading()));
            if (angleDiff <= -360.0 + maxAngleDiff) {
                angleDiff += 360.0;
            }
            if (angleDiff >= 360.0 - maxAngleDiff) {
                angleDiff -= 360.0;
            }
            return Math.abs(angleDiff) <= maxAngleDiff;
        }
        return false;
    }

    public boolean isBehindTarget() {
        return this.isBehind(this.getTarget());
    }

    public boolean isInFrontOf(L2Character target) {
        double maxAngleDiff = 60.0;
        if (target == null) {
            return false;
        }
        double angleTarget = Util.calculateAngleFrom(target, this);
        double angleChar = Util.convertHeadingToDegree(target.getHeading());
        double angleDiff = angleChar - angleTarget;
        if (angleDiff <= -360.0 + maxAngleDiff) {
            angleDiff += 360.0;
        }
        if (angleDiff >= 360.0 - maxAngleDiff) {
            angleDiff -= 360.0;
        }
        return Math.abs(angleDiff) <= maxAngleDiff;
    }

    public boolean isFacing(L2Object target, int maxAngle) {
        if (target == null) {
            return false;
        }
        double maxAngleDiff = (double)maxAngle / 2.0;
        double angleTarget = Util.calculateAngleFrom(this, target);
        double angleChar = Util.convertHeadingToDegree(this.getHeading());
        double angleDiff = angleChar - angleTarget;
        if (angleDiff <= -360.0 + maxAngleDiff) {
            angleDiff += 360.0;
        }
        if (angleDiff >= 360.0 - maxAngleDiff) {
            angleDiff -= 360.0;
        }
        return Math.abs(angleDiff) <= maxAngleDiff;
    }

    public boolean isInFrontOfTarget() {
        L2Object target = this.getTarget();
        if (target instanceof L2Character) {
            L2Character creature = (L2Character)target;
            return this.isInFrontOf(creature);
        }
        return false;
    }

    public double getLevelMod() {
        return (double)(this.getLevel() + 89) / 100.0;
    }

    public final void setSkillCast(Future<?> newSkillCast) {
        this._skillCast = newSkillCast;
    }

    public final void forceIsCasting(int newSkillCastEndTick) {
        this.setIsCastingNow(true);
        this._castInterruptTime = newSkillCastEndTick - 4;
    }

    public void updatePvPFlag(int value) {
    }

    public final double getRandomDamageMultiplier() {
        L2Weapon activeWeapon = this.getActiveWeaponItem();
        int random = activeWeapon != null ? activeWeapon.getRandomDamage() : 5 + (int)Math.sqrt(this.getLevel());
        return 1.0 + (double)Rnd.get((int)(0 - random), (int)random) / 100.0;
    }

    public final long getAttackEndTime() {
        return this._attackEndTime;
    }

    public abstract int getLevel();

    public int getMinLevel() {
        return 1;
    }

    public final double calcStat(Stats stat, double init) {
        return this.getStat().calcStat(stat, init, null, null);
    }

    public final double calcStat(Stats stat, double init, L2Character target, Skill skill) {
        return this.getStat().calcStat(stat, init, target, skill);
    }

    public int getAccuracy() {
        return this.getStat().getAccuracy();
    }

    public final float getAttackSpeedMultiplier() {
        return this.getStat().getAttackSpeedMultiplier();
    }

    public final double getCriticalDmg(L2Character target, double init) {
        return this.getStat().getCriticalDmg(target, init);
    }

    public int getCriticalHit(L2Character target, Skill skill) {
        return this.getStat().getCriticalHit(target, skill);
    }

    public int getEvasionRate(L2Character target) {
        return this.getStat().getEvasionRate(target);
    }

    public final int getMagicalAttackRange(Skill skill) {
        return this.getStat().getMagicalAttackRange(skill);
    }

    public final int getMaxCp() {
        return this.getStat().getMaxCp();
    }

    public final int getMaxRecoverableCp() {
        return this.getStat().getMaxRecoverableCp();
    }

    public double getMAtk(L2Character target, Skill skill) {
        return this.getStat().getMAtk(target, skill);
    }

    public int getMAtkSpd() {
        return this.getStat().getMAtkSpd();
    }

    public int getMaxMp() {
        return this.getStat().getMaxMp();
    }

    public int getMaxRecoverableMp() {
        return this.getStat().getMaxRecoverableMp();
    }

    public int getMaxHp() {
        return Configuration.customs().championEnable() && this.isChampion() ? this.getStat().getMaxHp() * Configuration.customs().getChampionHp() : this.getStat().getMaxHp();
    }

    public int getMaxRecoverableHp() {
        return this.getStat().getMaxRecoverableHp();
    }

    public final int getMCriticalHit(L2Character target, Skill skill) {
        return this.getStat().getMCriticalHit(target, skill);
    }

    public double getMDef(L2Character target, Skill skill) {
        return this.getStat().getMDef(target, skill);
    }

    public double getMReuseRate(Skill skill) {
        return this.getStat().getMReuseRate(skill);
    }

    public double getPAtk(L2Character target) {
        return this.getStat().getPAtk(target);
    }

    public double getPAtkSpd() {
        return this.getStat().getPAtkSpd();
    }

    public double getPDef(L2Character target) {
        return this.getStat().getPDef(target);
    }

    public final int getPhysicalAttackRange() {
        return this.getStat().getPhysicalAttackRange();
    }

    public double getMovementSpeedMultiplier() {
        return this.getStat().getMovementSpeedMultiplier();
    }

    public double getRunSpeed() {
        return this.getStat().getRunSpeed();
    }

    public double getWalkSpeed() {
        return this.getStat().getWalkSpeed();
    }

    public final double getSwimRunSpeed() {
        return this.getStat().getSwimRunSpeed();
    }

    public final double getSwimWalkSpeed() {
        return this.getStat().getSwimWalkSpeed();
    }

    public double getMoveSpeed() {
        return this.getStat().getMoveSpeed();
    }

    public final int getShldDef() {
        return this.getStat().getShldDef();
    }

    public int getSTR() {
        return this.getStat().getSTR();
    }

    public int getDEX() {
        return this.getStat().getDEX();
    }

    public int getCON() {
        return this.getStat().getCON();
    }

    public int getINT() {
        return this.getStat().getINT();
    }

    public int getWIT() {
        return this.getStat().getWIT();
    }

    public int getMEN() {
        return this.getStat().getMEN();
    }

    public void addStatusListener(L2Character object) {
        this.getStatus().addStatusListener(object);
    }

    public void reduceCurrentHp(double damage, L2Character attacker, Skill skill) {
        this.reduceCurrentHp(damage, attacker, true, false, skill);
    }

    public void reduceCurrentHpByDOT(double damage, L2Character attacker, Skill skill) {
        this.reduceCurrentHp(damage, attacker, !skill.isToggle(), true, skill);
    }

    public void reduceCurrentHp(double damage, L2Character attacker, boolean awake, boolean isDOT, Skill skill) {
        this.getStatus().reduceHp(damage, attacker, awake, isDOT, false);
    }

    public void reduceCurrentMp(double damage) {
        this.getStatus().reduceMp(damage);
    }

    @Override
    public void removeStatusListener(L2Character object) {
        this.getStatus().removeStatusListener(object);
    }

    public void stopHpMpRegeneration() {
        this.getStatus().stopHpMpRegeneration();
    }

    public final double getCurrentCp() {
        return this.getStatus().getCurrentCp();
    }

    public final void setCurrentCp(double newCp) {
        this.getStatus().setCurrentCp(newCp);
    }

    public final double getCurrentHp() {
        return this.getStatus().getCurrentHp();
    }

    public final void setCurrentHp(double newHp) {
        this.getStatus().setCurrentHp(newHp);
    }

    public final int getHpPercentage() {
        return (int)(this.getCurrentHp() / (double)this.getMaxHp() * 100.0);
    }

    public final int getMpPercentage() {
        return (int)(this.getCurrentMp() / (double)this.getMaxMp() * 100.0);
    }

    public final void setCurrentHpMp(double newHp, double newMp) {
        this.getStatus().setCurrentHpMp(newHp, newMp);
    }

    public final double getCurrentMp() {
        return this.getStatus().getCurrentMp();
    }

    public final void setCurrentMp(double newMp) {
        this.getStatus().setCurrentMp(newMp);
    }

    public int getMaxLoad() {
        return 0;
    }

    public int getBonusWeightPenalty() {
        return 0;
    }

    public int getCurrentLoad() {
        return 0;
    }

    public boolean isChampion() {
        return false;
    }

    public void sendDamageMessage(L2Character target, int damage, boolean mcrit, boolean pcrit, boolean miss) {
        if (miss && target.isPlayer()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_EVADED_C2_ATTACK);
            sm.addPcName(target.getActingPlayer());
            sm.addCharName(this);
            target.sendPacket(sm);
        }
    }

    public byte getAttackElement() {
        return this.getStat().getAttackElement();
    }

    public int getAttackElementValue(byte attackAttribute) {
        return this.getStat().getAttackElementValue(attackAttribute);
    }

    public int getDefenseElementValue(byte defenseAttribute) {
        return this.getStat().getDefenseElementValue(defenseAttribute);
    }

    public final void startPhysicalAttackMuted() {
        this.abortAttack();
    }

    public void disableCoreAI(boolean val) {
        this._AIdisabled = val;
    }

    public boolean isCoreAIDisabled() {
        return this._AIdisabled;
    }

    public boolean giveRaidCurse() {
        return true;
    }

    public boolean isAffected(EffectFlag flag) {
        return this._effectList.isAffected(flag);
    }

    public void broadcastSocialAction(int id) {
        this.broadcastPacket(new SocialAction(this.getObjectId(), id));
    }

    public Team getTeam() {
        return this._team;
    }

    public void setTeam(Team team) {
        this._team = team;
    }

    public void addOverrideCond(PcCondOverride ... excs) {
        for (PcCondOverride exc : excs) {
            this._exceptions |= (long)exc.getMask();
        }
    }

    public void removeOverridedCond(PcCondOverride ... excs) {
        for (PcCondOverride exc : excs) {
            this._exceptions &= (long)(~exc.getMask());
        }
    }

    public boolean canOverrideCond(PcCondOverride excs) {
        return (this._exceptions & (long)excs.getMask()) == (long)excs.getMask();
    }

    public void setOverrideCond(long masks) {
        this._exceptions = masks;
    }

    public void setLethalable(boolean val) {
        this._lethalable = val;
    }

    public boolean isLethalable() {
        return this._lethalable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, OptionsSkillHolder> getTriggerSkills() {
        if (this._triggerSkills == null) {
            L2Character l2Character = this;
            synchronized (l2Character) {
                if (this._triggerSkills == null) {
                    this._triggerSkills = new ConcurrentHashMap<Integer, OptionsSkillHolder>();
                }
            }
        }
        return this._triggerSkills;
    }

    public void addTriggerSkill(OptionsSkillHolder holder) {
        this.getTriggerSkills().put(holder.getSkillId(), holder);
    }

    public void removeTriggerSkill(OptionsSkillHolder holder) {
        this.getTriggerSkills().remove(holder.getSkillId());
    }

    public void makeTriggerCast(Skill skill, L2Character target, boolean ignoreTargetType) {
        try {
            if (skill == null) {
                return;
            }
            if (skill.checkCondition(this, target, false)) {
                L2PcInstance player;
                List<L2Object> targets;
                if (this.isSkillDisabled(skill)) {
                    return;
                }
                if (skill.getReuseDelay() > 0) {
                    this.disableSkill(skill, skill.getReuseDelay());
                }
                List<L2Object> list = targets = !ignoreTargetType ? skill.getTargets(this, target) : List.of(target);
                if (targets.isEmpty()) {
                    return;
                }
                for (L2Object obj : targets) {
                    if (obj == null || !obj.isCharacter()) continue;
                    target = (L2Character)obj;
                    break;
                }
                if (Configuration.character().validateTriggerSkills() && this.isPlayable() && target != null && target.isPlayable() && !(player = this.getActingPlayer()).checkPvpSkill(target, skill)) {
                    return;
                }
                this.broadcastPacket(new MagicSkillUse(this, target, skill.getDisplayId(), skill.getLevel(), 0, 0));
                this.broadcastPacket(new MagicSkillLaunched(this, skill.getDisplayId(), skill.getLevel(), targets));
                skill.activateSkill(this, targets);
            }
        }
        catch (Exception e) {
            LOG.warn("{}", e);
        }
    }

    public void makeTriggerCast(Skill skill, L2Character target) {
        this.makeTriggerCast(skill, target, false);
    }

    public boolean canRevive() {
        return true;
    }

    public void setCanRevive(boolean val) {
    }

    public boolean isSweepActive() {
        return false;
    }

    public boolean isOnEvent() {
        return false;
    }

    public int getClanId() {
        return 0;
    }

    public L2Clan getClan() {
        return null;
    }

    public boolean isAcademyMember() {
        return false;
    }

    public int getPledgeType() {
        return 0;
    }

    public int getAllyId() {
        return 0;
    }

    public void notifyDamageReceived(double damage, L2Character attacker, Skill skill, boolean critical, boolean damageOverTime, boolean isReflect) {
        EventDispatcher.getInstance().notifyEventAsync(new CreatureDamageReceived(attacker, this, damage, skill, critical, damageOverTime, isReflect), this);
        EventDispatcher.getInstance().notifyEventAsync(new CreatureDamageDealt(attacker, this, damage, skill, critical, damageOverTime, isReflect), attacker);
    }

    public void notifyAttackAvoid(L2Character target, boolean isDot) {
        EventDispatcher.getInstance().notifyEventAsync(new CreatureAttackAvoid(this, target, isDot), target);
    }

    public final WeaponType getAttackType() {
        TransformTemplate template;
        if (this.isTransformed() && (template = this.getTransformation().getTemplate(this.getActingPlayer())) != null) {
            return template.getBaseAttackType();
        }
        L2Weapon weapon = this.getActiveWeaponItem();
        if (weapon != null) {
            return weapon.getItemType();
        }
        return this.getTemplate().getBaseAttackType();
    }

    public final boolean isInCategory(CategoryType type) {
        return CategoryData.getInstance().isInCategory(type, this.getId());
    }

    public L2Character getSummoner() {
        return this._summoner;
    }

    public void setSummoner(L2Character summoner) {
        this._summoner = summoner;
    }

    @Override
    public boolean isCharacter() {
        return true;
    }

    public final boolean isChanneling() {
        return this._channelizer != null && this._channelizer.isChanneling();
    }

    public final SkillChannelizer getSkillChannelizer() {
        if (this._channelizer == null) {
            this._channelizer = new SkillChannelizer(this);
        }
        return this._channelizer;
    }

    public final boolean isChannelized() {
        return this._channelized != null && !this._channelized.isChannelized();
    }

    public final SkillChannelized getSkillChannelized() {
        if (this._channelized == null) {
            this._channelized = new SkillChannelized();
        }
        return this._channelized;
    }

    public void addInvulAgainst(SkillHolder holder) {
        InvulSkillHolder invulHolder = this.getInvulAgainstSkills().get(holder.getSkillId());
        if (invulHolder != null) {
            invulHolder.increaseInstances();
            return;
        }
        this.getInvulAgainstSkills().put(holder.getSkillId(), new InvulSkillHolder(holder));
    }

    public void removeInvulAgainst(SkillHolder holder) {
        InvulSkillHolder invulHolder = this.getInvulAgainstSkills().get(holder.getSkillId());
        if (invulHolder != null && invulHolder.decreaseInstances() < 1) {
            this.getInvulAgainstSkills().remove(holder.getSkillId());
        }
    }

    public boolean isInvulAgainst(int skillId, int skillLvl) {
        if (this._invulAgainst != null) {
            SkillHolder holder = this.getInvulAgainstSkills().get(skillId);
            return holder != null && (holder.getSkillLvl() < 1 || holder.getSkillLvl() == skillLvl);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, InvulSkillHolder> getInvulAgainstSkills() {
        if (this._invulAgainst == null) {
            L2Character l2Character = this;
            synchronized (l2Character) {
                if (this._invulAgainst == null) {
                    this._invulAgainst = new ConcurrentHashMap<Integer, InvulSkillHolder>();
                }
            }
        }
        return this._invulAgainst;
    }

    @Override
    public Queue<AbstractEventListener> getListeners(EventType type) {
        Queue<AbstractEventListener> globalListeners;
        Queue<AbstractEventListener> objectListenres = super.getListeners(type);
        Queue<AbstractEventListener> templateListeners = this.getTemplate().getListeners(type);
        Queue<AbstractEventListener> queue = this.isNpc() && !this.isMonster() ? Containers.Npcs().getListeners(type) : (this.isMonster() ? Containers.Monsters().getListeners(type) : (globalListeners = this.isPlayer() ? Containers.Players().getListeners(type) : EmptyQueue.emptyQueue()));
        if (objectListenres.isEmpty() && templateListeners.isEmpty() && globalListeners.isEmpty()) {
            return EmptyQueue.emptyQueue();
        }
        if (!objectListenres.isEmpty() && templateListeners.isEmpty() && globalListeners.isEmpty()) {
            return objectListenres;
        }
        if (!templateListeners.isEmpty() && objectListenres.isEmpty() && globalListeners.isEmpty()) {
            return templateListeners;
        }
        if (!globalListeners.isEmpty() && objectListenres.isEmpty() && templateListeners.isEmpty()) {
            return globalListeners;
        }
        LinkedBlockingDeque<AbstractEventListener> both = new LinkedBlockingDeque<AbstractEventListener>(objectListenres.size() + templateListeners.size() + globalListeners.size());
        both.addAll(objectListenres);
        both.addAll(templateListeners);
        both.addAll(globalListeners);
        return both;
    }

    public Race getRace() {
        return this.getTemplate().getRace();
    }

    public boolean isInDuel() {
        return false;
    }

    public int getDuelId() {
        return 0;
    }

    public byte getSiegeState() {
        return 0;
    }

    public int getSiegeSide() {
        return 0;
    }

    public void say(String msg) {
        this.broadcastPacket(new CreatureSay(this.getObjectId(), this.isPlayer() ? 0 : 22, this.getName(), msg));
    }

    public void say(NpcStringId msg) {
        this.broadcastPacket(new CreatureSay(this.getObjectId(), this.isPlayer() ? 0 : 22, this.getName(), msg));
    }

    public void shout(String msg) {
        this.broadcastPacket(new CreatureSay(this.getObjectId(), this.isPlayer() ? 1 : 23, this.getName(), msg));
    }

    public void shout(NpcStringId msg) {
        this.broadcastPacket(new CreatureSay(this.getObjectId(), this.isPlayer() ? 1 : 23, this.getName(), msg));
    }

    public static class MoveData {
        public int _moveStartTime;
        public int _moveTimestamp;
        public int _xDestination;
        public int _yDestination;
        public int _zDestination;
        public double _xAccurate;
        public double _yAccurate;
        public double _zAccurate;
        public int _heading;
        public boolean disregardingGeodata;
        public int onGeodataPathIndex;
        public List<AbstractNodeLoc> geoPath;
        public int geoPathAccurateTx;
        public int geoPathAccurateTy;
        public int geoPathGtx;
        public int geoPathGty;
    }
}

