/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.ArenaParticipantsHolder;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.BlockCheckerEngine;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameChangePoints;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameExtendedChangePoints;

public class L2BlockInstance
extends L2MonsterInstance {
    private int _colorEffect;

    public L2BlockInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeColor(L2PcInstance attacker, ArenaParticipantsHolder holder, int team) {
        L2BlockInstance l2BlockInstance = this;
        synchronized (l2BlockInstance) {
            BlockCheckerEngine event = holder.getEvent();
            if (this._colorEffect == 83) {
                this._colorEffect = 0;
                this.broadcastPacket(new AbstractNpcInfo.NpcInfo(this, attacker));
                this.increaseTeamPointsAndSend(attacker, team, event);
            } else {
                this._colorEffect = 83;
                this.broadcastPacket(new AbstractNpcInfo.NpcInfo(this, attacker));
                this.increaseTeamPointsAndSend(attacker, team, event);
            }
            int random = Rnd.get((int)100);
            if (random > 69 && random <= 84) {
                this.dropItem(13787, event, attacker);
            } else if (random > 84) {
                this.dropItem(13788, event, attacker);
            }
        }
    }

    public void setRed(boolean isRed) {
        this._colorEffect = isRed ? 83 : 0;
    }

    @Override
    public int getColorEffect() {
        return this._colorEffect;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        if (attacker instanceof L2PcInstance) {
            return attacker.getActingPlayer() != null && attacker.getActingPlayer().getBlockCheckerArena() > -1;
        }
        return true;
    }

    @Override
    public boolean doDie(L2Character killer) {
        return false;
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (!this.canTarget(player)) {
            return;
        }
        player.setLastFolkNPC(this);
        if (player.getTarget() != this) {
            player.setTarget(this);
            this.getAI();
        } else if (interact) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
        }
    }

    private void increaseTeamPointsAndSend(L2PcInstance player, int team, BlockCheckerEngine eng) {
        eng.increasePlayerPoints(player, team);
        int timeLeft = (int)((eng.getStarterTime() - System.currentTimeMillis()) / 1000L);
        boolean isRed = eng.getHolder().getRedPlayers().contains(player);
        ExCubeGameChangePoints changePoints = new ExCubeGameChangePoints(timeLeft, eng.getBluePoints(), eng.getRedPoints());
        ExCubeGameExtendedChangePoints secretPoints = new ExCubeGameExtendedChangePoints(timeLeft, eng.getBluePoints(), eng.getRedPoints(), isRed, player, eng.getPlayerPoints(player, isRed));
        eng.getHolder().broadCastPacketToTeam(changePoints);
        eng.getHolder().broadCastPacketToTeam(secretPoints);
    }

    private void dropItem(int id, BlockCheckerEngine eng, L2PcInstance player) {
        L2ItemInstance drop = ItemTable.getInstance().createItem("Loot", id, 1L, player, this);
        int x = this.getX() + Rnd.get((int)50);
        int y = this.getY() + Rnd.get((int)50);
        int z = this.getZ();
        drop.dropMe(this, x, y, z);
        eng.addNewDrop(drop);
    }
}

