/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.actor.instance.L2DoormenInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import java.util.StringTokenizer;

public class L2CastleDoormenInstance
extends L2DoormenInstance {
    public L2CastleDoormenInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2CastleDoormenInstance);
    }

    @Override
    protected final void openDoors(L2PcInstance player, String command) {
        StringTokenizer st = new StringTokenizer(command.substring(10), ", ");
        st.nextToken();
        while (st.hasMoreTokens()) {
            if (this.getConquerableHall() != null) {
                this.getConquerableHall().openCloseDoor(Integer.parseInt(st.nextToken()), true);
                continue;
            }
            this.getCastle().openDoor(player, Integer.parseInt(st.nextToken()));
        }
    }

    @Override
    protected final void closeDoors(L2PcInstance player, String command) {
        StringTokenizer st = new StringTokenizer(command.substring(11), ", ");
        st.nextToken();
        while (st.hasMoreTokens()) {
            if (this.getConquerableHall() != null) {
                this.getConquerableHall().openCloseDoor(Integer.parseInt(st.nextToken()), false);
                continue;
            }
            this.getCastle().closeDoor(player, Integer.parseInt(st.nextToken()));
        }
    }

    @Override
    protected final boolean isOwnerClan(L2PcInstance player) {
        if (player.getClan() != null && player.hasClanPrivilege(ClanPrivilege.CS_OPEN_DOOR)) {
            SiegableHall hall = this.getConquerableHall();
            if (hall != null) {
                return player.getClanId() == hall.getOwnerId();
            }
            if (this.getCastle() != null) {
                return player.getClanId() == this.getCastle().getOwnerId();
            }
        }
        return false;
    }

    @Override
    protected final boolean isUnderSiege() {
        SiegableHall hall = this.getConquerableHall();
        if (hall != null) {
            return hall.isInSiege();
        }
        return this.getCastle().getZone().isActive();
    }
}

