/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Decoy;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.DecoyKnownList;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.taskmanager.DecayTaskManager;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2DecoyInstance
extends L2Decoy {
    private int _totalLifeTime;
    private int _timeRemaining;
    private Future<?> _DecoyLifeTask;
    private Future<?> _HateSpam;

    public L2DecoyInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, int totalLifeTime) {
        super(objectId, template, owner);
        this.setInstanceType(InstanceType.L2DecoyInstance);
        this._timeRemaining = this._totalLifeTime = totalLifeTime;
        int skillLevel = this.getTemplate().getDisplayId() - 13070;
        this._DecoyLifeTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new DecoyLifetime(this.getOwner(), this), 1000L, 1000L);
        this._HateSpam = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new HateSpam(this, SkillData.getInstance().getSkill(5272, skillLevel)), 2000L, 5000L);
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (this._HateSpam != null) {
            this._HateSpam.cancel(true);
            this._HateSpam = null;
        }
        this._totalLifeTime = 0;
        DecayTaskManager.getInstance().add(this);
        return true;
    }

    @Override
    public DecoyKnownList getKnownList() {
        return (DecoyKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new DecoyKnownList(this));
    }

    @Override
    public void unSummon(L2PcInstance owner) {
        if (this._DecoyLifeTask != null) {
            this._DecoyLifeTask.cancel(true);
            this._DecoyLifeTask = null;
        }
        if (this._HateSpam != null) {
            this._HateSpam.cancel(true);
            this._HateSpam = null;
        }
        super.unSummon(owner);
    }

    public void decTimeRemaining(int value) {
        this._timeRemaining -= value;
    }

    public int getTimeRemaining() {
        return this._timeRemaining;
    }

    public int getTotalLifeTime() {
        return this._totalLifeTime;
    }

    static class DecoyLifetime
    implements Runnable {
        private static final Logger LOG = LoggerFactory.getLogger(DecoyLifetime.class);
        private final L2PcInstance _activeChar;
        private final L2DecoyInstance _Decoy;

        DecoyLifetime(L2PcInstance activeChar, L2DecoyInstance Decoy) {
            this._activeChar = activeChar;
            this._Decoy = Decoy;
        }

        @Override
        public void run() {
            try {
                this._Decoy.decTimeRemaining(1000);
                double newTimeRemaining = this._Decoy.getTimeRemaining();
                if (newTimeRemaining < 0.0) {
                    this._Decoy.unSummon(this._activeChar);
                }
            }
            catch (Exception ex) {
                LOG.error("Error running decoy lifetime task!", ex);
            }
        }
    }

    private static class HateSpam
    implements Runnable {
        private static final Logger LOG = LoggerFactory.getLogger(HateSpam.class);
        private final L2DecoyInstance _activeChar;
        private final Skill _skill;

        HateSpam(L2DecoyInstance activeChar, Skill Hate) {
            this._activeChar = activeChar;
            this._skill = Hate;
        }

        @Override
        public void run() {
            try {
                this._activeChar.setTarget(this._activeChar);
                this._activeChar.doCast(this._skill);
            }
            catch (Throwable ex) {
                LOG.error("Error running decoy hate spam task!", ex);
            }
        }
    }
}

