/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.ai.L2FortSiegeGuardAI;
import com.l2jserver.gameserver.ai.L2SiegeGuardAI;
import com.l2jserver.gameserver.ai.L2SpecialSiegeGuardAI;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.DefenderKnownList;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2DefenderInstance
extends L2Attackable {
    private static final Logger LOG = LoggerFactory.getLogger(L2DefenderInstance.class);
    private Castle _castle = null;
    private Fort _fort = null;
    private SiegableHall _hall = null;

    public L2DefenderInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2DefenderInstance);
    }

    @Override
    public DefenderKnownList getKnownList() {
        return (DefenderKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new DefenderKnownList(this));
    }

    @Override
    protected L2CharacterAI initAI() {
        if (this.getConquerableHall() == null && this.getCastle(10000L) == null) {
            return new L2FortSiegeGuardAI(this);
        }
        if (this.getCastle(10000L) != null) {
            return new L2SiegeGuardAI(this);
        }
        return new L2SpecialSiegeGuardAI(this);
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        if (!(attacker instanceof L2Playable)) {
            return false;
        }
        L2PcInstance player = attacker.getActingPlayer();
        if (this._fort != null && this._fort.getZone().isActive() || this._castle != null && this._castle.getZone().isActive() || this._hall != null && this._hall.getSiegeZone().isActive()) {
            int activeSiegeId = this._fort != null ? this._fort.getResidenceId() : (this._castle != null ? this._castle.getResidenceId() : (this._hall != null ? this._hall.getId() : 0));
            return player != null && (player.getSiegeState() == 2 && !player.isRegisteredOnThisSiegeField(activeSiegeId) || player.getSiegeState() == 1 && !TerritoryWarManager.getInstance().isAllyField(player, activeSiegeId) || player.getSiegeState() == 0);
        }
        return false;
    }

    @Override
    public boolean hasRandomAnimation() {
        return false;
    }

    @Override
    public void returnHome() {
        if (this.getWalkSpeed() <= 0.0) {
            return;
        }
        if (this.getSpawn() == null) {
            return;
        }
        if (!this.isInsideRadius(this.getSpawn(), 40, false, false)) {
            if (Configuration.general().debug()) {
                LOG.debug("{} moving home", (Object)this.getObjectId());
            }
            this.setisReturningToSpawnPoint(true);
            this.clearAggroList();
            if (this.hasAI()) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, this.getSpawn().getLocation());
            }
        }
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this._fort = FortManager.getInstance().getFort(this.getX(), this.getY(), this.getZ());
        this._castle = CastleManager.getInstance().getCastle(this.getX(), this.getY(), this.getZ());
        this._hall = this.getConquerableHall();
        if (this._fort == null && this._castle == null && this._hall == null) {
            LOG.warn("L2DefenderInstance spawned outside of Fortress, Castle or Siegable hall Zone! NpcId: {} x={} y={} z={}", this.getId(), this.getX(), this.getY(), this.getZ());
        }
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (!this.canTarget(player)) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (this != player.getTarget()) {
            if (Configuration.general().debug()) {
                LOG.debug("new target selected: {}", (Object)this.getObjectId());
            }
            player.setTarget(this);
        } else if (interact) {
            if (this.isAutoAttackable(player) && !this.isAlikeDead() && Math.abs(player.getZ() - this.getZ()) < 600) {
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
            }
            if (!this.isAutoAttackable(player) && !this.canInteract(player)) {
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, this);
            }
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    @Override
    public void addDamageHate(L2Character attacker, int damage, long aggro) {
        if (attacker == null) {
            return;
        }
        if (!(attacker instanceof L2DefenderInstance)) {
            if (damage == 0 && aggro <= 1L && attacker instanceof L2Playable) {
                L2PcInstance player = attacker.getActingPlayer();
                if (this._fort != null && this._fort.getZone().isActive() || this._castle != null && this._castle.getZone().isActive() || this._hall != null && this._hall.getSiegeZone().isActive()) {
                    int activeSiegeId;
                    int n = this._fort != null ? this._fort.getResidenceId() : (this._castle != null ? this._castle.getResidenceId() : (activeSiegeId = this._hall != null ? this._hall.getId() : 0));
                    if (player != null && (player.getSiegeState() == 2 && player.isRegisteredOnThisSiegeField(activeSiegeId) || player.getSiegeState() == 1 && TerritoryWarManager.getInstance().isAllyField(player, activeSiegeId))) {
                        return;
                    }
                }
            }
            super.addDamageHate(attacker, damage, aggro);
        }
    }
}

