/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.dao.factory.impl.DAOFactory;
import com.l2jserver.gameserver.data.sql.impl.CharSummonTable;
import com.l2jserver.gameserver.data.sql.impl.SummonEffectsTable;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SetSummonRemainTime;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.concurrent.Future;

public class L2ServitorInstance
extends L2Summon
implements Runnable {
    private float _expMultiplier = 0.0f;
    private ItemHolder _itemConsume;
    private int _lifeTime;
    private int _lifeTimeRemaining;
    private int _consumeItemInterval;
    private int _consumeItemIntervalRemaining;
    protected Future<?> _summonLifeTask;
    private int _referenceSkill;

    public L2ServitorInstance(int objectId, L2NpcTemplate template, L2PcInstance owner) {
        super(objectId, template, owner);
        this.setInstanceType(InstanceType.L2ServitorInstance);
        this.setShowSummonAnimation(true);
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        if (this._summonLifeTask == null) {
            this._summonLifeTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(this, 0L, 5000L);
        }
    }

    @Override
    public final int getLevel() {
        return this.getTemplate() != null ? (int)this.getTemplate().getLevel() : 0;
    }

    @Override
    public int getSummonType() {
        return 1;
    }

    public void setExpMultiplier(float expMultiplier) {
        this._expMultiplier = expMultiplier;
    }

    public float getExpMultiplier() {
        return this._expMultiplier;
    }

    public void setItemConsume(ItemHolder item) {
        this._itemConsume = item;
    }

    public ItemHolder getItemConsume() {
        return this._itemConsume;
    }

    public void setItemConsumeInterval(int interval) {
        this._consumeItemInterval = interval;
        this._consumeItemIntervalRemaining = interval;
    }

    public int getItemConsumeInterval() {
        return this._consumeItemInterval;
    }

    public void setLifeTime(int lifeTime) {
        this._lifeTime = lifeTime;
        this._lifeTimeRemaining = lifeTime;
    }

    public int getLifeTime() {
        return this._lifeTime;
    }

    public void setLifeTimeRemaining(int time) {
        this._lifeTimeRemaining = time;
    }

    public int getLifeTimeRemaining() {
        return this._lifeTimeRemaining;
    }

    public void setReferenceSkill(int skillId) {
        this._referenceSkill = skillId;
    }

    public int getReferenceSkill() {
        return this._referenceSkill;
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (this._summonLifeTask != null) {
            this._summonLifeTask.cancel(false);
        }
        CharSummonTable.getInstance().removeServitor(this.getOwner());
        return true;
    }

    @Override
    public void doPickupItem(L2Object object) {
    }

    @Override
    public final void stopSkillEffects(boolean removed, int skillId) {
        super.stopSkillEffects(removed, skillId);
        SummonEffectsTable.getInstance().removeServitorEffects(this.getOwner(), this.getReferenceSkill(), skillId);
    }

    @Override
    public void storeMe() {
        if (this._referenceSkill == 0 || this.isDead()) {
            return;
        }
        if (Configuration.character().restoreServitorOnReconnect()) {
            CharSummonTable.getInstance().saveSummon(this);
        }
    }

    @Override
    public void storeEffect(boolean storeEffects) {
        if (!Configuration.character().summonStoreSkillCooltime()) {
            return;
        }
        if (this.getOwner() == null || this.getOwner().isInOlympiadMode()) {
            return;
        }
        SummonEffectsTable.getInstance().clearServitorEffects(this.getOwner(), this.getReferenceSkill());
        DAOFactory.getInstance().getServitorSkillSaveDAO().insert(this, storeEffects);
    }

    @Override
    public void restoreEffects() {
        if (this.getOwner().isInOlympiadMode()) {
            return;
        }
        DAOFactory.getInstance().getServitorSkillSaveDAO().load(this);
        SummonEffectsTable.getInstance().applyServitorEffects(this, this.getOwner(), this.getReferenceSkill());
    }

    @Override
    public void unSummon(L2PcInstance owner) {
        if (this._summonLifeTask != null) {
            this._summonLifeTask.cancel(false);
        }
        super.unSummon(owner);
        if (!this._restoreSummon) {
            CharSummonTable.getInstance().removeServitor(owner);
        }
    }

    @Override
    public boolean destroyItem(String process, int objectId, long count, L2Object reference, boolean sendMessage) {
        return this.getOwner().destroyItem(process, objectId, count, reference, sendMessage);
    }

    @Override
    public boolean destroyItemByItemId(String process, int itemId, long count, L2Object reference, boolean sendMessage) {
        return this.getOwner().destroyItemByItemId(process, itemId, count, reference, sendMessage);
    }

    @Override
    public byte getAttackElement() {
        if (this.getOwner() != null) {
            return this.getOwner().getAttackElement();
        }
        return super.getAttackElement();
    }

    @Override
    public int getAttackElementValue(byte attackAttribute) {
        if (this.getOwner() != null) {
            return this.getOwner().getAttackElementValue(attackAttribute);
        }
        return super.getAttackElementValue(attackAttribute);
    }

    @Override
    public int getDefenseElementValue(byte defenseAttribute) {
        if (this.getOwner() != null) {
            return this.getOwner().getDefenseElementValue(defenseAttribute);
        }
        return super.getDefenseElementValue(defenseAttribute);
    }

    @Override
    public boolean isServitor() {
        return true;
    }

    @Override
    public void run() {
        int usedTime = 5000;
        this._lifeTimeRemaining -= usedTime;
        if (this.isDead() || !this.isVisible()) {
            if (this._summonLifeTask != null) {
                this._summonLifeTask.cancel(false);
            }
            return;
        }
        if (this._lifeTimeRemaining < 0) {
            this.sendPacket(SystemMessageId.SERVITOR_PASSED_AWAY);
            this.unSummon(this.getOwner());
            return;
        }
        if (this._consumeItemInterval > 0) {
            this._consumeItemIntervalRemaining -= usedTime;
            if (this._consumeItemIntervalRemaining <= 0 && this.getItemConsume().getCount() > 0L && this.getItemConsume().getId() > 0 && !this.isDead()) {
                if (this.destroyItemByItemId("Consume", this.getItemConsume().getId(), this.getItemConsume().getCount(), this, false)) {
                    SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.SUMMONED_MOB_USES_S1);
                    msg.addItemName(this.getItemConsume().getId());
                    this.sendPacket(msg);
                    this._consumeItemIntervalRemaining = this._consumeItemInterval;
                } else {
                    this.sendPacket(SystemMessageId.SERVITOR_DISAPPEARED_NOT_ENOUGH_ITEMS);
                    this.unSummon(this.getOwner());
                }
            }
        }
        this.sendPacket(new SetSummonRemainTime(this.getLifeTime(), this._lifeTimeRemaining));
        this.updateEffectIcons();
    }

    @Override
    public double getMAtk(L2Character target, Skill skill) {
        return super.getMAtk(target, skill) + this.getActingPlayer().getMAtk(target, skill) * (this.getActingPlayer().getServitorShareBonus(Stats.MAGIC_ATTACK) - 1.0);
    }

    @Override
    public double getMDef(L2Character target, Skill skill) {
        return super.getMDef(target, skill) + this.getActingPlayer().getMDef(target, skill) * (this.getActingPlayer().getServitorShareBonus(Stats.MAGIC_DEFENCE) - 1.0);
    }

    @Override
    public double getPAtk(L2Character target) {
        return super.getPAtk(target) + this.getActingPlayer().getPAtk(target) * (this.getActingPlayer().getServitorShareBonus(Stats.POWER_ATTACK) - 1.0);
    }

    @Override
    public double getPDef(L2Character target) {
        return super.getPDef(target) + this.getActingPlayer().getPDef(target) * (this.getActingPlayer().getServitorShareBonus(Stats.POWER_DEFENCE) - 1.0);
    }

    @Override
    public int getMAtkSpd() {
        return (int)((double)super.getMAtkSpd() + (double)this.getActingPlayer().getMAtkSpd() * (this.getActingPlayer().getServitorShareBonus(Stats.MAGIC_ATTACK_SPEED) - 1.0));
    }

    @Override
    public int getMaxHp() {
        return (int)((double)super.getMaxHp() + (double)this.getActingPlayer().getMaxHp() * (this.getActingPlayer().getServitorShareBonus(Stats.MAX_HP) - 1.0));
    }

    @Override
    public int getMaxMp() {
        return (int)((double)super.getMaxMp() + (double)this.getActingPlayer().getMaxMp() * (this.getActingPlayer().getServitorShareBonus(Stats.MAX_MP) - 1.0));
    }

    @Override
    public int getCriticalHit(L2Character target, Skill skill) {
        return (int)((double)super.getCriticalHit(target, skill) + (double)this.getActingPlayer().getCriticalHit(target, skill) * (this.getActingPlayer().getServitorShareBonus(Stats.CRITICAL_RATE) - 1.0));
    }

    @Override
    public double getPAtkSpd() {
        return super.getPAtkSpd() + this.getActingPlayer().getPAtkSpd() * (this.getActingPlayer().getServitorShareBonus(Stats.POWER_ATTACK_SPEED) - 1.0);
    }

    @Override
    public int getMaxRecoverableHp() {
        return (int)this.calcStat(Stats.MAX_RECOVERABLE_HP, this.getMaxHp());
    }

    @Override
    public int getMaxRecoverableMp() {
        return (int)this.calcStat(Stats.MAX_RECOVERABLE_MP, this.getMaxMp());
    }
}

