/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.knownlist;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.ObjectKnownList;
import com.l2jserver.gameserver.util.Util;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CharKnownList
extends ObjectKnownList {
    private volatile Map<Integer, L2PcInstance> _knownPlayers;
    private volatile Map<Integer, L2Summon> _knownSummons;
    private volatile Map<Integer, Integer> _knownRelations;

    public CharKnownList(L2Character activeChar) {
        super(activeChar);
    }

    @Override
    public boolean addKnownObject(L2Object object) {
        if (!super.addKnownObject(object)) {
            return false;
        }
        if (object.isPlayer()) {
            this.getKnownPlayers().put(object.getObjectId(), object.getActingPlayer());
            this.getKnownRelations().put(object.getObjectId(), -1);
        } else if (object.isSummon()) {
            this.getKnownSummons().put(object.getObjectId(), (L2Summon)object);
        }
        return true;
    }

    public final boolean knowsThePlayer(L2PcInstance player) {
        return this.getActiveChar() == player || this.getKnownPlayers().containsKey(player.getObjectId());
    }

    @Override
    public final void removeAllKnownObjects() {
        super.removeAllKnownObjects();
        this.getKnownPlayers().clear();
        this.getKnownRelations().clear();
        this.getKnownSummons().clear();
        this.getActiveChar().setTarget(null);
        if (this.getActiveChar().hasAI()) {
            this.getActiveChar().setAI(null);
        }
    }

    @Override
    protected boolean removeKnownObject(L2Object object, boolean forget) {
        if (!super.removeKnownObject(object, forget)) {
            return false;
        }
        if (!forget) {
            if (object.isPlayer()) {
                this.getKnownPlayers().remove(object.getObjectId());
                this.getKnownRelations().remove(object.getObjectId());
            } else if (object.isSummon()) {
                this.getKnownSummons().remove(object.getObjectId());
            }
        }
        if (object == this.getActiveChar().getTarget()) {
            this.getActiveChar().setTarget(null);
        }
        return true;
    }

    @Override
    public void forgetObjects(boolean fullCheck) {
        if (!fullCheck) {
            Iterator<L2PcInstance> pIter = this.getKnownPlayers().values().iterator();
            while (pIter.hasNext()) {
                L2PcInstance player = pIter.next();
                if (player == null) {
                    pIter.remove();
                    continue;
                }
                if (player.isVisible() && Util.checkIfInShortRadius(this.getDistanceToForgetObject(player), this.getActiveObject(), player, true)) continue;
                pIter.remove();
                this.removeKnownObject(player, true);
                this.getKnownRelations().remove(player.getObjectId());
                this.getKnownObjects().remove(player.getObjectId());
            }
            Iterator<L2Summon> sIter = this.getKnownSummons().values().iterator();
            while (sIter.hasNext()) {
                L2Summon summon = sIter.next();
                if (summon == null) {
                    sIter.remove();
                    continue;
                }
                if (this.getActiveChar().isPlayer() && summon.getOwner() == this.getActiveChar() || summon.isVisible() && Util.checkIfInShortRadius(this.getDistanceToForgetObject(summon), this.getActiveObject(), summon, true)) continue;
                sIter.remove();
                this.removeKnownObject(summon, true);
                this.getKnownObjects().remove(summon.getObjectId());
            }
            return;
        }
        Iterator<L2Object> oIter = this.getKnownObjects().values().iterator();
        while (oIter.hasNext()) {
            L2Object object = oIter.next();
            if (object == null) {
                oIter.remove();
                continue;
            }
            if (object.isVisible() && Util.checkIfInShortRadius(this.getDistanceToForgetObject(object), this.getActiveObject(), object, true)) continue;
            oIter.remove();
            this.removeKnownObject(object, true);
            if (object.isPlayer()) {
                this.getKnownPlayers().remove(object.getObjectId());
                this.getKnownRelations().remove(object.getObjectId());
                continue;
            }
            if (!object.isSummon()) continue;
            this.getKnownSummons().remove(object.getObjectId());
        }
    }

    public L2Character getActiveChar() {
        return (L2Character)super.getActiveObject();
    }

    public List<L2Character> getKnownCharacters() {
        LinkedList<L2Character> result = new LinkedList<L2Character>();
        for (L2Object obj : this.getKnownObjects().values()) {
            if (!(obj instanceof L2Character)) continue;
            result.add((L2Character)obj);
        }
        return result;
    }

    public List<L2Character> getKnownCharactersInRadius(long radius) {
        LinkedList<L2Character> result = new LinkedList<L2Character>();
        for (L2Object obj : this.getKnownObjects().values()) {
            if (!(obj instanceof L2Character) || !Util.checkIfInRange((int)radius, this.getActiveChar(), obj, true)) continue;
            result.add((L2Character)obj);
        }
        return result;
    }

    public final List<L2PcInstance> getKnownPlayersInRadius(long radius) {
        LinkedList<L2PcInstance> result = new LinkedList<L2PcInstance>();
        for (L2PcInstance player : this.getKnownPlayers().values()) {
            if (!Util.checkIfInRange((int)radius, this.getActiveChar(), player, true)) continue;
            result.add(player);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<Integer, L2PcInstance> getKnownPlayers() {
        if (this._knownPlayers == null) {
            CharKnownList charKnownList = this;
            synchronized (charKnownList) {
                if (this._knownPlayers == null) {
                    this._knownPlayers = new ConcurrentHashMap<Integer, L2PcInstance>();
                }
            }
        }
        return this._knownPlayers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<Integer, Integer> getKnownRelations() {
        if (this._knownRelations == null) {
            CharKnownList charKnownList = this;
            synchronized (charKnownList) {
                if (this._knownRelations == null) {
                    this._knownRelations = new ConcurrentHashMap<Integer, Integer>();
                }
            }
        }
        return this._knownRelations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<Integer, L2Summon> getKnownSummons() {
        if (this._knownSummons == null) {
            CharKnownList charKnownList = this;
            synchronized (charKnownList) {
                if (this._knownSummons == null) {
                    this._knownSummons = new ConcurrentHashMap<Integer, L2Summon>();
                }
            }
        }
        return this._knownSummons;
    }

    public final String toString() {
        return String.valueOf(this.getActiveChar()) + " Known Objects " + String.valueOf(this.getKnownObjects());
    }
}

