/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.knownlist;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.WalkingManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2FestivalGuideInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.CharKnownList;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcCreatureSee;
import java.util.concurrent.ScheduledFuture;

public class NpcKnownList
extends CharKnownList {
    private ScheduledFuture<?> _trackingTask = null;

    public NpcKnownList(L2Npc activeChar) {
        super(activeChar);
    }

    @Override
    public boolean addKnownObject(L2Object object) {
        if (!super.addKnownObject(object)) {
            return false;
        }
        if (this.getActiveObject().isNpc() && object instanceof L2Character) {
            EventDispatcher.getInstance().notifyEventAsync(new NpcCreatureSee(this.getActiveChar(), (L2Character)object), this.getActiveChar());
        }
        return true;
    }

    @Override
    public L2Npc getActiveChar() {
        return (L2Npc)super.getActiveChar();
    }

    @Override
    public int getDistanceToForgetObject(L2Object object) {
        return this.getDistanceToWatchObject(object) + 500;
    }

    @Override
    public int getDistanceToWatchObject(L2Object object) {
        if (!(object instanceof L2Character)) {
            return 0;
        }
        if (object instanceof L2FestivalGuideInstance) {
            return 4000;
        }
        if (object.isPlayable()) {
            return 1500;
        }
        return 500;
    }

    public void startTrackingTask() {
        if (this._trackingTask == null && this.getActiveChar().getAggroRange() > 0) {
            this._trackingTask = ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new TrackingTask(), 2000L, 2000L);
        }
    }

    public void stopTrackingTask() {
        if (this._trackingTask != null) {
            this._trackingTask.cancel(true);
            this._trackingTask = null;
        }
    }

    protected class TrackingTask
    implements Runnable {
        protected TrackingTask() {
        }

        @Override
        public void run() {
            if (!NpcKnownList.this.getActiveChar().isAttackable()) {
                return;
            }
            L2Attackable monster = (L2Attackable)NpcKnownList.this.getActiveChar();
            if (monster.getAI().getIntention() != CtrlIntention.AI_INTENTION_MOVE_TO) {
                return;
            }
            for (L2PcInstance pl : NpcKnownList.this.getKnownPlayers().values()) {
                if (pl.isDead() || pl.isInvul() || !pl.isInsideRadius(monster, monster.getAggroRange(), true, false) || !monster.isMonster() && (!monster.isInstanceTypes(InstanceType.L2GuardInstance) || pl.getKarma() <= 0)) continue;
                if (monster.getHating(pl) == 0L) {
                    monster.addDamageHate(pl, 0, 0L);
                }
                if (monster.getAI().getIntention() == CtrlIntention.AI_INTENTION_ATTACK || monster.isCoreAIDisabled()) continue;
                WalkingManager.getInstance().stopMoving(NpcKnownList.this.getActiveChar(), false, true);
                monster.addDamageHate(pl, 0, 100L);
                monster.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, pl, null);
            }
        }
    }
}

