/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.knownlist;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2AirShipInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.PlayableKnownList;
import com.l2jserver.gameserver.network.serverpackets.DeleteObject;
import com.l2jserver.gameserver.network.serverpackets.SpawnItem;

public class PcKnownList
extends PlayableKnownList {
    public PcKnownList(L2PcInstance activeChar) {
        super(activeChar);
    }

    @Override
    public boolean addKnownObject(L2Object object) {
        if (!super.addKnownObject(object)) {
            return false;
        }
        if (object.getPoly().isMorphed() && object.getPoly().getPolyType().equals("item")) {
            this.getActiveChar().sendPacket(new SpawnItem(object));
        } else if (object.isVisibleFor(this.getActiveChar())) {
            L2Character obj;
            object.sendInfo(this.getActiveChar());
            if (object instanceof L2Character && (obj = (L2Character)object).hasAI()) {
                obj.getAI().describeStateToPlayer(this.getActiveChar());
            }
        }
        return true;
    }

    @Override
    protected boolean removeKnownObject(L2Object object, boolean forget) {
        if (!super.removeKnownObject(object, forget)) {
            return false;
        }
        if (object instanceof L2AirShipInstance) {
            L2AirShipInstance airShip = (L2AirShipInstance)object;
            if (airShip.getCaptainId() != 0 && airShip.getCaptainId() != this.getActiveChar().getObjectId()) {
                this.getActiveChar().sendPacket(new DeleteObject(airShip.getCaptainId()));
            }
            if (airShip.getHelmObjectId() != 0) {
                this.getActiveChar().sendPacket(new DeleteObject(airShip.getHelmObjectId()));
            }
        }
        this.getActiveChar().sendPacket(new DeleteObject(object));
        if (Configuration.general().checkKnownList() && object instanceof L2Npc && this.getActiveChar().isGM()) {
            this.getActiveChar().sendMessage("Removed NPC: " + object.getName());
        }
        return true;
    }

    @Override
    public final L2PcInstance getActiveChar() {
        return (L2PcInstance)super.getActiveChar();
    }

    @Override
    public int getDistanceToForgetObject(L2Object object) {
        if (object.isVehicle()) {
            return 10000;
        }
        return this.getDistanceToWatchObject(object) + 500;
    }

    @Override
    public int getDistanceToWatchObject(L2Object object) {
        if (object.isVehicle()) {
            return 9000;
        }
        int knownlistSize = this.getKnownObjects().size();
        if (knownlistSize <= 3 && !object.isAttackable()) {
            return 4500;
        }
        if (knownlistSize <= 10 && !object.isAttackable()) {
            return 4000;
        }
        if (knownlistSize <= 20 && !object.isAttackable()) {
            return 3400;
        }
        if (knownlistSize <= 30) {
            return 2900;
        }
        if (knownlistSize <= 40) {
            return 2300;
        }
        return 3000;
    }
}

