/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.stat;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.PetDataTable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.stat.SummonStat;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.Stats;

public class PetStat
extends SummonStat {
    public PetStat(L2PetInstance activeChar) {
        super(activeChar);
    }

    public boolean addExp(int value) {
        if (this.getActiveChar().isUncontrollable() || !super.addExp(value)) {
            return false;
        }
        this.getActiveChar().updateAndBroadcastStatus(1);
        this.getActiveChar().updateEffectIcons(true);
        return true;
    }

    public boolean addExpAndSp(long addToExp, int addToSp) {
        if (this.getActiveChar().isUncontrollable() || !this.addExp(addToExp)) {
            return false;
        }
        this.getActiveChar().updateAndBroadcastStatus(1);
        return true;
    }

    @Override
    public final long getExpForLevel(int level) {
        try {
            return PetDataTable.getInstance().getPetLevelData(this.getActiveChar().getId(), Math.min(level, this.getMaxExpLevel())).getPetMaxExp();
        }
        catch (NullPointerException e) {
            if (this.getActiveChar() != null) {
                LOG.warn("Pet objectId:{}, NpcId:{}, level:{} is missing data from pets_stats table!", this.getActiveChar().getObjectId(), this.getActiveChar().getId(), level);
            }
            throw e;
        }
    }

    @Override
    public void setLevel(int value) {
        this.getActiveChar().setPetData(PetDataTable.getInstance().getPetLevelData(this.getActiveChar().getTemplate().getId(), value));
        if (this.getActiveChar().getPetLevelData() == null) {
            throw new IllegalArgumentException("No pet data for npc: " + this.getActiveChar().getTemplate().getId() + " level: " + value);
        }
        this.getActiveChar().stopFeed();
        super.setLevel(value);
        this.getActiveChar().startFeed();
        if (this.getActiveChar().getControlItem() != null) {
            this.getActiveChar().getControlItem().setEnchantLevel(this.getLevel());
        }
    }

    @Override
    public int getMaxLevel() {
        return Configuration.character().getMaxPetLevel();
    }

    @Override
    public int getMaxExpLevel() {
        return Configuration.character().getMaxPetLevel() + 1;
    }

    @Override
    public L2PetInstance getActiveChar() {
        return (L2PetInstance)super.getActiveChar();
    }

    public final int getFeedBattle() {
        return this.getActiveChar().getPetLevelData().getPetFeedBattle();
    }

    public final int getFeedNormal() {
        return this.getActiveChar().getPetLevelData().getPetFeedNormal();
    }

    public final int getMaxFeed() {
        return this.getActiveChar().getPetLevelData().getPetMaxFeed();
    }

    @Override
    public int getMaxHp() {
        return (int)this.calcStat(Stats.MAX_HP, this.getActiveChar().getPetLevelData().getPetMaxHP(), null, null);
    }

    @Override
    public int getMaxMp() {
        return (int)this.calcStat(Stats.MAX_MP, this.getActiveChar().getPetLevelData().getPetMaxMP(), null, null);
    }

    @Override
    public double getMAtk(L2Character target, Skill skill) {
        return this.calcStat(Stats.MAGIC_ATTACK, this.getActiveChar().getPetLevelData().getPetMAtk(), target, skill);
    }

    @Override
    public double getMDef(L2Character target, Skill skill) {
        return this.calcStat(Stats.MAGIC_DEFENCE, this.getActiveChar().getPetLevelData().getPetMDef(), target, skill);
    }

    @Override
    public double getPAtk(L2Character target) {
        return this.calcStat(Stats.POWER_ATTACK, this.getActiveChar().getPetLevelData().getPetPAtk(), target, null);
    }

    @Override
    public double getPDef(L2Character target) {
        return this.calcStat(Stats.POWER_DEFENCE, this.getActiveChar().getPetLevelData().getPetPDef(), target, null);
    }

    @Override
    public double getPAtkSpd() {
        double val = super.getPAtkSpd();
        if (this.getActiveChar().isHungry()) {
            val /= 2.0;
        }
        return val;
    }

    @Override
    public int getMAtkSpd() {
        int val = super.getMAtkSpd();
        if (this.getActiveChar().isHungry()) {
            val /= 2;
        }
        return val;
    }
}

