/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.tasks.cubics;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CubicAction
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(CubicAction.class);
    private final L2CubicInstance _cubic;
    private final AtomicInteger _currentCount = new AtomicInteger();
    private final int _chance;

    public CubicAction(L2CubicInstance cubic, int chance) {
        this._cubic = cubic;
        this._chance = chance;
    }

    @Override
    public void run() {
        if (this._cubic == null) {
            return;
        }
        try {
            if (this._cubic.getOwner().isDead() || !this._cubic.getOwner().isOnline()) {
                this._cubic.stopAction();
                this._cubic.getOwner().getCubics().remove(this._cubic.getId());
                this._cubic.getOwner().broadcastUserInfo();
                this._cubic.cancelDisappear();
                return;
            }
            if (!AttackStanceTaskManager.getInstance().hasAttackStanceTask(this._cubic.getOwner())) {
                if (this._cubic.getOwner().hasSummon()) {
                    if (!AttackStanceTaskManager.getInstance().hasAttackStanceTask(this._cubic.getOwner().getSummon())) {
                        this._cubic.stopAction();
                        return;
                    }
                } else {
                    this._cubic.stopAction();
                    return;
                }
            }
            if (this._cubic.getCubicMaxCount() > -1 && this._currentCount.get() >= this._cubic.getCubicMaxCount()) {
                this._cubic.stopAction();
                return;
            }
            boolean useCubicCure = false;
            if (this._cubic.getId() >= 10 && this._cubic.getId() <= 14) {
                for (BuffInfo info : this._cubic.getOwner().getEffectList().getDebuffs()) {
                    if (info.getSkill().isIrreplaceableBuff()) continue;
                    useCubicCure = true;
                    info.getEffected().getEffectList().stopSkillEffects(true, info.getSkill());
                }
            }
            if (useCubicCure) {
                MagicSkillUse msu = new MagicSkillUse(this._cubic.getOwner(), this._cubic.getOwner(), 5579, 1, 0, 0);
                this._cubic.getOwner().broadcastPacket(msu);
                this._currentCount.incrementAndGet();
            } else if (Rnd.get((int)1, (int)100) < this._chance) {
                Skill skill = this._cubic.getSkills().get(Rnd.get((int)this._cubic.getSkills().size()));
                if (skill == null) {
                    return;
                }
                if (skill.getId() == 4051) {
                    this._cubic.cubicTargetForHeal();
                } else {
                    this._cubic.getCubicTarget();
                    if (!L2CubicInstance.isInCubicRange(this._cubic.getOwner(), this._cubic.getTarget())) {
                        this._cubic.setTarget(null);
                    }
                }
                L2Character target = this._cubic.getTarget();
                if (target != null && !target.isDead()) {
                    if (Configuration.general().debug()) {
                        LOG.info("Action.run();");
                        LOG.info("Cubic ID: {} Target: {} distance: {}", this._cubic.getId(), target.getName(), target.calculateDistance(this._cubic.getOwner(), true, false));
                    }
                    this._cubic.getOwner().broadcastPacket(new MagicSkillUse(this._cubic.getOwner(), target, skill.getId(), skill.getLevel(), 0, 0));
                    List<L2Object> targets = List.of(target);
                    if (skill.isContinuous()) {
                        this._cubic.useCubicContinuous(skill, targets);
                    } else {
                        skill.activateSkill(this._cubic, targets);
                    }
                    if (skill.hasEffectType(L2EffectType.MAGICAL_ATTACK, new L2EffectType[0])) {
                        this._cubic.useCubicMdam(skill, targets);
                    } else if (skill.hasEffectType(L2EffectType.HP_DRAIN, new L2EffectType[0])) {
                        this._cubic.useCubicDrain(skill, targets);
                    } else if (skill.hasEffectType(L2EffectType.STUN, L2EffectType.ROOT)) {
                        this._cubic.useCubicDisabler(skill, targets);
                    } else if (skill.hasEffectType(L2EffectType.DMG_OVER_TIME, new L2EffectType[0])) {
                        this._cubic.useCubicContinuous(skill, targets);
                    } else if (skill.hasEffectType(L2EffectType.AGGRESSION, new L2EffectType[0])) {
                        this._cubic.useCubicDisabler(skill, targets);
                    }
                    this._currentCount.incrementAndGet();
                }
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }
}

