/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.tasks.cubics;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubicHeal
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(CubicHeal.class);
    private final L2CubicInstance _cubic;

    public CubicHeal(L2CubicInstance cubic) {
        this._cubic = cubic;
    }

    @Override
    public void run() {
        if (this._cubic == null) {
            return;
        }
        if (this._cubic.getOwner().isDead() || !this._cubic.getOwner().isOnline()) {
            this._cubic.stopAction();
            this._cubic.getOwner().getCubics().remove(this._cubic.getId());
            this._cubic.getOwner().broadcastUserInfo();
            this._cubic.cancelDisappear();
            return;
        }
        try {
            Skill skill = this._cubic.getSkills().stream().filter(s -> s.getId() == 4051).findFirst().orElse(null);
            if (skill == null) {
                return;
            }
            this._cubic.cubicTargetForHeal();
            L2Character target = this._cubic.getTarget();
            if (target != null && !target.isDead()) {
                skill.activateSkill(this._cubic, List.of(target));
                this._cubic.getOwner().broadcastPacket(new MagicSkillUse(this._cubic.getOwner(), target, skill.getId(), skill.getLevel(), 0, 0));
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }
}

