/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.tasks.player;

import com.l2jserver.gameserver.data.xml.impl.AdminData;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.LeaveWorld;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameGuardCheckTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(GameGuardCheckTask.class);
    private final L2PcInstance _player;

    public GameGuardCheckTask(L2PcInstance player) {
        this._player = player;
    }

    @Override
    public void run() {
        L2GameClient client;
        if (this._player != null && (client = this._player.getClient()) != null && !client.isAuthedGG() && this._player.isOnline()) {
            AdminData.getInstance().broadcastMessageToGMs("Client " + String.valueOf(client) + " failed to reply GameGuard query and is being kicked!");
            LOG.info("Client {} failed to reply GameGuard query and is being kicked!", (Object)client);
            client.close(LeaveWorld.STATIC_PACKET);
        }
    }
}

