/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.announce;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.announce.Announcement;
import com.l2jserver.gameserver.model.announce.AnnouncementType;
import com.l2jserver.gameserver.util.Broadcast;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AutoAnnouncement
extends Announcement
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AutoAnnouncement.class);
    private static final String INSERT_QUERY = "INSERT INTO announcements (`type`, `content`, `author`, `initial`, `delay`, `repeat`) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_QUERY = "UPDATE announcements SET `type` = ?, `content` = ?, `author` = ?, `initial` = ?, `delay` = ?, `repeat` = ? WHERE id = ?";
    private long _initial;
    private long _delay;
    private int _repeat;
    private int _currentState;
    private ScheduledFuture<?> _task;

    public AutoAnnouncement(AnnouncementType type, String content, String author, long initial, long delay, int repeat) {
        super(type, content, author);
        this._initial = initial;
        this._delay = delay;
        this._repeat = repeat;
        this.restartMe();
    }

    public long getInitial() {
        return this._initial;
    }

    public void setInitial(long initial) {
        this._initial = initial;
    }

    public long getDelay() {
        return this._delay;
    }

    public void setDelay(long delay) {
        this._delay = delay;
    }

    public int getRepeat() {
        return this._repeat;
    }

    public void setRepeat(int repeat) {
        this._repeat = repeat;
    }

    @Override
    public boolean storeMe() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(INSERT_QUERY, 1);){
            ps.setInt(1, this.getType().ordinal());
            ps.setString(2, this.getContent());
            ps.setString(3, this.getAuthor());
            ps.setLong(4, this.getInitial());
            ps.setLong(5, this.getDelay());
            ps.setInt(6, this.getRepeat());
            ps.execute();
            try (ResultSet rs = ps.getGeneratedKeys();){
                if (rs.next()) {
                    this._id = rs.getInt(1);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Couldn't store announcement: ", e);
            return false;
        }
        return true;
    }

    @Override
    public boolean updateMe() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(UPDATE_QUERY);){
            ps.setInt(1, this.getType().ordinal());
            ps.setString(2, this.getContent());
            ps.setString(3, this.getAuthor());
            ps.setLong(4, this.getInitial());
            ps.setLong(5, this.getDelay());
            ps.setLong(6, this.getRepeat());
            ps.setLong(7, this.getId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Couldn't update announcement: ", e);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteMe() {
        if (this._task != null && !this._task.isCancelled()) {
            this._task.cancel(false);
        }
        return super.deleteMe();
    }

    public void restartMe() {
        if (this._task != null && !this._task.isCancelled()) {
            this._task.cancel(false);
        }
        this._currentState = this._repeat;
        this._task = ThreadPoolManager.getInstance().scheduleGeneral(this, this._initial);
    }

    @Override
    public void run() {
        if (this._currentState == -1 || this._currentState > 0) {
            for (String content : this.getContent().split(Configuration.EOL)) {
                Broadcast.toAllOnlinePlayers(content, this.getType() == AnnouncementType.AUTO_CRITICAL);
            }
            if (this._currentState != -1) {
                --this._currentState;
            }
            this._task = ThreadPoolManager.getInstance().scheduleGeneral(this, this._delay);
        }
    }
}

