/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.base;

import com.l2jserver.gameserver.enums.Race;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;

public enum ClassId implements IIdentifiable
{
    fighter(0, false, Race.HUMAN, null),
    warrior(1, false, Race.HUMAN, fighter),
    gladiator(2, false, Race.HUMAN, warrior),
    warlord(3, false, Race.HUMAN, warrior),
    knight(4, false, Race.HUMAN, fighter),
    paladin(5, false, Race.HUMAN, knight),
    darkAvenger(6, false, Race.HUMAN, knight),
    rogue(7, false, Race.HUMAN, fighter),
    treasureHunter(8, false, Race.HUMAN, rogue),
    hawkeye(9, false, Race.HUMAN, rogue),
    mage(10, true, Race.HUMAN, null),
    wizard(11, true, Race.HUMAN, mage),
    sorceror(12, true, Race.HUMAN, wizard),
    necromancer(13, true, Race.HUMAN, wizard),
    warlock(14, true, true, Race.HUMAN, wizard),
    cleric(15, true, Race.HUMAN, mage),
    bishop(16, true, Race.HUMAN, cleric),
    prophet(17, true, Race.HUMAN, cleric),
    elvenFighter(18, false, Race.ELF, null),
    elvenKnight(19, false, Race.ELF, elvenFighter),
    templeKnight(20, false, Race.ELF, elvenKnight),
    swordSinger(21, false, Race.ELF, elvenKnight),
    elvenScout(22, false, Race.ELF, elvenFighter),
    plainsWalker(23, false, Race.ELF, elvenScout),
    silverRanger(24, false, Race.ELF, elvenScout),
    elvenMage(25, true, Race.ELF, null),
    elvenWizard(26, true, Race.ELF, elvenMage),
    spellsinger(27, true, Race.ELF, elvenWizard),
    elementalSummoner(28, true, true, Race.ELF, elvenWizard),
    oracle(29, true, Race.ELF, elvenMage),
    elder(30, true, Race.ELF, oracle),
    darkFighter(31, false, Race.DARK_ELF, null),
    palusKnight(32, false, Race.DARK_ELF, darkFighter),
    shillienKnight(33, false, Race.DARK_ELF, palusKnight),
    bladedancer(34, false, Race.DARK_ELF, palusKnight),
    assassin(35, false, Race.DARK_ELF, darkFighter),
    abyssWalker(36, false, Race.DARK_ELF, assassin),
    phantomRanger(37, false, Race.DARK_ELF, assassin),
    darkMage(38, true, Race.DARK_ELF, null),
    darkWizard(39, true, Race.DARK_ELF, darkMage),
    spellhowler(40, true, Race.DARK_ELF, darkWizard),
    phantomSummoner(41, true, true, Race.DARK_ELF, darkWizard),
    shillienOracle(42, true, Race.DARK_ELF, darkMage),
    shillenElder(43, true, Race.DARK_ELF, shillienOracle),
    orcFighter(44, false, Race.ORC, null),
    orcRaider(45, false, Race.ORC, orcFighter),
    destroyer(46, false, Race.ORC, orcRaider),
    orcMonk(47, false, Race.ORC, orcFighter),
    tyrant(48, false, Race.ORC, orcMonk),
    orcMage(49, true, Race.ORC, null),
    orcShaman(50, true, Race.ORC, orcMage),
    overlord(51, true, Race.ORC, orcShaman),
    warcryer(52, true, Race.ORC, orcShaman),
    dwarvenFighter(53, false, Race.DWARF, null),
    scavenger(54, false, Race.DWARF, dwarvenFighter),
    bountyHunter(55, false, Race.DWARF, scavenger),
    artisan(56, false, Race.DWARF, dwarvenFighter),
    warsmith(57, false, Race.DWARF, artisan),
    dummyEntry1(58, false, null, null),
    dummyEntry2(59, false, null, null),
    dummyEntry3(60, false, null, null),
    dummyEntry4(61, false, null, null),
    dummyEntry5(62, false, null, null),
    dummyEntry6(63, false, null, null),
    dummyEntry7(64, false, null, null),
    dummyEntry8(65, false, null, null),
    dummyEntry9(66, false, null, null),
    dummyEntry10(67, false, null, null),
    dummyEntry11(68, false, null, null),
    dummyEntry12(69, false, null, null),
    dummyEntry13(70, false, null, null),
    dummyEntry14(71, false, null, null),
    dummyEntry15(72, false, null, null),
    dummyEntry16(73, false, null, null),
    dummyEntry17(74, false, null, null),
    dummyEntry18(75, false, null, null),
    dummyEntry19(76, false, null, null),
    dummyEntry20(77, false, null, null),
    dummyEntry21(78, false, null, null),
    dummyEntry22(79, false, null, null),
    dummyEntry23(80, false, null, null),
    dummyEntry24(81, false, null, null),
    dummyEntry25(82, false, null, null),
    dummyEntry26(83, false, null, null),
    dummyEntry27(84, false, null, null),
    dummyEntry28(85, false, null, null),
    dummyEntry29(86, false, null, null),
    dummyEntry30(87, false, null, null),
    duelist(88, false, Race.HUMAN, gladiator),
    dreadnought(89, false, Race.HUMAN, warlord),
    phoenixKnight(90, false, Race.HUMAN, paladin),
    hellKnight(91, false, Race.HUMAN, darkAvenger),
    sagittarius(92, false, Race.HUMAN, hawkeye),
    adventurer(93, false, Race.HUMAN, treasureHunter),
    archmage(94, true, Race.HUMAN, sorceror),
    soultaker(95, true, Race.HUMAN, necromancer),
    arcanaLord(96, true, true, Race.HUMAN, warlock),
    cardinal(97, true, Race.HUMAN, bishop),
    hierophant(98, true, Race.HUMAN, prophet),
    evaTemplar(99, false, Race.ELF, templeKnight),
    swordMuse(100, false, Race.ELF, swordSinger),
    windRider(101, false, Race.ELF, plainsWalker),
    moonlightSentinel(102, false, Race.ELF, silverRanger),
    mysticMuse(103, true, Race.ELF, spellsinger),
    elementalMaster(104, true, true, Race.ELF, elementalSummoner),
    evaSaint(105, true, Race.ELF, elder),
    shillienTemplar(106, false, Race.DARK_ELF, shillienKnight),
    spectralDancer(107, false, Race.DARK_ELF, bladedancer),
    ghostHunter(108, false, Race.DARK_ELF, abyssWalker),
    ghostSentinel(109, false, Race.DARK_ELF, phantomRanger),
    stormScreamer(110, true, Race.DARK_ELF, spellhowler),
    spectralMaster(111, true, true, Race.DARK_ELF, phantomSummoner),
    shillienSaint(112, true, Race.DARK_ELF, shillenElder),
    titan(113, false, Race.ORC, destroyer),
    grandKhavatari(114, false, Race.ORC, tyrant),
    dominator(115, true, Race.ORC, overlord),
    doomcryer(116, true, Race.ORC, warcryer),
    fortuneSeeker(117, false, Race.DWARF, bountyHunter),
    maestro(118, false, Race.DWARF, warsmith),
    dummyEntry31(119, false, null, null),
    dummyEntry32(120, false, null, null),
    dummyEntry33(121, false, null, null),
    dummyEntry34(122, false, null, null),
    maleSoldier(123, false, Race.KAMAEL, null),
    femaleSoldier(124, false, Race.KAMAEL, null),
    trooper(125, false, Race.KAMAEL, maleSoldier),
    warder(126, false, Race.KAMAEL, femaleSoldier),
    berserker(127, false, Race.KAMAEL, trooper),
    maleSoulbreaker(128, false, Race.KAMAEL, trooper),
    femaleSoulbreaker(129, false, Race.KAMAEL, warder),
    arbalester(130, false, Race.KAMAEL, warder),
    doombringer(131, false, Race.KAMAEL, berserker),
    maleSoulhound(132, false, Race.KAMAEL, maleSoulbreaker),
    femaleSoulhound(133, false, Race.KAMAEL, femaleSoulbreaker),
    trickster(134, false, Race.KAMAEL, arbalester),
    inspector(135, false, Race.KAMAEL, warder),
    judicator(136, false, Race.KAMAEL, inspector);

    private final int _id;
    private final boolean _isMage;
    private final boolean _isSummoner;
    private final Race _race;
    private final ClassId _parent;

    private ClassId(int pId, boolean pIsMage, Race race, ClassId pParent) {
        this._id = pId;
        this._isMage = pIsMage;
        this._isSummoner = false;
        this._race = race;
        this._parent = pParent;
    }

    private ClassId(int pId, boolean pIsMage, boolean pIsSummoner, Race race, ClassId pParent) {
        this._id = pId;
        this._isMage = pIsMage;
        this._isSummoner = pIsSummoner;
        this._race = race;
        this._parent = pParent;
    }

    @Override
    public final int getId() {
        return this._id;
    }

    public final boolean isMage() {
        return this._isMage;
    }

    public final boolean isSummoner() {
        return this._isSummoner;
    }

    public final Race getRace() {
        return this._race;
    }

    public final boolean childOf(ClassId cid) {
        if (this._parent == null) {
            return false;
        }
        if (this._parent == cid) {
            return true;
        }
        return this._parent.childOf(cid);
    }

    public final boolean equalsOrChildOf(ClassId cid) {
        return this == cid || this.childOf(cid);
    }

    public final int level() {
        if (this._parent == null) {
            return 0;
        }
        return 1 + this._parent.level();
    }

    public final ClassId getParent() {
        return this._parent;
    }

    public static ClassId getClassId(int cId) {
        try {
            return ClassId.values()[cId];
        }
        catch (Exception e) {
            return null;
        }
    }
}

