/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.buylist;

import com.l2jserver.gameserver.model.buylist.Product;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class L2BuyList {
    private final int _listId;
    private final Map<Integer, Product> _products = new LinkedHashMap<Integer, Product>();
    private Set<Integer> _allowedNpcs = null;

    public L2BuyList(int listId) {
        this._listId = listId;
    }

    public int getListId() {
        return this._listId;
    }

    public Collection<Product> getProducts() {
        return this._products.values();
    }

    public Product getProductByItemId(int itemId) {
        return this._products.get(itemId);
    }

    public void addProduct(Product product) {
        this._products.put(product.getItemId(), product);
    }

    public void addAllowedNpc(int npcId) {
        if (this._allowedNpcs == null) {
            this._allowedNpcs = new HashSet<Integer>();
        }
        this._allowedNpcs.add(npcId);
    }

    public boolean isNpcAllowed(int npcId) {
        if (this._allowedNpcs == null) {
            return false;
        }
        return this._allowedNpcs.contains(npcId);
    }
}

