/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.BaseStat;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.skills.Skill;

public class ConditionPlayerBaseStats
extends Condition {
    private final BaseStat _stat;
    private final int _value;

    public ConditionPlayerBaseStats(L2Character player, BaseStat stat, int value) {
        this._stat = stat;
        this._value = value;
    }

    @Override
    public boolean testImpl(L2Character effector, L2Character effected, Skill skill, L2Item item) {
        if (effector.getActingPlayer() == null) {
            return false;
        }
        L2PcInstance player = effector.getActingPlayer();
        return switch (this._stat) {
            default -> throw new MatchException(null, null);
            case BaseStat.Int -> {
                if (player.getINT() >= this._value) {
                    yield true;
                }
                yield false;
            }
            case BaseStat.Str -> {
                if (player.getSTR() >= this._value) {
                    yield true;
                }
                yield false;
            }
            case BaseStat.Con -> {
                if (player.getCON() >= this._value) {
                    yield true;
                }
                yield false;
            }
            case BaseStat.Dex -> {
                if (player.getDEX() >= this._value) {
                    yield true;
                }
                yield false;
            }
            case BaseStat.Men -> {
                if (player.getMEN() >= this._value) {
                    yield true;
                }
                yield false;
            }
            case BaseStat.Wit -> player.getWIT() >= this._value;
        };
    }
}

