/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;

public class ConditionPlayerCanTakeFort
extends Condition {
    private final boolean _val;

    public ConditionPlayerCanTakeFort(boolean val) {
        this._val = val;
    }

    @Override
    public boolean testImpl(L2Character effector, L2Character effected, Skill skill, L2Item item) {
        Fort fort;
        if (effector == null || !effector.isPlayer()) {
            return !this._val;
        }
        L2PcInstance player = effector.getActingPlayer();
        boolean canTakeFort = true;
        if (player.isAlikeDead() || player.isCursedWeaponEquipped() || !player.isClanLeader()) {
            canTakeFort = false;
        }
        if ((fort = FortManager.getInstance().getFort(player)) == null || fort.getResidenceId() <= 0 || !fort.getSiege().isInProgress() || fort.getSiege().getAttackerClan(player.getClan()) == null) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(skill);
            player.sendPacket(sm);
            canTakeFort = false;
        } else if (fort.getFlagPole() != effected) {
            player.sendPacket(SystemMessageId.INCORRECT_TARGET);
            canTakeFort = false;
        } else if (!Util.checkIfInRange(200, player, effected, true)) {
            player.sendPacket(SystemMessageId.DIST_TOO_FAR_CASTING_STOPPED);
            canTakeFort = false;
        }
        return this._val == canTakeFort;
    }
}

