/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;

public class ConditionPlayerCanUntransform
extends Condition {
    private final boolean _val;

    public ConditionPlayerCanUntransform(boolean val) {
        this._val = val;
    }

    @Override
    public boolean testImpl(L2Character effector, L2Character effected, Skill skill, L2Item item) {
        boolean canUntransform = true;
        L2PcInstance player = effector.getActingPlayer();
        if (player == null) {
            canUntransform = false;
        } else if (player.isAlikeDead() || player.isCursedWeaponEquipped()) {
            canUntransform = false;
        } else if ((player.isTransformed() || player.isInStance()) && player.isFlyingMounted() && !player.isInsideZone(ZoneId.LANDING)) {
            player.sendPacket(SystemMessageId.TOO_HIGH_TO_PERFORM_THIS_ACTION);
            canUntransform = false;
        }
        return this._val == canUntransform;
    }
}

