/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.PlayerState;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.skills.Skill;

public class ConditionPlayerState
extends Condition {
    private final PlayerState _check;
    private final boolean _required;

    public ConditionPlayerState(PlayerState check, boolean required) {
        this._check = check;
        this._required = required;
    }

    @Override
    public boolean testImpl(L2Character effector, L2Character effected, Skill skill, L2Item item) {
        L2PcInstance player = effector.getActingPlayer();
        switch (this._check) {
            case RESTING: {
                if (player != null) {
                    return player.isSitting() == this._required;
                }
                return !this._required;
            }
            case MOVING: {
                return effector.isMoving() == this._required;
            }
            case RUNNING: {
                return effector.isRunning() == this._required;
            }
            case STANDING: {
                if (player != null) {
                    return this._required != (player.isSitting() || player.isMoving());
                }
                return this._required != effector.isMoving();
            }
            case FLYING: {
                return effector.isFlying() == this._required;
            }
            case BEHIND: {
                return effector.isBehindTarget() == this._required;
            }
            case FRONT: {
                return effector.isInFrontOfTarget() == this._required;
            }
            case CHAOTIC: {
                if (player != null) {
                    return player.getKarma() > 0 == this._required;
                }
                return !this._required;
            }
            case OLYMPIAD: {
                if (player != null) {
                    return player.isInOlympiadMode() == this._required;
                }
                return !this._required;
            }
        }
        return !this._required;
    }
}

