/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.ArmorType;
import com.l2jserver.gameserver.model.skills.Skill;

public final class ConditionUsingItemType
extends Condition {
    private final boolean _armor;
    private final int _mask;

    public ConditionUsingItemType(int mask) {
        this._mask = mask;
        this._armor = (this._mask & (ArmorType.MAGIC.mask() | ArmorType.LIGHT.mask() | ArmorType.HEAVY.mask())) != 0;
    }

    @Override
    public boolean testImpl(L2Character effector, L2Character effected, Skill skill, L2Item item) {
        if (effector == null) {
            return false;
        }
        if (!effector.isPlayer()) {
            return !this._armor && (this._mask & effector.getAttackType().mask()) != 0;
        }
        Inventory inv = effector.getInventory();
        if (this._armor) {
            L2ItemInstance chest = inv.getPaperdollItem(6);
            if (chest == null) {
                return false;
            }
            int chestMask = chest.getItem().getItemMask();
            if ((this._mask & chestMask) == 0) {
                return false;
            }
            int chestBodyPart = chest.getItem().getBodyPart();
            if (chestBodyPart == 32768) {
                return true;
            }
            L2ItemInstance legs = inv.getPaperdollItem(11);
            if (legs == null) {
                return false;
            }
            int legMask = legs.getItem().getItemMask();
            return (this._mask & legMask) != 0;
        }
        return (this._mask & inv.getWearedMask()) != 0;
    }
}

